/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.util.ItemHandleHashSet;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamAreaEqualsOperation
extends AttributeOperation {
    private final boolean fInvert;
    private final String DEVELOPMENTLINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");

    public TeamAreaEqualsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        return false;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        Object value = context.getValue();
        if (value instanceof Collection) {
            return this.createPredicate(context, (Collection)value);
        }
        return this.createPredicate(context, (ITeamAreaHandle)value);
    }

    private IPredicate createPredicate(ITransformationContext context, Collection<?> values) throws TeamRepositoryException {
        IPredicate predicate = null;
        for (Object value : values) {
            IPredicate subPredicate = this.createPredicate(context, (ITeamAreaHandle)value);
            predicate = this.joinPredicates(predicate, subPredicate);
        }
        return predicate;
    }

    private IPredicate createPredicate(ITransformationContext context, ITeamAreaHandle teamAreaHandle) throws TeamRepositoryException {
        IQuery query = context.getQuery();
        IDevelopmentLine devLine = context.getAuditableCommon().getDevelopmentLine(teamAreaHandle, null);
        IManyItemQueryModel categoryTeamAreas = (IManyItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.TEAM_AREAS_PROPERTY);
        IDynamicQueryModel target = context.getReference(IWorkItem.TARGET_PROPERTY);
        ISingleItemQueryModel targetDevelopmentLine = (ISingleItemQueryModel)target.getReference(this.DEVELOPMENTLINE_PROPERTY);
        ISingleItemQueryModel categoryDefaultTeamArea = (ISingleItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.DEFAULT_TEAM_AREA_PROPERTY);
        ISingleItemQueryModel category = (ISingleItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY);
        IItemHandleInputArg teamAreaInputArg = query.newItemHandleArg();
        context.addParameter(teamAreaHandle);
        IPredicate predicate = categoryDefaultTeamArea._eq(teamAreaInputArg)._and(target._isNull());
        IPredicate isInTeamAreaList = categoryTeamAreas._contains(teamAreaInputArg);
        if (devLine != null) {
            IItemHandleInputArg devLineInputArg = query.newItemHandleArg();
            context.addParameter(devLine.getItemHandle());
            predicate = predicate._or(isInTeamAreaList._and(targetDevelopmentLine._eq(devLineInputArg)));
        } else {
            predicate = predicate._or(isInTeamAreaList._and(targetDevelopmentLine._isNull()));
        }
        HashMap<ItemHandleHashSet<ITeamAreaHandle>, SubTerm> terms = new HashMap<ItemHandleHashSet<ITeamAreaHandle>, SubTerm>();
        List<ICategory> potentialCategories = this.findCategoriesOfProcessArea(context.getAuditableCommon(), (IProcessAreaHandle)teamAreaHandle, ICategory.DEFAULT_PROFILE);
        for (ICategory cat : potentialCategories) {
            if (!teamAreaHandle.sameItemId((IItemHandle)cat.getDefaultTeamArea())) continue;
            ItemHandleHashSet<ITeamAreaHandle> teamAreas = new ItemHandleHashSet<ITeamAreaHandle>(cat.getAssociatedTeamAreas());
            SubTerm subTerm = (SubTerm)terms.get(teamAreas);
            if (subTerm == null) {
                terms.put(teamAreas, new SubTerm(cat, teamAreas));
                continue;
            }
            subTerm.addCategory(cat);
        }
        HashMap<UUID, IItemHandleInputArg> devLineArgs = new HashMap<UUID, IItemHandleInputArg>();
        for (SubTerm term : terms.values()) {
            Iterator iterator = term.fCategoryList.iterator();
            IItemHandleInputArg catInputArg = query.newItemHandleArg();
            context.addParameter(((ICategory)iterator.next()).getItemHandle());
            IPredicate catPredicate = category._eq(catInputArg);
            while (iterator.hasNext()) {
                catInputArg = query.newItemHandleArg();
                context.addParameter(((ICategory)iterator.next()).getItemHandle());
                catPredicate = catPredicate._or(category._eq(catInputArg));
            }
            HashSet<UUID> excludingDevLines = new HashSet<UUID>(term.fCategoryList.size());
            LinkedList<IItemHandleInputArg> excludingDevLinesHandles = new LinkedList<IItemHandleInputArg>();
            for (ITeamAreaHandle teamArea : term.fTeamAreas) {
                IDevelopmentLine line = context.getAuditableCommon().getDevelopmentLine(teamArea, null);
                if (!excludingDevLines.add(line.getItemId())) continue;
                IItemHandleInputArg inputArg = (IItemHandleInputArg)devLineArgs.get(line.getItemId());
                if (inputArg == null) {
                    inputArg = query.newItemHandleArg();
                    context.addParameter(line.getItemHandle());
                    devLineArgs.put(line.getItemId(), inputArg);
                }
                excludingDevLinesHandles.add(inputArg);
            }
            if (excludingDevLines.isEmpty()) continue;
            catPredicate = catPredicate._and(targetDevelopmentLine._in(excludingDevLinesHandles.toArray(new IItemHandleInputArg[excludingDevLinesHandles.size()]))._not());
            predicate = predicate._or(catPredicate);
        }
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate joinPredicates(IPredicate predicate1, IPredicate predicate2) {
        return predicate1 != null ? (this.isNegation() ? predicate1._and(predicate2) : predicate1._or(predicate2)) : predicate2;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }

    private List<ICategory> findCategoriesOfProcessArea(IAuditableCommon auditableCommon, IProcessAreaHandle processArea, ItemProfile<ICategory> profile) throws TeamRepositoryException {
        QueryIterator<ICategoryHandle> iter = WorkItemQueries.categoriesByProcessArea(auditableCommon, processArea);
        return auditableCommon.resolveAuditablesPermissionAware(iter.toList(null), profile, null);
    }

    @Override
    public boolean supportsMultiValuesPredicate(IQueryableAttribute attribute) {
        return true;
    }

    private static class SubTerm {
        private final List<ICategory> fCategoryList = new LinkedList<ICategory>();
        private final ItemHandleHashSet<ITeamAreaHandle> fTeamAreas;

        public SubTerm(ICategory category, ItemHandleHashSet<ITeamAreaHandle> teamAreas) {
            this.fCategoryList.add(category);
            this.fTeamAreas = teamAreas;
        }

        public void addCategory(ICategory cat) {
            this.fCategoryList.add(cat);
        }
    }
}

