/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.template.AttributeVariable;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateHandle;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkItemTemplateSerializable {
    public static final int TEMPLATE_PARAMETER_ARRAY_LENGTH = 6;
    public static final int TEMPLATE_HANDLE_ARRAY_LENGTH = 6;
    private static final String DEFAULT_STRING_VALUE = "";

    public static Object[] serializeTemplateDescriptor(WorkItemTemplateDescriptor desc) {
        if (desc == null) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_NULL_PARAMETER"));
        }
        Object[] result = new Object[]{desc.getId() != null ? desc.getId() : DEFAULT_STRING_VALUE, desc.getName() != null ? desc.getName() : DEFAULT_STRING_VALUE, desc.getDescription() != null ? desc.getDescription() : DEFAULT_STRING_VALUE, desc.getProjectArea(), WorkItemTemplateSerializable.serializeVariableList(desc.getVariables()), WorkItemTemplateSerializable.serializeWorkItems(desc.getWorkItems())};
        return result;
    }

    public static WorkItemTemplateDescriptor deserializeTemplateDescriptor(Object[] data) {
        if (data == null || data.length != 6 || !(data[0] instanceof String) || !(data[1] instanceof String) || !(data[2] instanceof String) || !(data[3] instanceof IProjectAreaHandle) || data[4] != null && !(data[4] instanceof Object[]) || data[5] != null && !(data[5] instanceof Object[])) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_ILLEGAL_DESCRIPTOR_FORMAT"));
        }
        WorkItemTemplateDescriptor result = new WorkItemTemplateDescriptor((String)data[0], (IProjectAreaHandle)data[3]);
        result.setName((String)data[1]);
        result.setDescription((String)data[2]);
        if (data[4] != null) {
            result.setVariables(WorkItemTemplateSerializable.deserializeVariableList((Object[])data[4]));
        }
        if (data[5] != null) {
            result.setWorkItems(WorkItemTemplateSerializable.deserialzeWorkItems((Object[])data[5]));
        }
        return result;
    }

    public static Object[] serializeTemplateHandle(IWorkItemTemplateHandle templateHandle) {
        if (templateHandle == null) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_NULL_PARAMETER"));
        }
        Object[] result = new Object[]{templateHandle.getId() != null ? templateHandle.getId() : DEFAULT_STRING_VALUE, templateHandle.getName() != null ? templateHandle.getName() : DEFAULT_STRING_VALUE, templateHandle.getDescription() != null ? templateHandle.getDescription() : DEFAULT_STRING_VALUE, templateHandle.getProjectArea(), templateHandle.getOwner(), WorkItemTemplateSerializable.serializeVariableList(templateHandle.getVariables())};
        return result;
    }

    public static IWorkItemTemplateHandle deserializeTemplateHandle(Object[] templateHandle) {
        if (templateHandle == null || templateHandle.length != 6) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_ILLEGAL_TEMPLATE_FORMAT"));
        }
        if (!(templateHandle[0] instanceof String)) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_MISSING_TEMPLATE_ID"));
        }
        if (!(templateHandle[1] instanceof String)) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_MISSING_TEMPLATE_NAME"));
        }
        if (!(templateHandle[2] instanceof String)) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_MISSING_TEMPLATE_DESCRIPTION"));
        }
        if (!(templateHandle[3] instanceof IProjectAreaHandle)) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_MISSING_PROJECT_AREA"));
        }
        if (templateHandle[4] != null && !(templateHandle[4] instanceof IContributorHandle)) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_WRONG_TYPE_FOR_TEMPLATE_OWNER"));
        }
        if (templateHandle[5] != null && !(templateHandle[5] instanceof Object[])) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateSerializable.ERROR_MISSING_WORKITEM_DESCRIPTORS"));
        }
        WorkItemTemplateHandle result = new WorkItemTemplateHandle((String)templateHandle[0], (IProjectAreaHandle)templateHandle[3]);
        result.setName((String)templateHandle[1]);
        result.setDescription((String)templateHandle[2]);
        result.setOwner((IContributorHandle)templateHandle[4]);
        result.setVariables(WorkItemTemplateSerializable.deserializeVariableList((Object[])templateHandle[5]));
        return result;
    }

    public static String[] serializeVariableValues(Map<IAttributeVariable, Object> variableValueMap) {
        ArrayList<String> result = new ArrayList<String>();
        if (variableValueMap != null && !variableValueMap.isEmpty()) {
            for (IAttributeVariable curVariable : variableValueMap.keySet()) {
                result.add(curVariable + WorkItemTemplateSerializable.toString(variableValueMap.get(curVariable)));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof IItemHandle) {
            return ((IItemHandle)o).getItemId().getUuidValue();
        }
        if (o instanceof ILiteral) {
            return ((ILiteral)o).getIdentifier2().getStringIdentifier();
        }
        throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_TYPE"));
    }

    public static Map<IAttributeVariable, String> deserializeVariableValues(String[] variableValueArray) {
        HashMap<IAttributeVariable, String> result = new HashMap<IAttributeVariable, String>();
        if (variableValueArray != null && variableValueArray.length > 0) {
            String[] stringArray = variableValueArray;
            int n = variableValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cur = stringArray[n2];
                String variable = cur.substring(0, cur.indexOf("}") + 1);
                String value = cur.substring(cur.indexOf("}") + 1);
                result.put(new AttributeVariable(variable), value);
                ++n2;
            }
        }
        return result;
    }

    private static Object[] serializeVariableList(List<IAttributeVariable> vars) {
        Object[] result = null;
        if (vars != null && !vars.isEmpty()) {
            result = new Object[vars.size()];
            int idx = 0;
            while (idx < vars.size()) {
                result[idx] = vars.get(idx).getDeclaration();
                ++idx;
            }
        }
        return result;
    }

    private static List<IAttributeVariable> deserializeVariableList(Object[] vars) {
        ArrayList<AttributeVariable> result = null;
        if (vars != null && vars.length > 0) {
            result = new ArrayList<AttributeVariable>();
            Object[] objectArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                Object curVar = objectArray[n2];
                result.add(new AttributeVariable((String)curVar));
                ++n2;
            }
        }
        return result;
    }

    private static Object[] serializeWorkItems(List<IWorkItem> items) {
        Object[] result = null;
        if (items != null && !items.isEmpty()) {
            result = items.toArray(new Object[items.size()]);
        }
        return result;
    }

    private static List<IWorkItem> deserialzeWorkItems(Object[] items) {
        ArrayList<IWorkItem> result = null;
        if (items != null && items.length > 0) {
            result = new ArrayList<IWorkItem>(items.length);
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object cur = objectArray[n2];
                result.add((IWorkItem)cur);
                ++n2;
            }
        }
        return result;
    }
}

