/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.foundation.common.internal.text.HTML2TextReader;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.workitem.api.common.ExtendedRichTextSupport;
import com.ibm.team.workitem.common.internal.util.HTMLOutputHandler;
import com.ibm.team.workitem.common.internal.util.ScanRules;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtendedRichTextHandlers {
    public static final String ERT_ATTR = "rtc:";
    private static final List<String> fgExtendedRichTextTags = Arrays.asList(ExtendedRichTextSupport.TAGS);
    private static final String LT_ESCAPED = "&lt;";
    private static final String GT_ESCAPED = "&gt;";
    private static final String QUOTE_ESCAPED = "&quot;";
    private static final Pattern LT_PATTERN = Pattern.compile("&lt;(?=(.(?<!&gt;))*?rtc:)");
    private static final Pattern GT_PATTERN = Pattern.compile("(?<=rtc:(.(?<!&lt;)){0,5000}?)&gt;");
    private static final Pattern ERT_SUB_PATTERN = Pattern.compile("rtc:");
    private static final Pattern ATTRIBUTE_QUOTE_PATTERN = Pattern.compile("(?<=rtc:(.(?<!&lt;)){0,5000}?)&quot;");

    public static boolean isExtendedRichTextTag(String tag) {
        return fgExtendedRichTextTags.contains(tag);
    }

    public static class DecodingHtmlOutputHandler
    extends HTMLOutputHandler {
        public DecodingHtmlOutputHandler() {
            super(false, Arrays.asList(new ScanRules.LineDelimiterRule(false), new ScanRules.SpaceRule(), new ScanRules.EntityRule(false)));
        }

        @Override
        public void text(CharSequence text) {
            String sanitizedText = this.sanitizeRichTextContent(this.fScanner.escape(text.toString()));
            this.fBuffer.append(sanitizedText);
        }

        public String sanitizeRichTextContent(String text) {
            String sanitizedText = text;
            Matcher tagContentMatcher = LT_PATTERN.matcher(sanitizedText);
            sanitizedText = tagContentMatcher.replaceAll("<");
            tagContentMatcher = GT_PATTERN.matcher(sanitizedText);
            sanitizedText = tagContentMatcher.replaceAll(">");
            tagContentMatcher = ATTRIBUTE_QUOTE_PATTERN.matcher(sanitizedText);
            sanitizedText = tagContentMatcher.replaceAll("\"");
            Matcher ertSubMatcher = ERT_SUB_PATTERN.matcher(sanitizedText);
            sanitizedText = ertSubMatcher.replaceAll("");
            return HTMLOutputHandler.sanitize(XMLString.createFromXMLText((String)sanitizedText), true).toString();
        }
    }

    public static class EncodingHtmlOutputHandler
    extends HTMLOutputHandler {
        private boolean fInBidiElement = false;

        public EncodingHtmlOutputHandler() {
            super(false, Arrays.asList(new ScanRules.LineDelimiterRule(false), new ScanRules.SpaceRule(), new ScanRules.EntityRule(false)));
        }

        @Override
        public String substituteHtml(String html) {
            String tag = HTML2TextReader.tagName((String)html);
            if (ExtendedRichTextHandlers.isExtendedRichTextTag(tag)) {
                this.wrapExtendedRichTextTagContent(html, tag);
                return "";
            }
            return super.substituteHtml(html);
        }

        private void wrapExtendedRichTextTagContent(String html, String tag) {
            boolean start;
            boolean bl = start = !html.equals("/" + tag);
            if (start) {
                this.fBuffer.append("&lt;rtc:" + html + ExtendedRichTextHandlers.GT_ESCAPED);
            } else {
                this.fBuffer.append("&lt;/rtc:" + tag + ExtendedRichTextHandlers.GT_ESCAPED);
            }
        }
    }

    public static class ExtendedRichTextTagRule
    implements HTMLOutputHandler.IScanRule {
        @Override
        public String evaluate(HTMLOutputHandler.Scanner scanner) {
            char[] chars;
            boolean isEndTag;
            boolean bl = isEndTag = scanner.read() == 47;
            if (!isEndTag) {
                scanner.unread();
            }
            if ((chars = scanner.read(ExtendedRichTextHandlers.ERT_ATTR.length())) != null) {
                boolean skipERTTag;
                boolean bl2 = skipERTTag = ExtendedRichTextHandlers.ERT_ATTR.equals(new String(chars)) && this.hasClosingTag(scanner);
                if (!skipERTTag) {
                    scanner.unread(ExtendedRichTextHandlers.ERT_ATTR.length());
                }
            }
            return isEndTag ? "/" : null;
        }

        private boolean hasClosingTag(HTMLOutputHandler.Scanner scanner) {
            int ch;
            boolean found = false;
            int numberOfReads = 0;
            do {
                ch = scanner.read();
                ++numberOfReads;
                boolean bl = found = ch == 62;
            } while (ch != -1 && !found);
            scanner.unread(numberOfReads);
            return found;
        }
    }
}

