/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class IterationsHelper {
    public static final String ITERATION_NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String ITERATION_START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String ITERATION_END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    public static final String PATH_SEPARATOR = "/";
    public static final String PATH_SEPARATOR_REGEX = "(?<!/)/(?!/)";
    public static final String PATH_SEPARATOR_ESCAPED = "//";

    public static IIterationHandle findCurrentMilestone(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IIteration> currentIterations = auditableCommon.findCurrentIterations(developmentLine, monitor);
        return IterationsHelper.findCurrentMilestone(currentIterations);
    }

    private static IIterationHandle findCurrentMilestone(List<IIteration> currentIterations) {
        ListIterator<IIteration> iterator = currentIterations.listIterator(currentIterations.size());
        while (iterator.hasPrevious()) {
            IIteration iteration = iterator.previous();
            if (!iteration.hasDeliverable()) continue;
            return (IIterationHandle)iteration.getItemHandle();
        }
        return null;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createProfile(IProjectArea.ITEM_TYPE, ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")), monitor);
        List<IDevelopmentLine> developmentLines = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine line : developmentLines) {
            iterations.addAll(IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, true, monitor));
        }
        return iterations;
    }

    public static List<IIteration> findAllIterations(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createProfile(IProjectArea.ITEM_TYPE, ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")), monitor);
        List<IDevelopmentLine> developmentLines = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine line : developmentLines) {
            iterations.addAll(IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, false, monitor));
        }
        return iterations;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine line = auditableCommon.resolveAuditable((IAuditableHandle)developmentLine, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        return IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, true, monitor);
    }

    public static List<IIteration> findAllIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationsHelper.findIterations(auditableCommon, parents, profile, includeArchived, true, monitor);
    }

    private static List<IIteration> findIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, boolean requireDeliverable, IProgressMonitor monitor) throws TeamRepositoryException {
        String isArchivedProperty;
        String hasDeliverableProperty;
        String childrenProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"children");
        if (!profile.contains(childrenProperty)) {
            profile = profile.createExtension(Collections.singleton(childrenProperty));
        }
        if (!profile.contains(hasDeliverableProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"hasDeliverable"))) {
            profile = profile.createExtension(Collections.singleton(hasDeliverableProperty));
        }
        if (!profile.contains(isArchivedProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"archived"))) {
            profile = profile.createExtension(Collections.singleton(isArchivedProperty));
        }
        ArrayList<IIteration> all = new ArrayList<IIteration>();
        ArrayList<IIterationHandle> found = new ArrayList<IIterationHandle>(Arrays.asList(parents));
        while (!found.isEmpty()) {
            List<IIteration> list = auditableCommon.resolveAuditablesPermissionAware(found, profile, monitor);
            all.addAll(list);
            found.clear();
            for (IIteration iteration : list) {
                found.addAll(Arrays.asList(iteration.getChildren()));
            }
        }
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            IIteration iteration;
            iteration = (IIteration)iter.next();
            if ((!iteration.isArchived() || includeArchived) && (iteration.hasDeliverable() || !requireDeliverable)) continue;
            iter.remove();
        }
        return all;
    }

    public static List<IDeliverable> findDeliverablesForIteration(IProjectAreaHandle projectAreaHandle, UUID targetIterationUUID, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetIterationUUID == null) {
            return null;
        }
        List<IDeliverable> deliverables = workItemCommon.findDeliverablesByProjectArea(projectAreaHandle, true, IDeliverable.FULL_PROFILE, monitor);
        Collections.sort(deliverables, new DeliverableInverseComparator());
        ArrayList<IDeliverable> matches = new ArrayList<IDeliverable>();
        for (IDeliverable deliverable : deliverables) {
            IIterationHandle deliverableIteration = deliverable.getIteration();
            if (deliverableIteration == null || !deliverableIteration.getItemId().equals((Object)targetIterationUUID)) continue;
            matches.add(deliverable);
        }
        return matches;
    }

    @Deprecated
    public static void setDefaultTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        workItemCommon.setDefaultTeamArea(handle, monitor);
    }

    public static IIteration resolveIterationFromPath(IProcessAreaHandle processAreaHandle, String iterationPath, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IProcessArea processArea = auditableCommon.resolveAuditable((IAuditableHandle)processAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)processArea.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        if (iterationPath == null || iterationPath.length() == 0 || !iterationPath.startsWith(PATH_SEPARATOR)) {
            return null;
        }
        String escapeLiteral = UUID.generate().getUuidValue();
        iterationPath = new StringBuilder(iterationPath).reverse().toString();
        iterationPath = iterationPath.replace(PATH_SEPARATOR_ESCAPED, new StringBuilder(escapeLiteral).reverse().toString());
        StringTokenizer tokenizer = new StringTokenizer((iterationPath = new StringBuilder(iterationPath).reverse().toString()).substring(1), PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        IDevelopmentLineHandle[] lines = projectArea.getDevelopmentLines();
        IDevelopmentLine line = null;
        progress.setWorkRemaining(1 + lines.length);
        IDevelopmentLineHandle[] iDevelopmentLineHandleArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IDevelopmentLineHandle lineHandle = iDevelopmentLineHandleArray[n2];
            IDevelopmentLine iDevelopmentLine = auditableCommon.resolveAuditable((IAuditableHandle)lineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
            if (iDevelopmentLine.getId().equals(token)) {
                line = iDevelopmentLine;
                break;
            }
            ++n2;
        }
        if (line == null) {
            return null;
        }
        IIteration result = null;
        IIterationHandle[] iterations = line.getIterations();
        progress.setWorkRemaining(tokenizer.countTokens() * iterations.length);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
            IIteration current = null;
            List<IIteration> items = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(iterations), ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(iterations.length));
            for (IIteration iIteration : items) {
                if (!token.equals(iIteration.getId())) continue;
                current = iIteration;
                break;
            }
            if (current != null && !tokenizer.hasMoreTokens()) {
                result = current;
                continue;
            }
            if (current == null) {
                return null;
            }
            iterations = current.getChildren();
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    public static IIterationHandle[] findIterationsForDeliverables(IProjectAreaHandle projectArea, List<IDeliverableHandle> deliverableHandles, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        ItemProfile deliverableProfile = ItemProfile.createProfile(IDeliverable.ITEM_TYPE, IDeliverable.ITERATION_PROPERTY);
        ArrayList<IIterationHandle> iterations = new ArrayList<IIterationHandle>();
        List deliverables = auditableCommon.resolveAuditables(deliverableHandles, deliverableProfile, monitor);
        for (IDeliverable deliverable : deliverables) {
            IIterationHandle iteration = deliverable.getIteration();
            if (iteration == null) continue;
            iterations.add(iteration);
        }
        Set<UUID> iterationsWithDeliverable = IterationsHelper.getIterationsWithDeliverable(projectArea, workItemCommon, monitor);
        IIterationHandle[] iIterationHandleArray = iterations.toArray(new IIterationHandle[iterations.size()]);
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle iterationH = iIterationHandleArray[n2];
            IIteration iteration = auditableCommon.resolveAuditable((IAuditableHandle)iterationH, ItemProfile.ITERATION_DEFAULT, null);
            IterationsHelper.addChildIterationsWithNoDeliverable(iteration, iterations, iterationsWithDeliverable, new HashSet<UUID>(), workItemCommon);
            ++n2;
        }
        return iterations.toArray(new IIterationHandle[iterations.size()]);
    }

    private static Set<UUID> getIterationsWithDeliverable(IProjectAreaHandle projectArea, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<UUID> iterationsWithDeliverable = new HashSet<UUID>();
        ItemProfile<IDeliverable> deliverableProfile = ItemProfile.createProfile(IDeliverable.ITEM_TYPE, IDeliverable.ITERATION_PROPERTY);
        List<IDeliverable> allProjectDeliverables = workItemCommon.findDeliverablesByProjectArea(projectArea, true, deliverableProfile, monitor);
        for (IDeliverable deliverable : allProjectDeliverables) {
            if (deliverable.getIteration() == null) continue;
            iterationsWithDeliverable.add(deliverable.getIteration().getItemId());
        }
        return iterationsWithDeliverable;
    }

    private static void addChildIterationsWithNoDeliverable(IIteration iteration, List<IIterationHandle> childrenWithNoDeliverables, Set<UUID> iterationsWithDeliverable, Set<UUID> visitedIterations, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        visitedIterations.add(iteration.getItemId());
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        IIterationHandle[] iIterationHandleArray = iteration.getChildren();
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle childIterationH = iIterationHandleArray[n2];
            if (!iterationsWithDeliverable.contains(childIterationH.getItemId())) {
                childrenWithNoDeliverables.add(childIterationH);
                if (!visitedIterations.contains(childIterationH.getItemId())) {
                    IIteration childIteration = auditableCommon.resolveAuditable((IAuditableHandle)childIterationH, ItemProfile.ITERATION_DEFAULT, null);
                    IterationsHelper.addChildIterationsWithNoDeliverable(childIteration, childrenWithNoDeliverables, iterationsWithDeliverable, visitedIterations, workItemCommon);
                }
            }
            ++n2;
        }
    }

    public static IDeliverable resolveDeliverableFromIteration(IProjectAreaHandle projectAreaHandle, IIterationHandle targetIteration, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetIteration == null) {
            return null;
        }
        List<IDeliverable> deliverables = workItemCommon.findDeliverablesByProjectArea(projectAreaHandle, true, IDeliverable.FULL_PROFILE, monitor);
        Collections.sort(deliverables, new DeliverableInverseComparator());
        UUID targetIterationUUID = targetIteration.getItemId();
        for (IDeliverable deliverable : deliverables) {
            IIterationHandle deliverableIteration = deliverable.getIteration();
            if (deliverableIteration == null || !deliverableIteration.getItemId().equals((Object)targetIterationUUID)) continue;
            return deliverable;
        }
        IIteration resolvedIteration = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)targetIteration, ItemProfile.ITERATION_DEFAULT, null);
        Map<UUID, IIteration> iterationMap = IterationsHelper.getAncestorMapForIteration(workItemCommon, projectAreaHandle, resolvedIteration, ItemProfile.ITERATION_DEFAULT);
        IDeliverable bestMatch = null;
        int bestMatchLevel = Integer.MAX_VALUE;
        for (IDeliverable deliverable : deliverables) {
            IIterationHandle deliverableIterationHandle = deliverable.getIteration();
            if (deliverableIterationHandle == null) continue;
            int level = 0;
            IIteration iteration = resolvedIteration;
            IIterationHandle parentIteration = iteration.getParent();
            while (parentIteration != null && level < bestMatchLevel) {
                iteration = iterationMap.get(parentIteration.getItemId());
                if (iteration.getItemId().equals((Object)deliverableIterationHandle.getItemId())) {
                    if (level == 0) {
                        return deliverable;
                    }
                    bestMatchLevel = level;
                    bestMatch = deliverable;
                    continue;
                }
                parentIteration = iteration.getParent();
                ++level;
            }
        }
        return bestMatch;
    }

    private static Map<UUID, IIteration> getAncestorMapForIteration(IWorkItemCommon workItemCommon, IProjectAreaHandle projectAreaHandle, IIteration targetIteration, ItemProfile<IIteration> profile) throws TeamRepositoryException {
        HashMap<UUID, IIteration> iterationMap = new HashMap<UUID, IIteration>();
        IIteration iteration = targetIteration;
        iterationMap.put(iteration.getItemId(), iteration);
        while (iteration.getParent() != null) {
            iteration = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)iteration.getParent(), ItemProfile.ITERATION_DEFAULT, null);
            iterationMap.put(iteration.getItemId(), iteration);
        }
        return iterationMap;
    }

    public static String createIterationPath(IIterationHandle iterationHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IIteration current = null;
        while (iterationHandle != null) {
            current = auditableCommon.resolveAuditable((IAuditableHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(1));
            result.insert(0, current.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
            result.insert(0, PATH_SEPARATOR);
            iterationHandle = current.getParent();
        }
        Assert.isNotNull(current);
        IDevelopmentLine timeline = auditableCommon.resolveAuditable((IAuditableHandle)current.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
        result.insert(0, timeline.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
        result.insert(0, PATH_SEPARATOR);
        return result.toString();
    }

    private static final class DeliverableInverseComparator
    implements Comparator<IDeliverable> {
        private DeliverableInverseComparator() {
        }

        @Override
        public int compare(IDeliverable deliverable1, IDeliverable deliverable2) {
            int seq1 = ((Deliverable)deliverable1).getSequenceValue();
            int seq2 = ((Deliverable)deliverable2).getSequenceValue();
            return seq2 - seq1;
        }
    }
}

