/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.query;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IQueryEvent;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.internal.util.ServerListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;

public class QueryDescriptorEvents {
    private static QueryDescriptorEvents fgInstance;
    private ServerListener fServerListener = new ServerListener(){

        @Override
        protected void repositoryAdded(ITeamRepository repository) {
            QueryDescriptorEvents.this.addQueryListeners(repository);
        }

        @Override
        protected void repositoryRemoved(ITeamRepository repository) {
            QueryDescriptorEvents.this.removeQueryListeners(repository);
        }

        @Override
        protected void repositoryLogin(ITeamRepository repository) {
        }

        @Override
        protected void repositoryLogout(ITeamRepository repository) {
        }
    };
    private IQueryListener fDispatcher = new IQueryListener(){

        public void handleEvents(List events) {
            Object[] objectArray = QueryDescriptorEvents.this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IQueryListener listener = (IQueryListener)object;
                List<IEvent> filteredEvents = this.filterEvents(listener, events);
                if (!filteredEvents.isEmpty()) {
                    listener.handleEvents(filteredEvents);
                }
                ++n2;
            }
        }

        private List<IEvent> filterEvents(IQueryListener listener, List<IEvent> events) {
            ArrayList<IEvent> filtered = new ArrayList<IEvent>(events.size());
            Set categories = (Set)QueryDescriptorEvents.this.fCategoriesMap.get(listener);
            block0: for (IEvent event : events) {
                for (Object category : event.getCategories()) {
                    if (!categories.contains(category)) continue;
                    filtered.add(event);
                    continue block0;
                }
            }
            return filtered;
        }
    };
    private final ListenerList fListeners = new ListenerList();
    private final ConcurrentHashMap<IQueryListener, Set<Object>> fCategoriesMap = new ConcurrentHashMap();

    public static QueryDescriptorEvents getInstance() {
        if (fgInstance == null) {
            fgInstance = new QueryDescriptorEvents();
        }
        return fgInstance;
    }

    private QueryDescriptorEvents() {
        ITeamRepository[] repositories;
        this.fServerListener.install();
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.addQueryListeners(repository);
            ++n2;
        }
    }

    public void addQueryListener(Object category, IQueryListener listener) {
        Assert.isNotNull((Object)category);
        Assert.isNotNull((Object)listener);
        this.addCategory(listener, category);
        this.fListeners.add((Object)listener);
    }

    public void addQueryListener(IQueryListener listener) {
        Assert.isNotNull((Object)listener);
        String[] stringArray = IQueryEvent.ALL_EVENTS;
        int n = IQueryEvent.ALL_EVENTS.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            this.addCategory(listener, category);
            ++n2;
        }
        this.fListeners.add((Object)listener);
    }

    public void removeQueryListener(Object category, IQueryListener listener) {
        Assert.isNotNull((Object)category);
        Assert.isNotNull((Object)listener);
        Set<Object> categories = this.fCategoriesMap.get(listener);
        if (categories != null) {
            categories.remove(category);
        }
        if (categories == null || categories.isEmpty()) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void removeQueryListener(IQueryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fCategoriesMap.remove(listener);
        this.fListeners.remove((Object)listener);
    }

    private void addCategory(IQueryListener listener, Object category) {
        Set<Object> categories = this.fCategoriesMap.get(listener);
        if (categories == null) {
            categories = new HashSet<Object>();
            this.fCategoriesMap.put(listener, categories);
        }
        categories.add(category);
    }

    private void addQueryListeners(ITeamRepository repository) {
        IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
        String[] stringArray = IQueryEvent.ALL_EVENTS;
        int n = IQueryEvent.ALL_EVENTS.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            queryClient.addQueryListener(category, this.fDispatcher);
            ++n2;
        }
    }

    private void removeQueryListeners(ITeamRepository repository) {
        IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
        String[] stringArray = IQueryEvent.ALL_EVENTS;
        int n = IQueryEvent.ALL_EVENTS.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            queryClient.removeQueryListener(category, this.fDispatcher);
            ++n2;
        }
    }
}

