/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.configuration.IComponentConfiguration;
import com.ibm.team.rtc.common.configuration.IComponentConfigurationService;
import com.ibm.team.rtc.common.configuration.IConfiguration;
import com.ibm.team.rtc.common.internal.configuration.Configuration;
import com.ibm.team.rtc.common.internal.configuration.ConfigurationFactory;
import com.ibm.team.workitem.client.IComponentConfigurationClient;
import com.ibm.team.workitem.client.internal.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComponentConfigurationClient
implements IComponentConfigurationClient {
    private final IClientLibraryContext fContext;
    private final Map<String, IComponentConfiguration> fComponentConfigurations = new ConcurrentHashMap<String, IComponentConfiguration>();
    private volatile boolean fInitialized = false;

    public ComponentConfigurationClient(IClientLibraryContext context) {
        this.fContext = context;
        this.fContext.teamRepository().addLoginParticipant((ITeamRepository.ILoginParticipant)new LogInParticipant());
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.ComponentConfigurationClient_FETCHING_COMPONENT_CONFIGURATIONS, 1);
        this.fetchConfigurations();
        monitor.done();
    }

    @Override
    public IConfiguration getConfiguration(String componentId, String configurationName, String defaultValue) {
        IComponentConfiguration componentConfiguration = this.fComponentConfigurations.get(componentId);
        if (componentConfiguration == null || componentConfiguration.getConfiguration(configurationName) == null) {
            FoundationLog.getLog((String)"com.ibm.team.workitem.client").warn(NLS.bind((String)Messages.ComponentConfigurationClient_MISSING_CONFIGURATION, (Object)configurationName, (Object[])new Object[0]), null);
            Configuration configuration = ConfigurationFactory.eINSTANCE.createConfiguration();
            configuration.setName(configurationName);
            configuration.setValue(defaultValue);
            return configuration;
        }
        return componentConfiguration.getConfiguration(configurationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchConfigurations() {
        if (this.fInitialized) {
            return;
        }
        Map<String, IComponentConfiguration> map = this.fComponentConfigurations;
        synchronized (map) {
            if (this.fInitialized) {
                return;
            }
            IComponentConfigurationService service = (IComponentConfigurationService)this.fContext.getServiceInterface(IComponentConfigurationService.class);
            HashMap<String, IComponentConfiguration> configurations = new HashMap<String, IComponentConfiguration>();
            IComponentConfiguration[] iComponentConfigurationArray = service.getAllConfigurations();
            int n = iComponentConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IComponentConfiguration configuration = iComponentConfigurationArray[n2];
                configurations.put(configuration.getComponentId(), configuration);
                ++n2;
            }
            this.fComponentConfigurations.clear();
            this.fComponentConfigurations.putAll(configurations);
            this.fInitialized = true;
        }
    }

    private class LogInParticipant
    implements ITeamRepository.ILoginParticipant {
        private LogInParticipant() {
        }

        public void handleLogin(ITeamRepository repository) {
            ComponentConfigurationClient.this.fetchConfigurations();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleLogout(ITeamRepository repository) {
            Map map = ComponentConfigurationClient.this.fComponentConfigurations;
            synchronized (map) {
                ComponentConfigurationClient.this.fComponentConfigurations.clear();
                ComponentConfigurationClient.this.fInitialized = false;
            }
        }
    }
}

