/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.client.IInformationArtifactFactory;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.InformationArtifactAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemInformationArtifactFactory
implements IInformationArtifactFactory {
    private static final String WORKITEM_TYPE = String.valueOf(IWorkItem.ITEM_TYPE.getNamespaceURI()) + "." + IWorkItem.ITEM_TYPE.getName();
    private static final String ATTACHMENT_TYPE = String.valueOf(IAttachment.ITEM_TYPE.getNamespaceURI()) + "." + IAttachment.ITEM_TYPE.getName();
    private static final String QUERY_TYPE = String.valueOf(IQueryDescriptor.ITEM_TYPE.getNamespaceURI()) + "." + IQueryDescriptor.ITEM_TYPE.getName();

    public IInformationArtifact create(IItem item, boolean isDelete, IProgressMonitor monitor) {
        if (item instanceof IQueryDescriptor && this.shouldIndex((IQueryDescriptor)item)) {
            return this.handleQuery((IQueryDescriptor)item);
        }
        if (item instanceof IWorkItem && this.shouldIndex((IWorkItem)item)) {
            return this.handleWorkItem((IWorkItem)item);
        }
        if (item instanceof IAttachment && this.shouldIndex((IAttachment)item)) {
            return this.handleAttachment((IAttachment)item);
        }
        return null;
    }

    private IInformationArtifact handleQuery(IQueryDescriptor query) {
        ITeamRepository repository;
        IItem projectArea;
        Location location = Location.itemLocation((IItemHandle)query, (String)((ITeamRepository)query.getOrigin()).getRepositoryURI());
        String name = query.getName();
        if (query.isPropertySet(IQueryDescriptor.PROJECTAREA_PROPERTY) && query.getProjectArea() != null && query.getOrigin() instanceof ITeamRepository && (projectArea = (repository = (ITeamRepository)query.getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)query.getProjectArea())) instanceof IProjectArea && projectArea.isPropertySet("name")) {
            name = NLS.bind((String)Messages.WorkItemInformationArtifactFactory_NAME_PROJECTAREA, (Object)query.getName(), (Object[])new Object[]{((IProjectArea)projectArea).getName()});
        }
        URIReference reference = new URIReference(name, "", QUERY_TYPE, location.toAbsoluteUri());
        InformationArtifactAdapter artifact = query.isPropertySet(IQueryDescriptor.DESCRIPTION_PROPERTY) && query.getDescription() != null ? new InformationArtifactAdapter(reference, name, (Reader)new StringReader(query.getDescription())) : new InformationArtifactAdapter(reference, name);
        artifact.setContext(query.getContextId());
        if (query.isPropertySet(IQueryDescriptor.PROJECTAREA_PROPERTY) && query.getProjectArea() != null) {
            artifact.setOwner(query.getProjectArea().getItemId());
        }
        return artifact;
    }

    private boolean shouldIndex(IQueryDescriptor query) {
        return query.isPropertySet(IQueryDescriptor.NAME_PROPERTY) && query.getName() != null && query.getName().length() > 0;
    }

    private IInformationArtifact handleWorkItem(IWorkItem workitem) {
        IItem projectArea;
        IItem foundIn;
        IItem plannedFor;
        IItem category;
        IItem owner;
        IItem modifier;
        IItem resolver;
        IItem creator;
        ITeamRepository teamRepository = (ITeamRepository)workitem.getOrigin();
        Location location = Location.itemLocation((IItemHandle)workitem, (String)teamRepository.getRepositoryURI());
        String summary = NLS.bind((String)Messages.WorkItemInformationArtifactFactory_ID_SUMMARY, (Object)workitem.getId(), (Object[])new Object[]{workitem.getHTMLSummary().getPlainText()});
        URIReference reference = new URIReference(summary, "", WORKITEM_TYPE, location.toAbsoluteUri());
        StringBuilder content = new StringBuilder();
        StringBuilder tags = new StringBuilder();
        StringBuilder meta = new StringBuilder();
        if (workitem.getHTMLDescription() != null) {
            content.append(workitem.getHTMLDescription().getPlainText());
        }
        if (workitem.getComments() != null) {
            IComment[] comments = workitem.getComments().getContents();
            content.append("\n");
            int i = 0;
            while (i < comments.length) {
                content.append(comments[i].getHTMLContent().getPlainText());
                content.append("\n");
                ++i;
            }
        }
        if (workitem.getTags2() != null) {
            List tags2 = workitem.getTags2();
            for (String tag : tags2) {
                tags.append(tag).append("\n");
            }
        }
        HashSet<String> metaValues = new HashSet<String>();
        metaValues.add(String.valueOf(workitem.getId()));
        if (workitem.getCreator() != null && (creator = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getCreator())) instanceof IContributor && creator.isPropertySet(IContributor.NAME_PROPERTY)) {
            metaValues.add(((IContributor)creator).getName());
        }
        if (workitem.getResolver() != null && (resolver = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getResolver())) instanceof IContributor && resolver.isPropertySet(IContributor.NAME_PROPERTY)) {
            metaValues.add(((IContributor)resolver).getName());
        }
        if (workitem.getModifiedBy() != null && (modifier = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getModifiedBy())) instanceof IContributor && modifier.isPropertySet(IContributor.NAME_PROPERTY)) {
            metaValues.add(((IContributor)modifier).getName());
        }
        if (workitem.getOwner() != null && (owner = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getOwner())) instanceof IContributor && owner.isPropertySet(IContributor.NAME_PROPERTY)) {
            metaValues.add(((IContributor)owner).getName());
        }
        if (workitem.getCategory() != null && (category = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getCategory())) instanceof ICategory && category.isPropertySet(ICategory.NAME_PROPERTY)) {
            metaValues.add(((ICategory)category).getName());
        }
        if (workitem.getTarget() != null && (plannedFor = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getTarget())) instanceof IIteration) {
            if (plannedFor.isPropertySet("name")) {
                metaValues.add(((IIteration)plannedFor).getName());
            }
            if (plannedFor.isPropertySet("id")) {
                metaValues.add(((IIteration)plannedFor).getId());
            }
        }
        if (((WorkItem)workitem).getFoundIn() != null && (foundIn = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)((WorkItem)workitem).getFoundIn())) instanceof IDeliverable && foundIn.isPropertySet(IDeliverable.NAME_PROPERTY)) {
            metaValues.add(((IDeliverable)foundIn).getName());
        }
        if (workitem.getProjectArea() != null && (projectArea = teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)workitem.getProjectArea())) instanceof IProjectArea && projectArea.isPropertySet("name")) {
            metaValues.add(((IProjectArea)projectArea).getName());
        }
        for (String metaValue : metaValues) {
            if (metaValue == null || metaValue.length() <= 0) continue;
            meta.append(metaValue).append("\n");
        }
        InformationArtifactAdapter artifact = new InformationArtifactAdapter(reference, summary, (Reader)new StringReader(content.toString()), tags.toString(), meta.toString());
        artifact.setContext(workitem.getContextId());
        if (workitem.getProjectArea() != null) {
            artifact.setOwner(workitem.getProjectArea().getItemId());
        }
        return artifact;
    }

    private boolean shouldIndex(IWorkItem item) {
        return item.isComplete() && item.getHTMLSummary() != null;
    }

    private IInformationArtifact handleAttachment(IAttachment attachment) {
        Location location = Location.itemLocation((IItemHandle)attachment, (String)((ITeamRepository)attachment.getOrigin()).getRepositoryURI());
        URIReference reference = new URIReference(attachment.getName(), "", ATTACHMENT_TYPE, location.toAbsoluteUri());
        InformationArtifactAdapter artifact = attachment.isPropertySet(IAttachment.DESCRIPTION_PROPERTY) && attachment.getDescription() != null ? new InformationArtifactAdapter(reference, attachment.getName(), (Reader)new StringReader(attachment.getDescription())) : new InformationArtifactAdapter(reference, attachment.getName());
        artifact.setContext(attachment.getContextId());
        if (attachment.isPropertySet(IAttachment.PROJECT_AREA_PROPERTY) && attachment.getProjectArea() != null) {
            artifact.setOwner(attachment.getProjectArea().getItemId());
        }
        return artifact;
    }

    private boolean shouldIndex(IAttachment attachment) {
        return attachment.isPropertySet(IAttachment.NAME_PROPERTY) && attachment.getName() != null && attachment.getName().length() > 0;
    }
}

