/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.xml;

import com.urbancode.air.plugin_command.Arg;
import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.CommandLine;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.commons.xml.marshall.MarshallingRuntimeException;
import com.urbancode.commons.xml.marshall.XmlMarshallerBase;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class CommandLineXmlMarshaller
extends XmlMarshallerBase {
    public static final String PROGRAM_ATTRIBUTE = "program";
    public static final String ARG_ELEMENT = "arg";
    public static final String ARG_VALUE_ATTRIBUTE = "value";
    public static final String ARG_FILE_ATTRIBUTE = "file";
    public static final String ARG_PATH_ATTRIBUTE = "path";
    private static final Logger logger = Logger.getLogger(CommandLineXmlMarshaller.class);

    public CommandLineXmlMarshaller() {
        super("command");
    }

    public void unmarshall(Element element, MarshallingContext context) throws MarshallingRuntimeException {
        logger.debug((Object)("Unmarshalling '" + element.getNodeName() + "'."));
        String program = DOMUtils.getAttribute((Element)element, (String)PROGRAM_ATTRIBUTE);
        LinkedList<Arg> args = new LinkedList<Arg>();
        List argElements = DOMUtils.getChildElementList((Element)element, (String)ARG_ELEMENT);
        for (Element argElement : argElements) {
            String argValue = DOMUtils.getAttribute((Element)argElement, (String)ARG_VALUE_ATTRIBUTE);
            if (argValue != null) {
                args.add(new Arg(argValue, Arg.ArgType.VALUE));
                continue;
            }
            argValue = DOMUtils.getAttribute((Element)argElement, (String)ARG_FILE_ATTRIBUTE);
            if (argValue != null) {
                args.add(new Arg(argValue, Arg.ArgType.FILE));
                continue;
            }
            argValue = DOMUtils.getAttribute((Element)argElement, (String)ARG_PATH_ATTRIBUTE);
            if (argValue == null) continue;
            args.add(new Arg(argValue, Arg.ArgType.PATH));
        }
        Command command = (Command)context.get();
        command.setCommand(new CommandLine(program, args));
    }
}

