/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common;

import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class BuildableSubsetQuery {
    public static String getBuildableSubsetHandlesQuery(String buildDefinitionUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?ownerId ?visibility\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append("?resource subset:ownerId ?ownerId. \n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getOldBuildableSubsetHandlesQuery(String buildDefinitionUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?ownerId ?visibility\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append("?resource subset:ownerId ?ownerId. \n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getOldBuildableSubsetCountQuery() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT (COUNT(?label) AS ?NumSubsets)\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("FILTER NOT EXISTS{?resource subset:buildDefinitionUUID ?buildDefinitionUUID}");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getBuildableSubsetHandlesQueryPre403(String buildDefinitionUUID, String ownerId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label (COALESCE(?owner, \"_---------------------A\") AS ?ownerId) ?visibility \n");
        buffer.append("WHERE { \n  ");
        buffer.append("{\n");
        buffer.append("?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("OPTIONAL {?resource subset:ownerId ?owner}\n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append("?resource subset:visibility \"PUBLIC\". \n");
        buffer.append("}\n");
        buffer.append("UNION \n");
        buffer.append("{\n");
        buffer.append(" ?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append(" ?resource subset:label ?label. \n");
        buffer.append("?resource subset:ownerId ?owner. \n");
        buffer.append(" ?resource subset:ownerId \"" + ownerId + "\".\n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append(" ?resource subset:visibility \"PRIVATE\". \n");
        buffer.append("}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getBuildableSubsetHandlesQuery(String buildDefinitionUUID, String ownerId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?ownerId ?visibility \n");
        buffer.append("WHERE { \n  ");
        buffer.append("{\n");
        buffer.append("?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("OPTIONAL {?resource subset:ownerId ?ownerId}\n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append("?resource subset:visibility \"PUBLIC\". \n");
        buffer.append("}\n");
        buffer.append("UNION \n");
        buffer.append("{\n");
        buffer.append(" ?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append(" ?resource subset:label ?label. \n");
        buffer.append("?resource subset:ownerId ?ownerId. \n");
        buffer.append(" ?resource subset:ownerId \"" + ownerId + "\".\n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append(" ?resource subset:visibility \"PRIVATE\". \n");
        buffer.append("}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getMySharedBuildableSubsetHandlesQuery(String buildDefinitionUUID, String ownerId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?ownerId ?visibility\n");
        buffer.append("WHERE { \n  ");
        buffer.append("{\n");
        buffer.append(" ?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append(" FILTER ( NOT EXISTS {?resource subset:ownerId ?ownerId2})\n");
        buffer.append(" ?resource subset:label ?label. \n");
        buffer.append(" ?resource subset:visibility \"PUBLIC\". \n");
        buffer.append("}\n");
        buffer.append("UNION \n");
        buffer.append("{\n");
        buffer.append(" ?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append(" ?resource subset:ownerId ?ownerId . FILTER (?ownerId != \"" + ownerId + "\")\n");
        buffer.append(" ?resource subset:label ?label. \n");
        buffer.append(" ?resource subset:visibility \"PUBLIC\". \n");
        buffer.append("}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getMyBuildableSubsetHandlesQuery(String buildDefinitionUUID, String ownerId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?ownerId ?visibility\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:buildDefinitionUUID \"" + buildDefinitionUUID + "\"" + ".\n");
        buffer.append("?resource subset:ownerId \"" + ownerId + "\"" + ".\n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("?resource subset:visibility ?visibility. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getOldBuildableSubsetsQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?workspaceUUID \n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:workspaceUUID ?workspaceUUID.\n");
        buffer.append("?resource subset:label ?label. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAllBuildableSubsetsQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?buildDefinitionUUID ?ownerId ?visibility\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:buildDefinitionUUID ?buildDefinitionUUID . \n");
        buffer.append("OPTIONAL {?resource subset:ownerId ?ownerId}\n");
        buffer.append("?resource subset:label ?label . \n");
        buffer.append("?resource subset:visibility ?visibility . \n");
        buffer.append("OPTIONAL {?resource subset:workspaceUUID ?workspaceUUID .}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getNewBuildableSubsetSlugQuery(String oldSlug) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX bsm: <http://www.ibm.com/team/enterprise/buildablesubset/mappings> \n");
        buffer.append("SELECT ?newSlug \n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource bsm:oldSlug \"" + oldSlug + "\"" + ".\n");
        buffer.append("?resource bsm:newSlug ?newSlug. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAllBuildableSubsetSlugMappingQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX bsm: <http://www.ibm.com/team/enterprise/buildablesubset/mappings> \n");
        buffer.append("select ?oldSlug ?newSlug \n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource bsm:oldSlug ?oldSlug .\n");
        buffer.append("?resource bsm:newSlug ?newSlug. \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAllBuildableSubsetsWithDescriptionQuery() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("PREFIX subset: <http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/> \n");
        buffer.append("SELECT ?label ?buildDefinitionUUID ?description\n");
        buffer.append("WHERE { \n  ");
        buffer.append("?resource subset:buildDefinitionUUID ?buildDefinitionUUID . \n");
        buffer.append("?resource subset:label ?label . \n");
        buffer.append("?resource subset:description ?description . \n");
        buffer.append("FILTER (?description != \"\" ) . \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAllTransitoryFileListsPriorToThisDateQuery(String repositoryLocation, Date date) throws TeamRepositoryException {
        try {
            String repositoryUri = repositoryLocation.endsWith("/") ? repositoryLocation : String.valueOf(repositoryLocation) + "/";
            String isPartOf = String.valueOf(repositoryUri) + "storage/" + "team_enterprise_transitory_filelist";
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formater.setTimeZone(new SimpleTimeZone(0, "GMT"));
            String targetDate = formater.format(date);
            StringBuilder buffer = new StringBuilder(200);
            buffer.append("PREFIX dc: <http://purl.org/dc/terms/> \n");
            buffer.append("PREFIX fn: <http://www.w3.org/2005/xpath-functions> \n");
            buffer.append("PREFIX jazz:  <http://jazz.net/xmlns/foundation/1.0/> \n");
            buffer.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
            buffer.append("SELECT ?resourceLocation\n");
            buffer.append("WHERE { \n  ");
            buffer.append("  ?resource dc:isPartOf <" + isPartOf + "> . \n");
            buffer.append("  ?resource dc:modified ?modified . \n");
            buffer.append("  ?resource jazz:resourceLocation ?resourceLocation .\n");
            buffer.append("     FILTER ( ?modified < xsd:dateTime(\"" + targetDate + "\"))\n");
            buffer.append("}\n");
            return buffer.toString();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }
}

