/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.internal.ServiceInterfaceProxy;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.transport.ITeamRestService;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class RestServiceClientProxy
implements InvocationHandler {
    private final ITeamRestServiceClient delegate;
    private final TeamRepository repository;

    static Object newRestServiceClientProxy(Class<? extends ITeamRestService> serviceInterface, ITeamRestServiceClient delegate, TeamRepository repository) {
        return Proxy.newProxyInstance(ITeamRestServiceClient.class.getClassLoader(), new Class[]{ITeamRestServiceClient.class}, (InvocationHandler)new RestServiceClientProxy(delegate, repository));
    }

    private RestServiceClientProxy(ITeamRestServiceClient delegate, TeamRepository repository) {
        this.delegate = delegate;
        this.repository = repository;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        try {
            result = method.invoke((Object)this.delegate, args);
        }
        finally {
            if (result instanceof ITeamRestServiceClient.IRestClientConnection) {
                result = this.newRestClientConnectionProxy((ITeamRestServiceClient.IRestClientConnection)result);
            }
        }
        return result;
    }

    private ITeamRestServiceClient.IRestClientConnection newRestClientConnectionProxy(ITeamRestServiceClient.IRestClientConnection delegateConnection) {
        return (ITeamRestServiceClient.IRestClientConnection)Proxy.newProxyInstance(ITeamRestServiceClient.class.getClassLoader(), new Class[]{ITeamRestServiceClient.IRestClientConnection.class}, (InvocationHandler)new RestClientConnectionProxy(delegateConnection, this.repository));
    }

    private static class RestClientConnectionProxy
    extends ServiceInterfaceProxy
    implements InvocationHandler {
        private final ITeamRestServiceClient.IRestClientConnection delegate;

        private RestClientConnectionProxy(ITeamRestServiceClient.IRestClientConnection delegate, TeamRepository repository) {
            super(delegate, delegate.getServiceUri(), repository);
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == ITeamRestServiceClient.IRestClientConnection.class && method.getName().startsWith("do")) {
                return super.invoke(proxy, method, args);
            }
            try {
                return method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw new Throwable(String.format("Error on proxy target invocation, with no cause. InvocationException message: %s", e.getMessage()));
            }
        }
    }
}

