/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal.login;

import com.ibm.team.repository.client.internal.nls.Messages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Properties;

public class KerberosLoginUtils {
    private static final String IBM_JRE_JGSSAPI_DEBUG = "com.ibm.security.jgss.debug";
    private static final String IBM_JRE_KRB5_DEBUG = "com.ibm.security.krb5.Krb5Debug";
    private static final String SUN_JRE_JGSSAPI_DEBUG = "sun.security.jgss.debug";
    private static final String SUN_JRE_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final boolean KERBEROS_DEBUG_ENABLED = Boolean.getBoolean("com.ibm.team.client.kerberos.debug") || System.getProperty("com.ibm.security.jgss.debug") != null || Boolean.getBoolean("sun.security.jgss.debug");
    private static final String KERBEROS_CACHE_FILE_PROP = "KRB5CCNAME";
    private static final String SUBJECT_CREDS_ONLY_PROP = "javax.security.auth.useSubjectCredsOnly";
    private static final String JAAS_LOGIN_MODULE_PROP = "java.security.auth.login.config";
    private static final String KERBEROS_REALM_PROP = "java.security.krb5.realm";
    private static final String KERBEROS_KDC_PROP = "java.security.krb5.kdc";
    private static final String KERBEROS_CONFIG_PROP = "java.security.krb5.conf";
    private static final String INTERNAL_KERBEROS_REALM_PROP = "internal.java.security.krb5.realm";
    private static final String INTERNAL_KERBEROS_KDC_PROP = "internal.java.security.krb5.kdc";
    private static final String INTERNAL_KERBEROS_CONFIG_PROP = "internal.java.security.krb5.conf";
    private static final String INTERNAL_KERBEROS_REALM_SET_PROP = "internal.java.security.krb5.realm.set";
    private static final String INTERNAL_KERBEROS_KDC_SET_PROP = "internal.java.security.krb5.kdc.set";
    private static final String INTERNAL_KERBEROS_CONFIG_SET_PROP = "internal.java.security.krb5.conf.set";
    private static final String INTERNAL_KERBEROS_RESTART_REQUIRED_PROP = "internal.com.ibm.team.repository.client.kerberos.restartRequired";
    private static final String INTERNAL_KERBEROS_SUCCESSFUL_LOGIN_PROP = "internal.com.ibm.team.repository.client.kerberos.successfulLogin";
    private static String SPNEGO_CONFIG_FILE_CONTENT = null;
    private static final String SUN_JRE = "sun";
    private static final String ORACLE_JRE = "oracle";
    private static final String IBM_JRE = "ibm";
    private static final String LS = System.getProperty("line.separator");
    private static final String SPNEGO_CONFIG_FILE_SUN = "com.sun.security.jgss.login {" + LS + "\tcom.sun.security.auth.module.Krb5LoginModule required renewTGT=true useTicketCache=true doNotPrompt=true;" + LS + "};" + LS + LS + "com.sun.security.jgss.initiate {" + LS + "\tcom.sun.security.auth.module.Krb5LoginModule required renewTGT=true useTicketCache=true doNotPrompt=true;" + LS + "};" + LS + LS + "com.sun.security.jgss.accept {" + LS + "\tcom.sun.security.auth.module.Krb5LoginModule required renewTGT=true useTicketCache=true doNotPrompt=true;" + LS + "};";
    private static final String SPNEGO_CONFIG_FILE_IBM = "com.ibm.security.jgss.login {" + LS + "\tcom.ibm.security.auth.module.Krb5LoginModule required renewable=true useDefaultCcache=true;" + LS + "};" + LS + LS + "com.ibm.security.jgss.initiate {" + LS + "\tcom.ibm.security.auth.module.Krb5LoginModule required renewable=true useDefaultCcache=true;" + LS + "};" + LS + LS + "com.ibm.security.jgss.accept {" + LS + "\tcom.ibm.security.auth.module.Krb5LoginModule required renewable=true useDefaultCcache=true;" + LS + "};";
    private static final String JAVA_VENDOR = System.getProperty("java.vendor").toLowerCase(Locale.ENGLISH);
    private static boolean KERBEROS_POSSIBLE = true;

    static {
        KerberosLoginUtils.executeJREVersionSpecificActions();
        if (KERBEROS_POSSIBLE) {
            KerberosLoginUtils.setCacheFile();
            KerberosLoginUtils.initializeKerberos();
            if (KERBEROS_POSSIBLE) {
                KerberosLoginUtils.debug("Kerberos is possible on the current system");
                String value = System.getProperty(KERBEROS_REALM_PROP);
                System.setProperty(INTERNAL_KERBEROS_REALM_SET_PROP, Boolean.toString(value != null));
                if (value != null) {
                    System.setProperty(INTERNAL_KERBEROS_REALM_PROP, value);
                    KerberosLoginUtils.debug("System property java.security.krb5.realm is set to " + value);
                }
                System.setProperty(INTERNAL_KERBEROS_KDC_SET_PROP, Boolean.toString((value = System.getProperty(KERBEROS_KDC_PROP)) != null));
                if (value != null) {
                    System.setProperty(INTERNAL_KERBEROS_KDC_PROP, value);
                    KerberosLoginUtils.debug("System property internal.java.security.krb5.kdc is set to " + value);
                }
                System.setProperty(INTERNAL_KERBEROS_CONFIG_SET_PROP, Boolean.toString((value = System.getProperty(KERBEROS_CONFIG_PROP)) != null));
                if (value != null) {
                    System.setProperty(INTERNAL_KERBEROS_CONFIG_PROP, value);
                    KerberosLoginUtils.debug("System property internal.java.security.krb5.conf is set to " + value);
                }
            } else {
                KerberosLoginUtils.debug("Kerberos is not possible on the current system");
            }
        }
    }

    private static final void executeJREVersionSpecificActions() {
        if (JAVA_VENDOR.contains(SUN_JRE) || JAVA_VENDOR.contains(ORACLE_JRE)) {
            KerberosLoginUtils.debug("Running with Oracle JRE");
            SPNEGO_CONFIG_FILE_CONTENT = SPNEGO_CONFIG_FILE_SUN;
            if (KERBEROS_DEBUG_ENABLED && System.getProperty(SUN_JRE_KRB5_DEBUG) == null) {
                System.setProperty(SUN_JRE_KRB5_DEBUG, "true");
            }
        } else if (JAVA_VENDOR.contains(IBM_JRE)) {
            KerberosLoginUtils.debug("Running with IBM JRE");
            SPNEGO_CONFIG_FILE_CONTENT = SPNEGO_CONFIG_FILE_IBM;
            if (KERBEROS_DEBUG_ENABLED && System.getProperty(IBM_JRE_KRB5_DEBUG) == null) {
                System.setProperty(IBM_JRE_KRB5_DEBUG, "all");
            }
        } else {
            KERBEROS_POSSIBLE = false;
            System.clearProperty(JAAS_LOGIN_MODULE_PROP);
            return;
        }
    }

    private static final void setCacheFile() {
        String kerberosCacheFilePath = System.getenv(KERBEROS_CACHE_FILE_PROP);
        if (kerberosCacheFilePath == null || kerberosCacheFilePath.isEmpty()) {
            kerberosCacheFilePath = System.getProperty(KERBEROS_CACHE_FILE_PROP);
        }
        if (kerberosCacheFilePath != null && !kerberosCacheFilePath.isEmpty()) {
            KerberosLoginUtils.debug("Variable KRB5CCNAME is set, so don't pre-calculate");
            System.setProperty(KERBEROS_CACHE_FILE_PROP, kerberosCacheFilePath);
            return;
        }
        if (KerberosLoginUtils.isWindows()) {
            KerberosLoginUtils.debug("Running on Windows, so no unix cache file");
            return;
        }
        String userHome = System.getProperty("user.home");
        String userName = System.getProperty("user.name");
        if (userHome != null) {
            String jreDefaultCacheFile = userName != null ? String.valueOf(userHome) + "/krb5cc_" + userName : String.valueOf(userHome) + "/krb5cc";
            KerberosLoginUtils.debug("Searching for JRE default cache path " + jreDefaultCacheFile);
            File jreDefaultCacheFileAsFile = new File(jreDefaultCacheFile);
            jreDefaultCacheFile = jreDefaultCacheFileAsFile.getAbsolutePath();
            if (jreDefaultCacheFileAsFile.exists()) {
                KerberosLoginUtils.debug("The cache file " + jreDefaultCacheFile + " appears to exist, so we give it preference");
                return;
            }
            KerberosLoginUtils.debug("No JRE default cache found at " + jreDefaultCacheFile);
        }
        if (userName != null) {
            KerberosLoginUtils.debug("Searching default Unix cache path for user " + userName);
            try {
                String command = "id -u " + userName;
                Process child = Runtime.getRuntime().exec(command);
                InputStream in = null;
                try {
                    in = child.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int c = in.read();
                    while (c != -1) {
                        baos.write(c);
                        c = in.read();
                    }
                    String uid = baos.toString("UTF-8");
                    String pathToCacheFile = ("/tmp/krb5cc_" + uid).trim();
                    File pathToCacheFileAsFile = new File(pathToCacheFile);
                    pathToCacheFile = pathToCacheFileAsFile.getAbsolutePath();
                    KerberosLoginUtils.debug("Running on a Unix system where the cache file should be " + pathToCacheFile);
                    if (pathToCacheFileAsFile.exists()) {
                        KerberosLoginUtils.debug("The cache file " + pathToCacheFile + " also appears to exist, so we set system property " + KERBEROS_CACHE_FILE_PROP);
                        System.setProperty(KERBEROS_CACHE_FILE_PROP, pathToCacheFile);
                        return;
                    }
                    KerberosLoginUtils.debug("No cache file " + pathToCacheFile + " found.");
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable e) {
                KerberosLoginUtils.debug("Failed trying to determine whether /tmp/krb5cc_uid exists", e);
            }
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") >= 0;
    }

    public static void setKerberosRealm(String kerberosRealm) {
        if (kerberosRealm != null && !kerberosRealm.trim().isEmpty()) {
            kerberosRealm = kerberosRealm.toUpperCase();
            String currentRealmValue = System.getProperty(KERBEROS_REALM_PROP);
            boolean restartRequired = Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP));
            if (currentRealmValue == null || !restartRequired) {
                System.setProperty(KERBEROS_REALM_PROP, kerberosRealm);
            }
            System.setProperty(INTERNAL_KERBEROS_REALM_PROP, kerberosRealm);
        } else {
            System.clearProperty(INTERNAL_KERBEROS_REALM_PROP);
            if (!KerberosLoginUtils.isKerberosRealmPreset()) {
                System.clearProperty(KERBEROS_REALM_PROP);
            }
        }
    }

    public static void setKerberosKdc(String kerberosKdc) {
        if (kerberosKdc != null && !kerberosKdc.trim().isEmpty()) {
            kerberosKdc = kerberosKdc.toLowerCase();
            String currentKdcValue = System.getProperty(KERBEROS_KDC_PROP);
            boolean restartRequired = Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP));
            if (currentKdcValue == null || !restartRequired) {
                System.setProperty(KERBEROS_KDC_PROP, kerberosKdc);
            }
            System.setProperty(INTERNAL_KERBEROS_KDC_PROP, kerberosKdc);
        } else {
            System.clearProperty(INTERNAL_KERBEROS_KDC_PROP);
            if (!KerberosLoginUtils.isKerberosKdcPreset()) {
                System.clearProperty(KERBEROS_KDC_PROP);
            }
        }
    }

    public static void setKerberosConfigPath(String kerberosConfigPath) {
        if (kerberosConfigPath != null && !kerberosConfigPath.trim().isEmpty()) {
            String currentRealmValue = System.getProperty(KERBEROS_CONFIG_PROP);
            boolean restartRequired = Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP));
            if (currentRealmValue == null || !restartRequired) {
                System.setProperty(KERBEROS_CONFIG_PROP, kerberosConfigPath);
            }
            System.setProperty(INTERNAL_KERBEROS_CONFIG_PROP, kerberosConfigPath);
        } else {
            System.clearProperty(INTERNAL_KERBEROS_CONFIG_PROP);
            if (!KerberosLoginUtils.isKerberosConfigPathPreset()) {
                System.clearProperty(KERBEROS_CONFIG_PROP);
            }
        }
    }

    public static boolean isKerberosRealmPreset() {
        return Boolean.getBoolean(INTERNAL_KERBEROS_REALM_SET_PROP);
    }

    public static boolean isKerberosKdcPreset() {
        return Boolean.getBoolean(INTERNAL_KERBEROS_KDC_SET_PROP);
    }

    public static boolean isKerberosConfigPathPreset() {
        return Boolean.getBoolean(INTERNAL_KERBEROS_CONFIG_SET_PROP);
    }

    public static String getKerberosRealm() {
        return System.getProperty(INTERNAL_KERBEROS_REALM_PROP);
    }

    public static String getKerberosKdc() {
        return System.getProperty(INTERNAL_KERBEROS_KDC_PROP);
    }

    public static String getKerberosConfigPath() {
        return System.getProperty(INTERNAL_KERBEROS_CONFIG_PROP);
    }

    public static boolean isRestartRequired() {
        return Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP));
    }

    public static void restartRequired() {
        System.setProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP, "true");
    }

    public static void transferInternalPropertiesToProperties(Properties properties) {
        String kerberosKdc;
        String kerberosConfigPath;
        String kerberosRealm;
        if (!KerberosLoginUtils.isKerberosRealmPreset() && (kerberosRealm = KerberosLoginUtils.getKerberosRealm()) != null) {
            properties.setProperty(INTERNAL_KERBEROS_REALM_PROP, kerberosRealm);
        }
        if (!KerberosLoginUtils.isKerberosConfigPathPreset() && (kerberosConfigPath = KerberosLoginUtils.getKerberosConfigPath()) != null) {
            properties.setProperty(INTERNAL_KERBEROS_CONFIG_PROP, kerberosConfigPath);
        }
        if (!KerberosLoginUtils.isKerberosKdcPreset() && (kerberosKdc = KerberosLoginUtils.getKerberosKdc()) != null) {
            properties.setProperty(INTERNAL_KERBEROS_KDC_PROP, kerberosKdc);
        }
    }

    public static void transferInternalPropertiesFromProperties(Properties properties) {
        String kerberosConfigPath;
        String kerberosKdc;
        boolean restartRequired = Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_RESTART_REQUIRED_PROP));
        String kerberosRealm = System.getProperty(KERBEROS_REALM_PROP);
        if (kerberosRealm == null) {
            if (properties != null) {
                kerberosRealm = properties.getProperty(INTERNAL_KERBEROS_REALM_PROP);
                KerberosLoginUtils.setKerberosRealm(kerberosRealm);
            }
        } else if (!restartRequired) {
            KerberosLoginUtils.setKerberosRealm(kerberosRealm);
        }
        if ((kerberosKdc = System.getProperty(KERBEROS_KDC_PROP)) == null) {
            if (properties != null) {
                kerberosKdc = properties.getProperty(INTERNAL_KERBEROS_KDC_PROP);
                KerberosLoginUtils.setKerberosKdc(kerberosKdc);
            }
        } else if (!restartRequired) {
            KerberosLoginUtils.setKerberosKdc(kerberosKdc);
        }
        if ((kerberosConfigPath = System.getProperty(KERBEROS_CONFIG_PROP)) == null) {
            if (properties != null) {
                kerberosConfigPath = properties.getProperty(INTERNAL_KERBEROS_CONFIG_PROP);
                KerberosLoginUtils.setKerberosConfigPath(kerberosConfigPath);
            }
        } else if (!restartRequired) {
            KerberosLoginUtils.setKerberosConfigPath(kerberosConfigPath);
        }
    }

    public static void successfulLogin() {
        System.setProperty(INTERNAL_KERBEROS_SUCCESSFUL_LOGIN_PROP, "true");
    }

    public static boolean isSuccessfullyLoggedIn() {
        return Boolean.valueOf(System.getProperty(INTERNAL_KERBEROS_SUCCESSFUL_LOGIN_PROP));
    }

    /*
     * Unable to fully structure code
     */
    public static void initializeKerberos() {
        if (System.getProperty("javax.security.auth.useSubjectCredsOnly") == null) {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        }
        faosLoginConfig = null;
        loginConfigPath = System.getProperty("java.security.auth.login.config");
        try {
            if (loginConfigPath == null) ** GOTO lbl16
            KerberosLoginUtils.debug("java.security.auth.login.config explicitly set to " + loginConfigPath);
            loginConfig = new File(loginConfigPath);
            if (!loginConfig.createNewFile()) {
                KerberosLoginUtils.debug(String.valueOf(loginConfig.getAbsolutePath()) + " exists and won't be touched");
                return;
            }
            try {
                block23: {
                    KerberosLoginUtils.debug(String.valueOf(loginConfig.getAbsolutePath()) + " does not exists and will be written default content");
                    break block23;
lbl16:
                    // 1 sources

                    loginConfig = File.createTempFile("login", ".conf");
                    KerberosLoginUtils.debug("java.security.auth.login.config is not set, so creating " + loginConfig.getAbsolutePath());
                    loginConfig.deleteOnExit();
                }
                loginConfigPath = loginConfig.getAbsolutePath();
                faosLoginConfig = new FileOutputStream(loginConfig);
                if (KerberosLoginUtils.KERBEROS_DEBUG_ENABLED) {
                    KerberosLoginUtils.debug("Writing the following content to" + loginConfig.getAbsolutePath());
                    KerberosLoginUtils.debug(KerberosLoginUtils.SPNEGO_CONFIG_FILE_CONTENT);
                }
                faosLoginConfig.write(KerberosLoginUtils.SPNEGO_CONFIG_FILE_CONTENT.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException v0) {
                return;
            }
            catch (IOException e) {
                KerberosLoginUtils.KERBEROS_POSSIBLE = false;
                System.err.println(Messages.getClientString("AbstractLoginInfo.UnableToActivateKerberos"));
                e.printStackTrace(System.err);
                System.clearProperty("java.security.auth.login.config");
                return;
            }
        }
        finally {
            if (faosLoginConfig != null) {
                try {
                    faosLoginConfig.close();
                }
                catch (IOException e) {
                    KerberosLoginUtils.KERBEROS_POSSIBLE = false;
                    System.err.println(Messages.getClientString("AbstractLoginInfo.UnableToActivateKerberos"));
                    e.printStackTrace(System.err);
                    System.clearProperty("java.security.auth.login.config");
                    return;
                }
            }
        }
        System.setProperty("java.security.auth.login.config", loginConfigPath);
    }

    public static boolean isKerberosPossible() {
        return KERBEROS_POSSIBLE;
    }

    private static void debug(String msg) {
        if (KERBEROS_DEBUG_ENABLED) {
            System.out.println(msg);
        }
    }

    private static void debug(String msg, Throwable e) {
        if (KERBEROS_DEBUG_ENABLED) {
            System.out.println(msg);
            e.printStackTrace();
        }
    }
}

