/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.exceptions;

import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblerException
extends JenaException {
    protected final Resource root;
    protected List<AssemblerGroup.Frame> doing = new ArrayList<AssemblerGroup.Frame>();

    public AssemblerException(Resource root, String string, Throwable t) {
        super(string, t);
        this.root = root;
    }

    public AssemblerException(Resource root, String message) {
        super(message);
        this.root = root;
    }

    public Resource getRoot() {
        return this.root;
    }

    public AssemblerException pushDoing(AssemblerGroup.Frame frame) {
        this.doing.add(frame);
        return this;
    }

    protected static String nice(Resource r) {
        String rString = r.asNode().toString(r.getModel());
        return r.isAnon() ? rString + AssemblerException.getLabels(r) : rString;
    }

    private static String getLabels(Resource r) {
        Model m = r.getModel();
        String labels = "";
        String prefix = "labels: ";
        StmtIterator it = r.listProperties(RDFS.label);
        while (it.hasNext()) {
            String label = it.nextStatement().getObject().asNode().toString(m, true);
            labels = labels + prefix + label;
            prefix = ", ";
        }
        return labels.equals("") ? AssemblerException.getIncomingProperty(r) : " [" + labels + "]";
    }

    private static String getIncomingProperty(Resource r) {
        String incomings = "";
        String prefix = "";
        StmtIterator it = r.getModel().listStatements(null, null, r);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            incomings = incomings + prefix + AssemblerException.nice(s.getPredicate()) + " of " + AssemblerException.nice(s.getSubject());
            prefix = ", ";
        }
        return incomings.equals("") ? "" : " [" + incomings + "]";
    }

    protected static String nice(RDFNode r) {
        return r.isLiteral() ? r.asNode().toString() : AssemblerException.nice((Resource)r);
    }

    public List<AssemblerGroup.Frame> getDoing() {
        return this.doing;
    }

    @Override
    public String toString() {
        String parent = super.toString();
        String frame = this.frameStrings();
        return frame.equals("") ? parent : parent + "\n  doing:\n" + frame;
    }

    protected String frameStrings() {
        StringBuffer result = new StringBuffer();
        Iterator<AssemblerGroup.Frame> it = this.doing.iterator();
        while (it.hasNext()) {
            result.append("    ").append(it.next().toString()).append("\n");
        }
        return result.toString();
    }
}

