/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.jazz;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.eclipse.lyo.client.exception.JazzAuthErrorException;
import org.eclipse.lyo.client.exception.JazzAuthFailedException;
import org.eclipse.lyo.client.oslc.OslcClient;

public class JazzFormAuthClient
extends OslcClient {
    private String url;
    private String authUrl;
    private String project;
    private String user;
    private String password;
    private static final String JAZZ_AUTH_MESSAGE_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    private static final String JAZZ_AUTH_FAILED = "authfailed";

    public JazzFormAuthClient() {
    }

    public JazzFormAuthClient(String url, String user, String password) {
        this();
        this.url = url;
        this.authUrl = url;
        this.user = user;
        this.password = password;
    }

    public JazzFormAuthClient(String url, String authUrl, String user, String password) {
        this(url, user, password);
        this.authUrl = authUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int formLogin() throws JazzAuthFailedException, JazzAuthErrorException {
        int statusCode = -1;
        String location = null;
        try {
            HttpGet get1 = new HttpGet(this.authUrl + "/auth/authrequired");
            HttpResponse resp = this.httpClient.execute(get1);
            statusCode = resp.getStatusLine().getStatusCode();
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            this.followRedirects(statusCode, location);
            HttpGet get2 = new HttpGet(this.authUrl + "/authenticated/identity");
            resp = this.httpClient.execute(get2);
            statusCode = resp.getStatusLine().getStatusCode();
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            this.followRedirects(statusCode, location);
            HttpPost post = new HttpPost(this.authUrl + "/j_security_check");
            StringEntity entity = new StringEntity("j_username=" + this.user + "&j_password=" + this.password);
            post.setHeader("Accept", "*/*");
            post.setHeader("X-Requested-With", "XMLHttpRequest");
            post.setEntity(entity);
            post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            post.addHeader("OSLC-Core-Version", "2.0");
            resp = this.httpClient.execute(post);
            statusCode = resp.getStatusLine().getStatusCode();
            String jazzAuthMessage = null;
            Header jazzAuthMessageHeader = resp.getLastHeader(JAZZ_AUTH_MESSAGE_HEADER);
            if (jazzAuthMessageHeader != null) {
                jazzAuthMessage = jazzAuthMessageHeader.getValue();
            }
            if (jazzAuthMessage != null && jazzAuthMessage.equalsIgnoreCase(JAZZ_AUTH_FAILED)) {
                EntityUtils.consume(resp.getEntity());
                throw new JazzAuthFailedException(this.user, this.url);
            }
            if (statusCode != 200 && statusCode != 302) {
                EntityUtils.consume(resp.getEntity());
                throw new JazzAuthErrorException(statusCode, this.url);
            }
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            this.followRedirects(statusCode, location);
            HttpGet get3 = new HttpGet(this.authUrl + "/service/com.ibm.team.repository.service.internal.webuiInitializer.IWebUIInitializerRestService/initializationData");
            resp = this.httpClient.execute(get3);
            statusCode = resp.getStatusLine().getStatusCode();
            location = this.getHeader(resp, "Location");
            EntityUtils.consume(resp.getEntity());
            this.followRedirects(statusCode, location);
        }
        catch (JazzAuthFailedException jfe) {
            throw jfe;
        }
        catch (JazzAuthErrorException jee) {
            throw jee;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusCode;
    }

    private void followRedirects(int statusCode, String location) {
        while (statusCode == 302 && location != null) {
            HttpGet get = new HttpGet(location);
            try {
                HttpResponse newResp = this.httpClient.execute(get);
                statusCode = newResp.getStatusLine().getStatusCode();
                location = this.getHeader(newResp, "Location");
                EntityUtils.consume(newResp.getEntity());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getHeader(HttpResponse resp, String headerName) {
        String retval = null;
        Header header = resp.getFirstHeader(headerName);
        if (header != null) {
            retval = header.getValue();
        }
        return retval;
    }

    private HttpResponse getArtifactFeed(String feedUrl) {
        HttpResponse resp = null;
        try {
            HttpGet feedGet = new HttpGet(feedUrl);
            feedGet.addHeader("Accept", "http://www.w3.org/2005/Atom");
            resp = this.httpClient.execute(feedGet);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                System.out.println("Status code from feed retrieval: " + statusCode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resp;
    }
}

