/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.User;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Team
extends ClientDescribed<Team> {
    public static final Team SAMPLE_TEAM = (Team)new Team().id("00000000-0000-0000-0000-000000000206");
    @SerializedName(value="userRoleForTeam")
    public UserRole[] userRoles;
    @SerializedName(value="groupRoleForTeam")
    public GroupRole[] groupRoles;
    @Deprecated
    public Boolean enabled;

    public Team() {
        this.path = "/teams/";
        this.enabled = true;
    }

    public UserRole[] getUserRoles() {
        return this.userRoles;
    }

    public GroupRole[] getGroupRoles() {
        return this.groupRoles;
    }

    @Deprecated
    public Team enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Deprecated
    public Team[] getTeamsWithEditReleasePermission() {
        return ((Response)RestAssured.given().get(this.path() + "whereUserHasEditRelease", new Object[0])).as(Team[].class);
    }

    @Deprecated
    public Team[] getAllUsersForRole(Role role) {
        return ((Response)RestAssured.given().get(this.path(this.id) + "usersInRole/" + role.id, new Object[0])).as(Team[].class);
    }

    public User[] getUsersForRole(Role role) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserRole userRole : this.userRoles) {
            if (!userRole.role.equals(role)) continue;
            users.add(userRole.user);
        }
        return users.toArray(new User[users.size()]);
    }

    public Group[] getGroupsForRole(Role role) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (GroupRole groupRole : this.groupRoles) {
            if (!groupRole.role.equals(role)) continue;
            groups.add(groupRole.group);
        }
        return groups.toArray(new Group[groups.size()]);
    }

    public Team addUsersToRole(Role role, User ... users) {
        HashSet<UserRole> newURs = Sets.newHashSet();
        if (this.userRoles != null) {
            newURs.addAll(Arrays.asList(this.userRoles));
        }
        for (User user : users) {
            UserRole ur = new UserRole();
            ur.user = user;
            ur.role = role;
            newURs.add(ur);
        }
        this.userRoles = newURs.toArray(new UserRole[newURs.size()]);
        return this;
    }

    public Team removeUsersFromRole(Role role, User ... users) {
        if (this.userRoles != null) {
            HashSet<UserRole> newURs = Sets.newHashSet(this.userRoles);
            for (User user : users) {
                UserRole ur = new UserRole();
                ur.user = user;
                ur.role = role;
                newURs.remove(ur);
            }
            this.userRoles = newURs.toArray(new UserRole[newURs.size()]);
        }
        return this;
    }

    public Team addGroupsToRole(Role role, Group ... groups) {
        HashSet<GroupRole> newGRs = Sets.newHashSet();
        if (this.groupRoles != null) {
            newGRs.addAll(Arrays.asList(this.groupRoles));
        }
        for (Group group : groups) {
            GroupRole gr = new GroupRole();
            gr.group = group;
            gr.role = role;
            newGRs.add(gr);
        }
        this.groupRoles = newGRs.toArray(new GroupRole[newGRs.size()]);
        return this;
    }

    public User[] getAllUsersInTeam() {
        return (User[])((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path(this.id) + "/usersInTeam", new Object[0])).as(Array.newInstance(User.class, 0).getClass(), ObjectMapperType.GSON);
    }

    public Team removeGroupsFromRole(Role role, Group ... groups) {
        if (this.groupRoles != null) {
            HashSet<GroupRole> newGRs = Sets.newHashSet(this.groupRoles);
            for (Group group : groups) {
                GroupRole ur = new GroupRole();
                ur.group = group;
                ur.role = role;
                newGRs.remove(ur);
            }
            this.groupRoles = newGRs.toArray(new GroupRole[newGRs.size()]);
        }
        return this;
    }

    public static Team getOrCreateByName(String teamName) {
        Team[] result = (Team[])new Team().filter("name", QueryParams.FilterClass.STRING, QueryFilter.FilterType.EQUALS, teamName).when().getAll();
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].name.equals(teamName)) continue;
            return result[i];
        }
        return (Team)((Team)Clients.team().name(teamName)).save();
    }

    public static class GroupRole {
        public Group group;
        public Role role;

        public Group getGroup() {
            return this.group;
        }

        public Role getRole() {
            return this.role;
        }

        public boolean equals(Object other) {
            if (other instanceof GroupRole) {
                GroupRole otherGR = (GroupRole)other;
                return otherGR.group.equals(this.group) && otherGR.role.equals(this.role);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.group, this.role);
        }
    }

    public static class UserRole {
        public User user;
        public Role role;

        public User getUser() {
            return this.user;
        }

        public Role getRole() {
            return this.role;
        }

        public boolean equals(Object other) {
            if (other instanceof UserRole) {
                UserRole otherUR = (UserRole)other;
                return otherUR.user.equals(this.user) && otherUR.role.equals(this.role);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.user, this.role);
        }
    }
}

