/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.Phase;

public class AuditAction
extends ClientEntity<AuditAction> {
    public User user;
    public String description;
    public Phase phase;
    public Release release;
    public String parentClass;
    public String parentId;
    public String primaryClass;
    public String primaryId;
    public AuditActionTypes actionType;

    public AuditAction() {
        this.path = "/auditActions/";
    }

    public User getUser() {
        return this.user;
    }

    public AuditAction user(User user) {
        this.user = user;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AuditAction description(String description) {
        this.description = description;
        return this;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public AuditAction phase(Phase phase) {
        this.phase = phase;
        return this;
    }

    public Release getRelease() {
        return this.release;
    }

    public AuditAction release(Release release) {
        this.release = release;
        return this;
    }

    public String getParentClass() {
        return this.parentClass;
    }

    public AuditAction parentClass(String parentClass) {
        this.parentClass = parentClass;
        return this;
    }

    public String getParentId() {
        return this.parentId;
    }

    public AuditAction parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String getPrimaryClass() {
        return this.primaryClass;
    }

    public AuditAction primaryClass(String primaryClass) {
        this.primaryClass = primaryClass;
        return this;
    }

    public String getPrimaryId() {
        return this.primaryId;
    }

    public AuditAction primaryId(String primaryId) {
        this.primaryId = primaryId;
        return this;
    }

    public AuditActionTypes getActionType() {
        return this.actionType;
    }

    public AuditAction actionType(AuditActionTypes actionType) {
        this.actionType = actionType;
        return this;
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated;
    }

    public AuditAction dateCreated(Long dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public AuditAction[] getAllLikeThis() {
        return this.getAllLikeThisBetween(null, null);
    }

    public AuditAction[] getAllLikeThisBefore(Long before) {
        return this.getAllLikeThisBetween(null, before);
    }

    public AuditAction[] getAllLikeThisAfter(Long after) {
        return this.getAllLikeThisBetween(after, null);
    }

    public AuditAction[] getAllLikeThisBetween(Long after, Long before) {
        return (AuditAction[])this.generateQuery(after, before).getAll();
    }

    public AuditAction generateQuery(Long after, Long before) {
        if (after != null) {
            this.filter("dateCreated", QueryParams.FilterClass.LONG, QueryFilter.FilterType.GREATER_OR_EQUAL, after);
        }
        if (before != null) {
            this.filter("dateCreated", QueryParams.FilterClass.LONG, QueryFilter.FilterType.LESS_OR_EQUAL, before);
        }
        if (this.parentClass != null) {
            this.filter("parentClass", QueryParams.FilterClass.STRING, QueryFilter.FilterType.EQUALS, this.parentClass);
        }
        if (this.parentId != null) {
            this.filter("parentId", QueryParams.FilterClass.UUID, QueryFilter.FilterType.EQUALS, this.parentId);
        }
        if (this.primaryClass != null) {
            this.filter("primaryClass", QueryParams.FilterClass.STRING, QueryFilter.FilterType.EQUALS, this.primaryClass);
        }
        if (this.primaryId != null) {
            this.filter("primaryId", QueryParams.FilterClass.UUID, QueryFilter.FilterType.EQUALS, this.primaryId);
        }
        if (this.phase != null) {
            this.filter("phase.id", QueryParams.FilterClass.UUID, QueryFilter.FilterType.EQUALS, this.phase.id);
        }
        if (this.release != null) {
            this.filter("release.id", QueryParams.FilterClass.UUID, QueryFilter.FilterType.EQUALS, this.release.id);
        }
        if (this.actionType != null) {
            this.filter("actionType", QueryParams.FilterClass.ENUM, QueryFilter.FilterType.EQUALS, new Object[]{this.actionType});
        }
        if (this.user != null) {
            this.filter("user.id", QueryParams.FilterClass.UUID, QueryFilter.FilterType.EQUALS, this.user.id);
        }
        return this;
    }

    public static enum AuditActionTypes {
        CREATE,
        EDIT,
        DELETE,
        ACTION;

    }
}

