/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.Segment;
import com.urbancode.release.rest.models.internal.TaskExecution;

public class SegmentExecution
extends Segment<SegmentExecution> {
    public Long overrideStartTime;
    public Boolean prerequisiteOverride;
    public ScheduledDeployment scheduledDeployment;
    @JsonReadOnly
    public DeploymentExecution deploymentExecution;
    @JsonReadOnly
    public SegmentExecution[] prerequisites;
    @JsonReadOnly
    public String status;
    @JsonReadOnly
    public Integer durationPlanned;
    @JsonReadOnly
    public Integer durationRemaining;
    @JsonReadOnly
    public Long startTimePlanned;
    @JsonReadOnly
    public Long endTimePlanned;
    @JsonReadOnly
    public Boolean userCanExecute;
    @JsonReadOnly
    public Boolean syncProperties;
    @JsonReadOnly
    public Boolean syncTasks;
    @JsonReadOnly
    public TaskExecution[] tasks;

    public SegmentExecution() {
        this.path = "/segmentExecutions/";
    }

    public SegmentExecution scheduledDeployment(ScheduledDeployment sd) {
        this.scheduledDeployment = sd;
        return this;
    }

    @Deprecated
    public SegmentExecution deploymentExecution(DeploymentExecution de) {
        this.deploymentExecution = de;
        return this;
    }

    public SegmentExecution prerequisites(SegmentExecution ... prerequisites) {
        this.prerequisites = prerequisites;
        this.prerequisiteIds = SegmentExecution.ids(prerequisites);
        return this;
    }

    public SegmentExecution execute() {
        RestAssured.given().put(this.path(this.id) + "/execute", new Object[0]);
        return this;
    }

    public SegmentExecution addTask(TaskExecution task) {
        RestAssured.given().post(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentExecution removeTask(TaskExecution task) {
        RestAssured.given().delete(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentExecution removeTask(int index) {
        return this.removeTask(this.tasks[index]);
    }

    public SegmentExecution prerequisiteOverride(boolean override) {
        this.prerequisiteOverride = override;
        return this;
    }
}

