/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;

public class UCDPluginIntegrationProvider
extends PluginIntegrationProvider<UCDPluginIntegrationProvider> {
    public UCDPluginIntegrationProvider udeployUrl(String udeployUrl) {
        return (UCDPluginIntegrationProvider)this.property("deployHostName", udeployUrl);
    }

    public UCDPluginIntegrationProvider udeployAdminToken(String udeployAdminToken) {
        return (UCDPluginIntegrationProvider)this.property("deployToken", udeployAdminToken);
    }

    public String getUdeployUrl() {
        return (String)this.propertyValues.get("deployHostName");
    }

    public String getUdeployAdminToken() {
        return (String)this.propertyValues.get("deployToken");
    }

    public int numberOfItemsImported(UCDIntegrationSteps step) {
        String stepString = this.getStepString(step);
        String numInTime = stepString.split(": ")[1].split("s")[0];
        String numOfItems = numInTime.split(" in ")[0];
        return Integer.parseInt(numOfItems);
    }

    public double timeOfItemsImported(UCDIntegrationSteps step) {
        String stepString = this.getStepString(step);
        String numInTime = stepString.split(": ")[1].split("s")[0];
        String numOfItems = numInTime.split(" in ")[1];
        return Double.parseDouble(numOfItems);
    }

    private String getStepString(UCDIntegrationSteps step) {
        String executionReport = ((UCDPluginIntegrationProvider)this.get()).lastExecutionReport;
        String firstSplit = ">>>> Import Statuses";
        switch (step) {
            case IMPORT_COMPONENTS: {
                firstSplit = ">>>> Import Components";
                break;
            }
            case IMPORT_APPLICATIONS: {
                firstSplit = ">>>> Import Applications";
                break;
            }
            case IMPORT_ENVIRONMENTS: {
                firstSplit = ">>>> Import Environments";
                break;
            }
            case IMPORT_PROCESSES: {
                firstSplit = ">>>> Import Processes";
                break;
            }
            case IMPORT_COMP_VERSIONS: {
                firstSplit = ">>>> Import Component Versions";
                break;
            }
            case IMPORT_SNAPSHOTS: {
                firstSplit = ">>>> Import Snapshots";
                break;
            }
            case IMPORT_INVENTORIES: {
                firstSplit = ">>>> Import Inventories";
                break;
            }
            case UPDATE_EXECUTING_TASKS: {
                firstSplit = ">>>> Update Executing Tasks";
            }
        }
        return executionReport.split(firstSplit)[1];
    }

    public static enum UCDIntegrationSteps {
        IMPORT_STATUSES,
        IMPORT_COMPONENTS,
        IMPORT_APPLICATIONS,
        IMPORT_ENVIRONMENTS,
        IMPORT_PROCESSES,
        IMPORT_COMP_VERSIONS,
        IMPORT_SNAPSHOTS,
        IMPORT_INVENTORIES,
        UPDATE_EXECUTING_TASKS;

    }
}

