/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UCRPlugin
extends PluginIntegrationProvider<UCRPlugin> {
    protected transient String path = "/integrationProvider/";
    protected transient String reservationPath = "/environmentReservation/";
    protected transient String versionPath = "/version/";

    public void syncSnapshot(String applicationId, String snapshotId) {
        String syncSnapshotpath = "syncVersion/" + applicationId + "/snapshot/" + snapshotId;
        RestAssured.given().expect().statusCode(200).post(this.path + syncSnapshotpath, new Object[0]);
    }

    public void updateApplication(String applicationId) {
        String syncSnapshotpath = "updateApplication/" + applicationId;
        RestAssured.given().expect().statusCode(200).post(this.path + syncSnapshotpath, new Object[0]);
    }

    public void addStatusToSnapshot(String snapshotId, String statusName, String comment) throws UnsupportedEncodingException {
        String addStatusToSnapshot = "externalId/" + snapshotId + "/status/" + URLEncoder.encode(statusName, "UTF-8");
        RestAssured.given().header("Content-Type", "multipart/form-data", new Object[0]).multiPart("comment", comment).expect().statusCode(200).when().post(this.versionPath + addStatusToSnapshot, new Object[0]);
    }

    public Response getReleaseForEnvironment(String applicationTargetId, int expected) {
        String releaseForEnvironmentPath = "releaseForEnvironment/" + applicationTargetId;
        Response response = (Response)RestAssured.given().expect().statusCode(expected).when().get(this.reservationPath + releaseForEnvironmentPath, new Object[0]);
        return response;
    }
}

