/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.persistence.IDGenerator;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="vc_commit_path_entry")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="vcCache")
@Immutable
public class CommitPathEntry {
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    private UUID id = IDGenerator.createID();
    @NotNull
    @ManyToOne
    @JoinColumn(name="commit_id")
    private Commit commit;
    @NotNull
    @Column(name="path")
    @Length(min=1, max=255)
    private String path;
    @NotNull
    @Column(name="entry_type")
    @Enumerated(value=EnumType.STRING)
    private EntryType type;

    private CommitPathEntry() {
    }

    public CommitPathEntry(Commit commit, String path, EntryType type) {
        this.commit = commit;
        this.path = path;
        this.type = type;
    }

    protected UUID getId() {
        return this.id;
    }

    protected String getPath() {
        return this.path;
    }

    protected EntryType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        MODIFIED,
        DELETED;

    }
}

