/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.common.service.ProcessDataValidationException;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.IWorkItemConfiguration;
import com.ibm.team.workitem.common.internal.StateGroups;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.ConfigurationManagementUtil;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProcessConfigurationManager
extends CacheHelper
implements IWorkItemConfiguration {
    private static final String PROGRESS_MODE_ASPECT_ID = "com.ibm.team.apt.configuration.workItemProgressMode";
    private static final String PROGRESS_MODE_ELEMENT_NAME = "name";
    private static final String ESTIMATE_OUTPUT_FORMAT = "estimateOutputFormat";
    private static final String HOURS_OUTPUT_FORMAT = "Hours";
    private static final String ESTIMATION_MODE = "estimationMode";
    private static final String PROGRESS_MODE_TIME_REMAINING_NAME = "TimeRemaining";
    private static final String WORK_ITEM_CONFIGURATION_ASPECT_ID = "com.ibm.team.workitem.configuration";
    private static final String ELEMENT_CONFIGURATION = "configuration";
    private static final String ATTR_CONFIGURATION_ID = "id";
    private static final String OSLC_TYPES_CFG_ID = "com.ibm.team.workitem.configuration.oslc.types";
    private static final String ATTR_OSLC_TYPE_ID = "oslcTypeId";
    private static final String ATTR_WORKITEM_TYPE_ID = "workItemTypeId";
    private static final String WORK_ITEM_PLE_LINK_MAPPING_DATA_POINT = "com.ibm.team.ple.config.workitems.linktoattributemapping";
    private static final String LINK_TYPE_ID = "linkTypeId";
    private static final String ATTRIBUTE_ID = "attributeId";
    private Map<UUID, EstimateConfiguration> fEstimateConfiguration = new HashMap<UUID, EstimateConfiguration>();
    private Map<UUID, Map<String, Collection<String>>> fOSLCTypeBindings = new HashMap<UUID, Map<String, Collection<String>>>();
    private Map<UUID, Map<String, String>> fLinkTypeToAttributeMap = new HashMap<UUID, Map<String, String>>();
    private Map<UUID, StateGroups> fStateGroups = new HashMap<UUID, StateGroups>();

    public ProcessConfigurationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public boolean usesTimeRemaining(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        EstimateConfiguration estimateConfiguration = this.fEstimateConfiguration.get(projectArea.getItemId());
        return estimateConfiguration != null && estimateConfiguration.useTimeRemaining();
    }

    public boolean usesHourOutputFormat(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        EstimateConfiguration estimateConfiguration = this.fEstimateConfiguration.get(projectArea.getItemId());
        return estimateConfiguration != null && estimateConfiguration.useHourOutputForma();
    }

    @Override
    public String getOSLCTypeBinding(IProjectAreaHandle projectArea, String oslcTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] oslcBindings = this.getAllOSLCTypeBinding(projectArea, oslcTypeId, monitor);
        return oslcBindings != null && oslcBindings.length > 0 ? oslcBindings[0] : null;
    }

    @Override
    public String[] getAllOSLCTypeBinding(IProjectAreaHandle projectArea, String oslcTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, Collection<String>> bindings = this.fOSLCTypeBindings.get(projectArea.getItemId());
        if (bindings != null) {
            Collection<String> workItemBindings = bindings.get(oslcTypeId);
            return workItemBindings != null ? workItemBindings.toArray(new String[workItemBindings.size()]) : null;
        }
        return null;
    }

    @Override
    public String getMappedConfigurationManagementAttributeByLinkType(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String linkTypeId) throws TeamRepositoryException {
        this.checkCache(projectArea, null);
        Map<String, String> linkTypeToAttributeMap = this.fLinkTypeToAttributeMap.get(projectArea.getItemId());
        return linkTypeToAttributeMap.get(linkTypeId);
    }

    @Override
    public StateGroups getStateGroups(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        StateGroups stateGroups = this.fStateGroups.get(projectArea.getItemId());
        if (stateGroups == null) {
            stateGroups = new StateGroups();
            this.fStateGroups.put(projectArea.getItemId(), stateGroups);
        }
        return stateGroups;
    }

    @Override
    public boolean hasOSLCLinkTypeMappings(IProjectAreaHandle projectArea) throws TeamRepositoryException {
        this.checkCache(projectArea, null);
        Map<String, String> linkTypeToAttributeMap = this.fLinkTypeToAttributeMap.get(projectArea.getItemId());
        return linkTypeToAttributeMap != null && !linkTypeToAttributeMap.isEmpty();
    }

    @Override
    public Map<String, String> getCachedOSLCLinkTypeMappings(IProjectAreaHandle projectArea) throws TeamRepositoryException {
        this.checkCache(projectArea, null);
        Map<String, String> linkTypeToAttributeMap = this.fLinkTypeToAttributeMap.get(projectArea.getItemId());
        if (linkTypeToAttributeMap != null) {
            return linkTypeToAttributeMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getOSLCLinkTypeMappings(IAuditableCommon auditableCommon, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> linkTypeMappings = new HashMap<String, String>();
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        String xml = this.getProcessXml(auditableCommon, projectArea, monitor);
        Exception exception = model.initialize(xml);
        if (exception != null) {
            throw new ProcessDataValidationException((Throwable)exception);
        }
        ProjectConfigurationElement pce = model.getProjectConfiguration();
        if (pce != null) {
            for (Object childElement : pce.getChildElements()) {
                ConfigurationDataElement cde;
                ModelElement modelElement;
                String modelElementName;
                if (!(childElement instanceof ModelElement) || !"data".equals(modelElementName = (modelElement = (ModelElement)childElement).getName()) || (cde = this.getConfigurationDataElement(modelElement, WORK_ITEM_PLE_LINK_MAPPING_DATA_POINT)) == null) continue;
                IProcessConfigurationElement[] iProcessConfigurationElementArray = cde.getElements();
                int n = iProcessConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcessConfigurationElement processElement = iProcessConfigurationElementArray[n2];
                    String linkTypeId = processElement.getAttribute(LINK_TYPE_ID);
                    String attributeId = processElement.getAttribute(ATTRIBUTE_ID);
                    if (linkTypeId != null) {
                        linkTypeMappings.put(linkTypeId, attributeId);
                    }
                    ++n2;
                }
            }
        }
        return linkTypeMappings;
    }

    private String getProcessXml(IAuditableCommon auditableCommon, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        Map processData = projectArea.getProcessData();
        IContent processContent = (IContent)processData.get("com.ibm.team.internal.process.40.compiled.xml");
        if (processContent == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        auditableCommon.getInternal().retrieveContent(processContent, stream, monitor);
        try {
            return new String(stream.toByteArray(), processContent.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private ConfigurationDataElement getConfigurationDataElement(ModelElement modelElement, String id) {
        for (Object childElement : modelElement.getChildElements()) {
            ConfigurationDataElement dataElement;
            if (!(childElement instanceof ConfigurationDataElement) || !"configuration-data".equals((dataElement = (ConfigurationDataElement)childElement).getName()) || !id.equals(dataElement.getAttribute(ATTR_CONFIGURATION_ID))) continue;
            return dataElement;
        }
        return null;
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectAreaHandle, monitor);
        this.fEstimateConfiguration.put(projectAreaHandle.getItemId(), this.readEstimateConfiguration(process, monitor));
        this.updateWorkItemConfiguration(process, monitor);
        this.updateLinkTypeToAttributeMap(process, monitor);
    }

    private void updateWorkItemConfiguration(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationData data = process.findProcessConfiguration(WORK_ITEM_CONFIGURATION_ASPECT_ID, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        if (data == null) {
            return;
        }
        IProcessConfigurationElement[] iProcessConfigurationElementArray = data.getElements();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
            if (ELEMENT_CONFIGURATION.equals(element.getName())) {
                String id = element.getAttribute(ATTR_CONFIGURATION_ID);
                UUID projectAreaItemId = process.getProjectArea().getItemId();
                if (OSLC_TYPES_CFG_ID.equals(id)) {
                    Map<String, Collection<String>> bindings = this.readOSLCTypeBinding(element);
                    this.fOSLCTypeBindings.put(projectAreaItemId, bindings);
                } else if ("com.ibm.team.workitem.configuration.stateGroups".equals(id)) {
                    StateGroups stateGroups = StateGroups.readFromProcessConfiguration(element);
                    this.fStateGroups.put(projectAreaItemId, stateGroups);
                }
            }
            ++n2;
        }
    }

    private void updateLinkTypeToAttributeMap(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID projectAreaItemId = process.getProjectArea().getItemId();
        Map<String, String> linkTypeToAttributeMap = Collections.emptyMap();
        IProcessConfigurationData configData = process.findProcessConfiguration(WORK_ITEM_PLE_LINK_MAPPING_DATA_POINT, null);
        if (configData != null) {
            IProcessConfigurationElement[] elements = configData.getElements();
            linkTypeToAttributeMap = new HashMap();
            int i = 0;
            while (i < elements.length) {
                String processLinkTypeId = elements[i].getAttribute(LINK_TYPE_ID);
                String attributeId = elements[i].getAttribute(ATTRIBUTE_ID);
                if (processLinkTypeId != null && attributeId != null) {
                    linkTypeToAttributeMap.put(processLinkTypeId, attributeId);
                }
                ++i;
            }
        }
        this.fLinkTypeToAttributeMap.put(projectAreaItemId, linkTypeToAttributeMap);
    }

    private Map<String, Collection<String>> readOSLCTypeBinding(IProcessConfigurationElement element) {
        HashMap<String, Collection<String>> bindings = new HashMap<String, Collection<String>>();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement binding = iProcessConfigurationElementArray[n2];
            String oslcId = binding.getAttribute(ATTR_OSLC_TYPE_ID);
            String workItemId = binding.getAttribute(ATTR_WORKITEM_TYPE_ID);
            HashSet<String> workItemIds = (HashSet<String>)bindings.get(oslcId);
            if (workItemIds == null) {
                workItemIds = new HashSet<String>();
                bindings.put(oslcId, workItemIds);
            }
            workItemIds.add(workItemId);
            ++n2;
        }
        return bindings;
    }

    private EstimateConfiguration readEstimateConfiguration(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationData data = process.findProcessConfiguration(PROGRESS_MODE_ASPECT_ID, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        String progressMode = null;
        String outputFormat = null;
        if (data != null) {
            IProcessConfigurationElement[] elements;
            IProcessConfigurationElement[] iProcessConfigurationElementArray = elements = data.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (ESTIMATION_MODE.equals(element.getName())) {
                    progressMode = element.getAttribute(PROGRESS_MODE_ELEMENT_NAME);
                } else if (ESTIMATE_OUTPUT_FORMAT.equals(element.getName())) {
                    outputFormat = element.getAttribute(PROGRESS_MODE_ELEMENT_NAME);
                }
                ++n2;
            }
        }
        return new EstimateConfiguration(progressMode, outputFormat);
    }

    @Override
    protected void doFlushCache(IProjectAreaHandle projectArea) {
        this.fEstimateConfiguration.remove(projectArea.getItemId());
        this.fOSLCTypeBindings.remove(projectArea.getItemId());
        this.fStateGroups.remove(projectArea.getItemId());
        this.fLinkTypeToAttributeMap.remove(projectArea.getItemId());
    }

    @Override
    public String[] getMappedConfigurationManagementAttributeNames(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String[] linkTypeIds) throws TeamRepositoryException {
        this.checkCache(projectArea, null);
        Map<String, String> linkTypeToAttributeMap = this.fLinkTypeToAttributeMap.get(projectArea.getItemId());
        if (linkTypeToAttributeMap.isEmpty()) {
            return new String[0];
        }
        HashSet<String> mappedAttributes = new HashSet<String>();
        String[] stringArray = linkTypeIds = linkTypeIds == null ? new String[]{} : linkTypeIds;
        if (linkTypeIds.length > 0) {
            String[] stringArray2 = linkTypeIds;
            int n = linkTypeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String linkTypeId = stringArray2[n2];
                String attributeId = linkTypeToAttributeMap.get(linkTypeId);
                if (attributeId == null) {
                    String convertedLinkType = ConfigurationManagementUtil.getLinkTypeId(linkTypeId);
                    attributeId = linkTypeToAttributeMap.get(convertedLinkType);
                }
                if (attributeId != null) {
                    mappedAttributes.add(attributeId);
                }
                ++n2;
            }
        } else {
            mappedAttributes.addAll(linkTypeToAttributeMap.values());
        }
        return mappedAttributes.toArray(new String[mappedAttributes.size()]);
    }

    @Override
    public Map<String, String> getConfigurationManagementContextMap(IProjectAreaHandle projectArea, List<String> attributeNames) throws TeamRepositoryException {
        this.checkCache(projectArea, null);
        Map<String, String> linkTypeToAttributeMap = this.fLinkTypeToAttributeMap.get(projectArea.getItemId());
        if (linkTypeToAttributeMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> contextMap = new HashMap<String, String>();
        for (String attributeName : attributeNames) {
            String attributeId;
            String linkTypeId = QueryableLinkAttribute.getLinkTypeId(attributeName);
            if (linkTypeId == null || (attributeId = linkTypeToAttributeMap.get(linkTypeId)) == null) continue;
            contextMap.put(linkTypeId, attributeId);
        }
        return contextMap;
    }

    private static class EstimateConfiguration {
        private String fProgressMode;
        private String fOutputFormat;

        public EstimateConfiguration(String progressMode, String outputFormat) {
            this.fProgressMode = progressMode;
            this.fOutputFormat = outputFormat;
        }

        public boolean useTimeRemaining() {
            return ProcessConfigurationManager.PROGRESS_MODE_TIME_REMAINING_NAME.equals(this.fProgressMode);
        }

        public boolean useHourOutputForma() {
            return ProcessConfigurationManager.HOURS_OUTPUT_FORMAT.equals(this.fOutputFormat);
        }
    }
}

