/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CustomDefaultContributorsProvider
implements IDefaultValueProvider<List<IContributor>> {
    @Override
    public List<IContributor> getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IConfiguration> values = configuration.getChildren("value");
        if (values.isEmpty()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorsProvider.CONFIGURED_VALUE_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorsProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (IConfiguration value : values) {
            String userId = value.getString("content");
            if (userId == null || "".equals(userId.trim())) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorsProvider.VALUE_CONFIGURED_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorsProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
            }
            userIds.add(userId);
        }
        QueryIterator<IContributorHandle> iterator = WorkItemQueries.contributorsByUserId(workItemCommon.getAuditableCommon(), userIds.toArray(new String[userIds.size()]));
        List<IContributorHandle> contributors = iterator.toList(monitor);
        if (contributors.size() != userIds.size()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorsProvider.NUMBER_OF_CONTRIBUTORS_NOT_FOUND"), (Object)(userIds.size() - contributors.size()), (Object[])new Object[]{workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorsProvider.NONE_WORK_ITEM"), attribute.getDisplayName()}));
        }
        return workItemCommon.getAuditableCommon().resolveAuditables(contributors, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }
}

