/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.workitem.common.internal.emailtemplates.Messages;
import com.ibm.team.workitem.common.internal.rcp.dto.MailTemplateErrorInfoDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import java.io.Serializable;

public class TemplateErrorInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExceptionType fExceptionType;
    private int fColumn;
    private int fLine;
    private String fInfo;

    public TemplateErrorInfo(ExceptionType exceptionType) {
        this.fExceptionType = exceptionType;
    }

    private TemplateErrorInfo() {
    }

    public String getExceptionTypeName() {
        return Messages.getString(this.fExceptionType.getLabelKey());
    }

    public boolean hasPositionInfo() {
        return this.fLine > 0 || this.fColumn > 0;
    }

    public String getPositionInfo() {
        return String.format("%s %d, %s %d", Messages.getString("TemplateException_LINE"), this.fLine, Messages.getString("TemplateException_COLUMN"), this.fColumn);
    }

    public int getColumn() {
        return this.fColumn;
    }

    public void setColumn(int column) {
        this.fColumn = column;
    }

    public int getRow() {
        return this.fLine;
    }

    public void setRow(int row) {
        this.fLine = row;
    }

    public String getInfo() {
        return this.fInfo;
    }

    public void setInfo(String info) {
        this.fInfo = info;
    }

    public MailTemplateErrorInfoDTO toDTO() {
        MailTemplateErrorInfoDTO dto = RcpFactory.eINSTANCE.createMailTemplateErrorInfoDTO();
        if (this.fExceptionType != null) {
            dto.setExceptionType(this.fExceptionType.name());
        }
        dto.setColumn(this.fColumn);
        dto.setLine(this.fLine);
        dto.setAdditionalInfo(this.fInfo);
        return dto;
    }

    public static TemplateErrorInfo fromDTO(MailTemplateErrorInfoDTO dto) {
        TemplateErrorInfo instance = new TemplateErrorInfo();
        instance.fColumn = dto.getColumn();
        instance.fLine = dto.getLine();
        instance.fInfo = dto.getAdditionalInfo();
        if (dto.getExceptionType() != null) {
            instance.fExceptionType = ExceptionType.valueOf(ExceptionType.class, dto.getExceptionType());
        }
        return instance;
    }

    public static enum ExceptionType {
        PARSE_ERROR("TemplateException_LABEL_PARSE_ERROR"),
        INVALID_REFERENCE("TemplateException_LABEL_INVALID_REFERENCE"),
        METHOD_INVOCATION_EXCEPTION("TemplateException_LABEL_METHOD_INVOCATION_EXCEPTION"),
        IO_EXCEPTION("TemplateException_LABEL_IO_EXCEPTION"),
        EXCEPTION("TemplateException_LABEL_EXCEPTION");

        private final String fLabelKey;

        private ExceptionType(String labelKey) {
            this.fLabelKey = labelKey;
        }

        public String getLabelKey() {
            return this.fLabelKey;
        }
    }
}

