/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.AssertionFailedException;

public class CategoryBuilder
extends AbstractArtifactBuilder<ICategory> {
    protected static final ValueKey<String> NAME = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".name");
    protected static final ValueKey<String> INTERNAL_CATEGORY_ID = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".internalCategoryId");
    protected static final ValueKey<ICategoryHandle> PARENT_CATEGORY = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".parentCategory");
    protected static final ValueKey<IProjectAreaHandle> PROJECT_AREA = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<UUID> CONTEXT_ID = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<Boolean> ARCHIVED = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".archived");
    protected static final ValueKey<Boolean> FILTERED = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".filtered");
    protected static final ValueKey<ITeamAreaHandle> DEFAULT_TEAM_AREA = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".defaultTeamArea");
    protected static final ValueKey<ItemHandleAwareHashSet> TEAM_AREAS = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".teamAreas");
    protected static final ValueKey<Boolean> READ_ACCESS_ENABLED = new ValueKey(String.valueOf(CategoryBuilder.class.getName()) + ".readAccessEnabled");

    public CategoryBuilder(IArtifactBuilderContext context) {
        super(context);
        this.setBuilderValue(TEAM_AREAS, new ItemHandleAwareHashSet());
    }

    public CategoryBuilder categoryId(CategoryId categoryId) {
        this.setBuilderValue(INTERNAL_CATEGORY_ID, categoryId.getInternalRepresentation());
        return this;
    }

    public CategoryBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public CategoryBuilder parentCategory(ICategoryHandle parentCategory) {
        this.setBuilderValue(PARENT_CATEGORY, parentCategory);
        return this;
    }

    public CategoryBuilder projectArea(IProjectAreaHandle projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        if (!this.isBuilderValueSet(CONTEXT_ID)) {
            this.setBuilderValue(CONTEXT_ID, projectArea.getItemId());
        }
        return this;
    }

    public CategoryBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID, contextId);
        return this;
    }

    public CategoryBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED, archived);
        return this;
    }

    public CategoryBuilder readAccessEnabled(boolean readAccessEnabled) {
        this.setBuilderValue(READ_ACCESS_ENABLED, readAccessEnabled);
        return this;
    }

    public CategoryBuilder filtered(boolean filtered) {
        this.setBuilderValue(FILTERED, filtered);
        return this;
    }

    public CategoryBuilder defaultTeamArea(ITeamAreaHandle defaultTeamArea) {
        this.setBuilderValue(DEFAULT_TEAM_AREA, defaultTeamArea);
        return this;
    }

    public CategoryBuilder teamAreas(ITeamAreaHandle ... teamAreas) {
        if (teamAreas != null) {
            ((ItemHandleAwareHashSet)this.getBuilderValue(TEAM_AREAS)).addAll(Arrays.asList(teamAreas));
        }
        return this;
    }

    protected ICategory doBuild(BuildContext buildContext) {
        return this.setCategoryFields((Category)this.artifact(ICategory.ITEM_TYPE));
    }

    protected ICategory doSave(BuildContext saveContext) throws TeamRepositoryException {
        Category category;
        IProjectAreaHandle projectArea = (IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, (IProjectAreaHandle)saveContext.getProperty(BuildContext.PROJECT_AREA));
        if (!this.artifactExists() && projectArea == null && !this.isBuilderValueSet(PARENT_CATEGORY)) {
            throw new IllegalStateException("Can only save cateogry if the parent category or the projectArea is specified");
        }
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class);
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        if (this.artifactExists()) {
            category = (Category)this.artifact(ICategory.ITEM_TYPE);
        } else {
            ICategoryHandle parentCategory = (ICategoryHandle)this.getBuilderValue(PARENT_CATEGORY, workItemCommon.findUnassignedCategory(projectArea, ICategory.DEFAULT_PROFILE, null));
            Category createSubcategory = (Category)workItemCommon.createSubcategory(parentCategory, (String)this.getBuilderValue(NAME, "Category " + UUID.generate().getUuidValue()), null);
            category = (Category)createSubcategory.getWorkingCopy();
        }
        this.setCategoryFields(category);
        workItemCommon.saveCategory(category, null);
        return auditableCommon.resolveAuditable(category, ICategory.FULL_PROFILE, null);
    }

    protected Category setCategoryFields(Category category) {
        String defaultId = UUID.generate().getUuidValue();
        category.setInternalCategoryId((String)this.chooseValue(INTERNAL_CATEGORY_ID, this.getDefaultCategoryId(category, defaultId)));
        category.setName((String)this.chooseValue(NAME, category.getName(), "Category " + defaultId));
        category.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, category.getProjectArea()));
        category.setContextId((UUID)this.getBuilderValue(CONTEXT_ID, category.getContextId()));
        ItemHandleAwareHashSet builderTeams = (ItemHandleAwareHashSet)this.getBuilderValue(TEAM_AREAS);
        builderTeams.removeAll((Collection)category.getTeamAreas());
        category.getTeamAreas().addAll(builderTeams);
        category.doSetDefaultTeamArea((ITeamAreaHandle)this.getBuilderValue(DEFAULT_TEAM_AREA, category.getDefaultTeamArea()));
        category.setArchived((Boolean)this.getBuilderValue(ARCHIVED, category.isArchived()));
        category.setFiltered((Boolean)this.getBuilderValue(FILTERED, category.isFiltered()));
        category.setReadAccessEnabled((Boolean)this.getBuilderValue(READ_ACCESS_ENABLED, category.isReadAccessEnabled()));
        return category;
    }

    private String getDefaultCategoryId(ICategory category, String defaultId) {
        if (this.artifactExists()) {
            return category.getCategoryId().getInternalRepresentation();
        }
        ICategoryHandle parent = (ICategoryHandle)this.getBuilderValue(PARENT_CATEGORY);
        if (parent instanceof ICategory) {
            return CategoriesHelper.createCategoryId(((ICategory)parent).getCategoryId(), defaultId).getInternalRepresentation();
        }
        String parentId = "";
        try {
            parentId = category.getParentId2().getInternalRepresentation();
        }
        catch (NullPointerException nullPointerException) {
            parentId = "/Unassigned/";
        }
        catch (AssertionFailedException assertionFailedException) {
            parentId = "/Unassigned/";
        }
        return String.valueOf(parentId) + defaultId + "/";
    }
}

