/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class FileSystemStatusException
extends FileSystemException {
    private static final long serialVersionUID = 1L;

    public static FileSystemStatusException fromCoreException(String message, CoreException exception) {
        if (message == null) {
            message = exception.getMessage();
        }
        return new FileSystemStatusException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, new IStatus[]{exception.getStatus()}, message, (Throwable)exception));
    }

    public FileSystemStatusException(IStatus status) {
        super(status.getMessage());
        this.setExtraData("exceptionData", status);
    }

    public FileSystemStatusException(int severity, String pluginID, String message, Throwable cause) {
        super(message);
        Status status = new Status(severity, pluginID, message, (Throwable)((Object)this));
        this.setExtraData("exceptionData", status);
    }

    public FileSystemStatusException(Object origin, IStatus status) {
        super(origin, status.getMessage());
        this.setExtraData("exceptionData", status);
    }

    public FileSystemStatusException(String message, Throwable cause) {
        super(message, cause);
        Status status = new Status(4, "com.ibm.team.filesystem.client", message, cause);
        this.setExtraData("exceptionData", status);
    }

    public Throwable getCause() {
        return super.getCause() == null ? this.getStatus().getException() : super.getCause();
    }

    public String toString() {
        return NLS.bind((String)Messages.FileSystemClientException_0, (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), this.getStatus().toString()}, (Object[])new Object[0]);
    }

    public final IStatus getStatus() {
        Object data = this.getExtraData("exceptionData");
        if (data instanceof IStatus) {
            return (IStatus)data;
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            IStatus status = this.getStatus();
            if (status.getException() != null && status.getException() != this.getCause()) {
                output.print(String.valueOf(((Object)((Object)this)).getClass().getName()) + " : " + status.getMessage() + " [" + status.getCode() + "]");
                status.getException().printStackTrace(output);
            }
            this.printChildrenStatus("Contains : ", status, output);
        }
    }

    private void printChildrenStatus(String level, IStatus status, PrintStream output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            String prefix = String.valueOf(level) + i;
            output.println(String.valueOf(prefix) + " " + children[i].getMessage());
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            output.flush();
            this.printChildrenStatus(String.valueOf(prefix) + ".", children[i], output);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            IStatus status = this.getStatus();
            if (status.getException() != null) {
                output.print(String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + status.getCode() + "]: ");
                status.getException().printStackTrace(output);
            }
            this.printChildrenStatus("Contains : ", status, output);
        }
    }

    private void printChildrenStatus(String level, IStatus status, PrintWriter output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            String prefix = String.valueOf(level) + i;
            output.println(String.valueOf(prefix) + " " + children[i].getMessage());
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            output.flush();
            this.printChildrenStatus(String.valueOf(prefix) + ".", children[i], output);
            ++i;
        }
    }

    public void setStatus(IStatus status) {
        this.setExtraData("exceptionData", status);
    }
}

