/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.componenthierarchy;

import com.ibm.team.filesystem.client.IComponentHierarchyManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class ComponentHierarchyManager
extends EventSource
implements IComponentHierarchyManager {
    private static ComponentHierarchyManager INSTANCE;
    public static final String COMPONENT_HIERARCHY_ENABLEMENT = "component_hierarchy_enablement";
    private Map<ITeamRepository, Boolean> fHierarchicalComponentEnablement = new ConcurrentHashMap<ITeamRepository, Boolean>();
    private Set<ITeamRepository> fAddedLoginParticipants = new HashSet<ITeamRepository>();
    private ITeamRepositoryService.IRepositoryServiceListener fRepoServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addedRepository(ITeamRepository repo) {
            Set set = ComponentHierarchyManager.this.fAddedLoginParticipants;
            synchronized (set) {
                repo.addLoginParticipant(ComponentHierarchyManager.this.fLoginParticipant);
                ComponentHierarchyManager.this.fAddedLoginParticipants.add(repo);
                if (repo.loggedIn()) {
                    ComponentHierarchyManager.this.checkHierarchicalComponentEnablement(repo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedRepository(ITeamRepository repo) {
            Set set = ComponentHierarchyManager.this.fAddedLoginParticipants;
            synchronized (set) {
                repo.removeLoginParticipant(ComponentHierarchyManager.this.fLoginParticipant);
                ComponentHierarchyManager.this.fAddedLoginParticipants.remove(repo);
            }
        }
    };
    private ITeamRepository.ILoginParticipant fLoginParticipant = new ITeamRepository.ILoginParticipant(){

        public void handleLogin(ITeamRepository repo) {
            ComponentHierarchyManager.this.checkHierarchicalComponentEnablement(repo);
        }

        public void handleLogout(ITeamRepository repo) {
        }
    };

    public static synchronized void start() {
        if (INSTANCE == null) {
            INSTANCE = new ComponentHierarchyManager();
            INSTANCE.addListeners();
        }
    }

    public static synchronized ComponentHierarchyManager getInstance() {
        if (INSTANCE == null) {
            ComponentHierarchyManager.start();
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE.removeListeners();
            INSTANCE = null;
        }
    }

    private ComponentHierarchyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListeners() {
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepoServiceListener);
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        Set<ITeamRepository> set = this.fAddedLoginParticipants;
        synchronized (set) {
            ITeamRepository[] iTeamRepositoryArray = repos;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                repo.addLoginParticipant(this.fLoginParticipant);
                this.fAddedLoginParticipants.add(repo);
                if (repo.loggedIn()) {
                    this.checkHierarchicalComponentEnablement(repo);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepoServiceListener);
        Set<ITeamRepository> set = this.fAddedLoginParticipants;
        synchronized (set) {
            Iterator<ITeamRepository> setIterator = this.fAddedLoginParticipants.iterator();
            while (setIterator.hasNext()) {
                ITeamRepository repo = setIterator.next();
                repo.removeLoginParticipant(this.fLoginParticipant);
                setIterator.remove();
            }
        }
    }

    @Override
    public synchronized boolean isHierarchicalComponentsEnabled(ITeamRepository repo) {
        boolean isEnabled = false;
        Boolean isEnabledInRepo = this.fHierarchicalComponentEnablement.get(repo);
        if (isEnabledInRepo != null) {
            isEnabled = isEnabledInRepo;
        }
        return isEnabled;
    }

    public synchronized void setIsHierarchicalComponentsEnabled(ITeamRepository repo, boolean isEnabled) {
        this.fHierarchicalComponentEnablement.put(repo, isEnabled);
    }

    private void checkHierarchicalComponentEnablement(final ITeamRepository repo) {
        Job j = new Job(NLS.bind((String)Messages.ComponentHierarchyManager_ComponentHierarchyEnablementJob, (Object)repo.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IRepositoryProgressMonitor repoMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
                    IScmService scmService = ((WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)repo)).getServerConfigurationService();
                    boolean isEnabled = scmService.isHierarchicalComponentsEnabled((IRepositoryProgressMonitorHandle)repoMonitor);
                    ComponentHierarchyManager.this.setIsHierarchicalComponentsEnabled(repo, isEnabled);
                    ComponentHierarchyManager.this.queueEvent(new PropertyChangeEvent((IEventSource)ComponentHierarchyManager.this, "com.ibm.team.repository.PropertySet", (Object)repo, (Object)ComponentHierarchyManager.COMPONENT_HIERARCHY_ENABLEMENT));
                }
                catch (Exception e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }
}

