/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ChangedInfosValue;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.WCChangedInfoKey;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class ChangedInfosMapValidator
extends DiskBackedHashMapEntriesValidator {
    protected static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    protected static final String SCM_CHANGED_INFOS_SEPARATOR = "_";
    protected static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    protected static final int UUID_LENGTH = 23;
    protected static final int MIN_KEY_SIZE = 4;
    protected static final int VALUE_SIZE = 7;
    protected static final byte KEY_TAG = 0;
    protected static final byte VALUE_TAG = 1;
    protected static final int VERSION = 1;
    protected String componentId;
    protected String connectionId;
    protected File cfaRoot;

    public ChangedInfosMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        this.componentId = null;
        this.connectionId = null;
        boolean valid = false;
        String fn = this.hv.getHeapFile().getName();
        if (fn.length() == SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length() + 23 + SCM_CHANGED_INFOS_SUFFIX.length()) {
            this.componentId = fn.substring(SCM_CHANGED_INFOS_PREFIX.length(), SCM_CHANGED_INFOS_PREFIX.length() + 23);
            this.connectionId = fn.substring(SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length(), SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length() + 23);
            if (this.isValidUUID(this.componentId) && this.isValidUUID(this.connectionId) && fn.startsWith(SCM_CHANGED_INFOS_PREFIX) && fn.endsWith(SCM_CHANGED_INFOS_SUFFIX) && fn.substring(SCM_CHANGED_INFOS_PREFIX.length() + 23, SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length()).equals(SCM_CHANGED_INFOS_SEPARATOR)) {
                valid = true;
            }
        }
        if (!valid) {
            this.log.append("Invalid change infos map file name: " + fn + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid changed infos map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos value of entry at " + entryOffset + "\n");
        }
        ChangedInfosKey k = this.validateKey(entryOffset, keyOffset, hash, raf);
        ChangedInfosValue v = this.validateValue(entryOffset, valueOffset, k, raf);
        if (k != null && v != null && this.componentId != null && this.connectionId != null) {
            WCChangedInfoKey wccik = new WCChangedInfoKey(this.componentId, this.connectionId, k.uuid, k.isFolder);
            this.gv.addModifiedInfo(wccik, v);
        }
    }

    protected ChangedInfosKey validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset + 4L > this.hv.getWorkingAreaSize()) {
            this.log.append("The changed infos key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String uuid;
            int isFolder;
            int tag = this.validateByte("changed infos key", keyOffset, "tag", raf);
            if (tag == -1) {
                return null;
            }
            if (tag != 0) {
                this.log.append("Unexpected tag found instead of KEY_TAG " + tag + " at offset " + keyOffset + "\n");
            }
            if ((isFolder = this.validateByte("changed infos key", keyOffset, "isFolder", raf)) == -1) {
                return null;
            }
            if ((isFolder & 0xFFFFFFFE) != 0) {
                this.log.append("Unexpected value found for isFolder " + isFolder + " at offset " + keyOffset + "\n");
            }
            if ((uuid = this.validateUUID("changed infos key", keyOffset, "item id", raf)) == null) {
                return null;
            }
            if (hashCode != uuid.hashCode()) {
                this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for changed infos key at " + keyOffset + " with UUID \"" + uuid + "\" whose hash code is " + uuid.hashCode() + "\n");
            }
            ChangedInfosKey result = new ChangedInfosKey(uuid, isFolder != 0);
            this.addKey(result, entryOffset, keyOffset, "changed infos");
            ChangedInfosKey changedInfosKey = result;
            return changedInfosKey;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Changed Infos key"));
        }
    }

    protected ChangedInfosValue validateValue(long entryOffset, long valueOffset, ChangedInfosKey k, RAFWrapper raf) throws IOException {
        int isContentChanged;
        long version;
        if (valueOffset < 0L || valueOffset + 7L > this.hv.getWorkingAreaSize()) {
            this.log.append("The changed infos value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, 7L, "Changed Infos value"));
        this.setPosition(valueOffset);
        int tag = this.validateByte("changed infos value", valueOffset, "tag", raf);
        if (tag == -1) {
            return null;
        }
        if (tag != 1) {
            this.log.append("Unexpected tag found instead of VALUE_TAG " + tag + " at offset " + valueOffset + "\n");
        }
        if ((version = this.validateInt("changed infos value", valueOffset, "version", raf)) == -1L) {
            return null;
        }
        if (version != 1L) {
            this.log.append("Unknown Changed Infos format version: " + version + "\n");
            return null;
        }
        int isPathChanged = this.validateByte("changed infos value", valueOffset, "isPathChanged", raf);
        if (isPathChanged == -1) {
            return null;
        }
        if ((isPathChanged & 0xFFFFFFFE) != 0) {
            this.log.append("Unexpected value found for isPathChanged " + isPathChanged + " at offset " + valueOffset + "\n");
        }
        if ((isContentChanged = this.validateByte("changed infos value", valueOffset, "isContentChanged", raf)) == -1) {
            return null;
        }
        if ((isContentChanged & 0xFFFFFFFE) != 0) {
            this.log.append("Unexpected value found for isContentChanged " + isContentChanged + " at offset " + valueOffset + "\n");
        }
        if (isPathChanged == 0 && isContentChanged == 0) {
            this.log.append("Both isPathChanged and isContentChanged are 0 at offset " + valueOffset + "\n");
        }
        if (k != null && k.isFolder && isContentChanged != 0) {
            this.log.append("isContentChanged is " + isContentChanged + " for folder " + k.uuid + " at offset " + valueOffset + "\n");
        }
        return new ChangedInfosValue(isPathChanged != 0, isContentChanged != 0);
    }

    public static class ChangedInfosKey
    implements Serializable {
        private static final long serialVersionUID = -8702641957280124528L;
        protected String uuid;
        protected boolean isFolder;

        public ChangedInfosKey(String uuid, boolean isFolder) {
            this.uuid = uuid;
            this.isFolder = isFolder;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChangedInfosKey)) {
                return false;
            }
            return ((ChangedInfosKey)obj).uuid.equals(this.uuid);
        }

        public String toString() {
            return String.valueOf(this.isFolder ? "folder " : "non-folder ") + this.uuid;
        }
    }
}

