/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.ChildLoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.ParentLoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ChildFilterBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ComponentBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.SandboxPathBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.VersionableBuilder;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;

public class ParentLoadBuilder
extends RuleBuilder {
    private ChildLoadFilter include;
    private ChildLoadFilter exclude;

    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws TeamRepositoryException {
        ILoadRuleBuilder builder;
        if (eName.equals("parentLoadRule")) {
            builder = this;
        } else if (eName.equals("component")) {
            builder = new ComponentBuilder(this);
            builder.startElement(eName, attrs);
        } else if (eName.equals("parentFolder")) {
            builder = new VersionableBuilder(this);
            builder.startElement(eName, attrs);
        } else if (eName.equals("include") || eName.equals("exclude")) {
            builder = new ChildFilterBuilder(this);
            builder.startElement(eName, attrs);
        } else if (eName.equals("sandboxRelativePath")) {
            builder = new SandboxPathBuilder(this);
            builder.startElement(eName, attrs);
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ParentLoadBuilder_0, (Object)eName));
        }
        return builder;
    }

    public void setFilter(ChildLoadFilter filter) {
        if (filter.isInclude()) {
            this.include = filter;
        } else {
            this.exclude = filter;
        }
    }

    @Override
    public void setVersionableHandle(IVersionableHandle versionable) throws FileSystemException {
        if (!(versionable instanceof IFolderHandle)) {
            throw new FileSystemException(NLS.bind((String)Messages.ParentLoadBuilder_1, (Object)versionable.getItemId().getUuidValue()));
        }
        super.setVersionableHandle(versionable);
    }

    @Override
    public LoadRequest getRequest(IConnection connection, IComponent component) {
        ParentLoadRequest request = this.getVersionableHandle() != null ? new ParentLoadRequest(connection, component, this.getRelativeLoadLocation(), this.include, this.exclude, (IFolderHandle)this.getVersionableHandle()) : new ParentLoadRequest(connection, component, this.getRelativeLoadLocation(), this.include, this.exclude, this.getRepositoryPath());
        return request;
    }

    @Override
    public String getRequestBuilderType() {
        return "parentLoadRule";
    }
}

