/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.api.content.MagicContentExaminer;
import com.ibm.team.filesystem.client.internal.api.content.SniffContentExaminer;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalContentExaminer
extends MagicContentExaminer
implements IContentExaminer {
    public static final String ENCODING_OVERRIDE_PROPERTY_NAME = "file.encoding";
    public static final String PRESERVE_ENCODING_PROPERTY_NAME = "preserve.file.encoding";
    private static volatile LocalContentExaminer instance = null;
    private SniffContentExaminer sniffContentExaminer = new SniffContentExaminer();

    static {
        instance = new LocalContentExaminer();
    }

    public static IContentExaminer getInstance() {
        return instance;
    }

    public LocalContentExaminer(String pathToUserHome) {
        super(pathToUserHome);
    }

    public LocalContentExaminer() {
    }

    public IContentProperties examine(String name, MagicContentExaminer.IStreamSource data, IProgressMonitor progress) throws FileSystemException {
        return this.examine(name, data, null, progress);
    }

    public IContentProperties examine(String name, MagicContentExaminer.IStreamSource data, String encodingHint, IProgressMonitor progress) throws FileSystemException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        IContentProperties contentProperties = this.getMagicProperties(name, (IProgressMonitor)mon.newChild(5));
        String encoding = this.getEncoding(name, data, encodingHint, (IProgressMonitor)mon.newChild(5));
        return new ContentProperties(encoding, contentProperties.getMimeType(), contentProperties.getLineDelimiter());
    }

    @Override
    public IContentProperties examine(final IShareable shareable, IProgressMonitor mon) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)2);
        return this.examine(shareable.getLocalPath().getName(), new MagicContentExaminer.IStreamSource(){

            @Override
            public InputStream getStream() throws FileSystemException {
                return ((Shareable)shareable).getFileStorage().getContents(null);
            }
        }, this.getEncodingHint(shareable, (IProgressMonitor)progress.newChild(1)), (IProgressMonitor)progress.newChild(1));
    }

    @Override
    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor mon) throws FileSystemException {
        String encoding;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(10));
        if (file == null || type == null) {
            return ContentProperties.UNKNOWN;
        }
        String mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(20));
        FileLineDelimiter lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(20));
        if (mimeType == null || lineDelimiter == null) {
            IContentProperties props = this.examine(shareable, (IProgressMonitor)progress.newChild(50));
            if (mimeType == null) {
                mimeType = props.getMimeType();
            }
            if (lineDelimiter == null) {
                lineDelimiter = props.getLineDelimiter();
            }
            encoding = props.getEncoding();
        } else {
            MagicContentExaminer.IStreamSource data = new MagicContentExaminer.IStreamSource(){

                @Override
                public InputStream getStream() throws FileSystemException {
                    block3: {
                        try {
                            if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                            return null;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                    return new FileInputStream(file);
                }
            };
            encoding = this.getEncoding(shareable.getLocalPath().getName(), data, this.getEncodingHint(shareable, (IProgressMonitor)progress.newChild(10)), (IProgressMonitor)progress.newChild(40));
        }
        return new ContentProperties(encoding, mimeType, lineDelimiter);
    }

    @Override
    public String getEncoding(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)15);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)mon.newChild(5));
        String encoding = null;
        MagicContentExaminer.IStreamSource data = new MagicContentExaminer.IStreamSource(){

            @Override
            public InputStream getStream() throws FileSystemException {
                block3: {
                    try {
                        if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
                return new FileInputStream(file);
            }
        };
        encoding = this.getEncoding(shareable.getLocalPath().getName(), data, this.getEncodingHint(shareable, (IProgressMonitor)mon.newChild(5)), (IProgressMonitor)mon.newChild(5));
        return encoding;
    }

    private String getEncodingHint(IShareable shareable, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            String encoding;
            FileItemInfo fileItemInfo;
            boolean preserveEncoding;
            IMetadataProperties metadataProperties = shareable.getMetadataProperties((IProgressMonitor)progress.newChild(1));
            String preserveString = metadataProperties.getCurrentProperties().get(PRESERVE_ENCODING_PROPERTY_NAME);
            if (preserveString != null && (preserveEncoding = Boolean.valueOf(preserveString).booleanValue()) && (fileItemInfo = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)progress.newChild(1))) != null && (encoding = fileItemInfo.getStoredEncoding()) != null) {
                return encoding;
            }
            return metadataProperties.getCurrentProperties().get(ENCODING_OVERRIDE_PROPERTY_NAME);
        }
        catch (FileSystemException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            return null;
        }
    }

    private String getEncoding(String name, MagicContentExaminer.IStreamSource data, String encodingHint, IProgressMonitor mon) throws FileSystemException {
        String encoding = null;
        if (data != null) {
            encoding = this.sniffContentExaminer.sniffEncoding(data);
        }
        if (encoding == null) {
            encoding = encodingHint;
        }
        if (encoding == null) {
            encoding = this.getMagicEncoding(name, mon);
        }
        if (encoding == null) {
            encoding = System.getProperty(ENCODING_OVERRIDE_PROPERTY_NAME);
        }
        return encoding;
    }

    public void makeDefault() {
        instance = this;
    }
}

