/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MoveFoldersOperation
extends ChangeHistoryChangeSetsOperation
implements IMoveFoldersOperation {
    private List<MoveRequest> moveRequests;
    private Map<IWorkspaceConnection, List<RenameRequest>> renameRequests;
    private MoveFoldersDilemmaHandler moveDilemmaHandler;

    public MoveFoldersOperation(MoveFoldersDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler);
        this.moveDilemmaHandler = dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler;
        this.moveRequests = new ArrayList<MoveRequest>();
        this.renameRequests = new HashMap<IWorkspaceConnection, List<RenameRequest>>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        monitor.setTaskName(Messages.MoveFoldersOperation_0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MoveAcrossComponent_ProgressMessage, (int)100);
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(monitor);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        MoveFoldersOperation.this.processRequests(affectedConfigurations, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.MoveFoldersOperation_1, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private Set<ConfigurationFacade> getAffectedConfigurations(IProgressMonitor progress) {
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        SharingManager manager = SharingManager.getInstance();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.moveRequests.size() * 2));
        for (MoveRequest moveRequest : this.moveRequests) {
            IWorkspaceConnection workspaceConnection = moveRequest.workspaceConnection;
            ConfigurationFacade facade = new ConfigurationFacade((IConnection)workspaceConnection, moveRequest.sourceComponent);
            configurations.add(facade);
            try {
                Collection<ICopyFileArea> cfas = CopyFileAreaManager.instance.getCopyFileAreasForConfiguration(facade, (IProgressMonitor)monitor.newChild(1));
                SubMonitor cfaMon = monitor.newChild(1);
                cfaMon.setWorkRemaining(cfas.size());
                for (ICopyFileArea area : cfas) {
                    ILocation root = area.getRoot();
                    IVersionableHandle[] versionablesToMove = moveRequest.versionablesToMove;
                    SubMonitor handlesMon = cfaMon.newChild(1);
                    handlesMon.setWorkRemaining(versionablesToMove.length * 2);
                    IVersionableHandle[] iVersionableHandleArray = versionablesToMove;
                    int n = versionablesToMove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVersionableHandle handle = iVersionableHandleArray[n2];
                        IShareable source = manager.findShareable(root, workspaceConnection.getContextHandle(), moveRequest.sourceComponent, handle, (IProgressMonitor)handlesMon.newChild(1));
                        if (source != null) {
                            for (IShare share2 : CopyFileAreaUtil.getNestedShares(source)) {
                                configurations.add(new ConfigurationFacade((IConnection)workspaceConnection, share2.getSharingDescriptor().getComponent()));
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (FileSystemException fileSystemException) {}
            configurations.add(new ConfigurationFacade((IConnection)workspaceConnection, moveRequest.targetComponent));
        }
        for (List list : this.renameRequests.values()) {
            for (RenameRequest request : list) {
                configurations.add(new ConfigurationFacade((IConnection)request.workspaceConnection, request.component));
            }
        }
        return configurations;
    }

    @Override
    public void addMoveWithinComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle[] foldersToMove, IFolderHandle[] toDestinationFolders, String changeSetComment) {
        IVersionableHandle folder;
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IVersionableHandle[] iVersionableHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            folder = iVersionableHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        iVersionableHandleArray = toDestinationFolders;
        n = toDestinationFolders.length;
        n2 = 0;
        while (n2 < n) {
            folder = iVersionableHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, component, foldersToMove, component, toDestinationFolders, changeSetComment, changeSetComment);
        this.moveRequests.add(request);
    }

    @Override
    public void addRenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle[] versionablesToRename, String[] newNames, String changeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException("WorkspaceConnection must be supplied for rename request");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be supplied for rename request");
        }
        if (versionablesToRename == null) {
            throw new IllegalArgumentException("Versionables to be renamed must be supplied for rename request");
        }
        if (newNames == null) {
            throw new IllegalArgumentException("New versionable names must be supplied");
        }
        if (versionablesToRename.length != newNames.length) {
            throw new IllegalArgumentException("There must be a new name for each and every versionable");
        }
        RenameRequest request = new RenameRequest(workspaceConnection, component, versionablesToRename, newNames, changeSetComment);
        List<RenameRequest> requestsForWorkspace = this.renameRequests.get(workspaceConnection);
        if (requestsForWorkspace == null) {
            requestsForWorkspace = new ArrayList<RenameRequest>();
            this.renameRequests.put(workspaceConnection, requestsForWorkspace);
        }
        requestsForWorkspace.add(request);
    }

    @Override
    public void addMoveAcrossComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IFolderHandle[] foldersToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent == null) {
            throw new IllegalArgumentException();
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent.sameItemId((IItemHandle)targetComponent)) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IFolderHandle folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, sourceComponent, (IVersionableHandle[])foldersToMove, targetComponent, toDestinationFolders, sourceChangeSetComment, targetChangeSetComment);
        this.moveRequests.add(request);
    }

    private void processRequests(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + 100 * this.moveRequests.size()));
        if (this.verifyInSyncEnabled() && !this.moveDilemmaHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.moveDilemmaHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationFacade configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)((IWorkspaceConnection)configurationDescriptor.getConnection(null)), configurationDescriptor.getComponentHandle());
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        this.checkCancelled((IProgressMonitor)progress);
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.moveDilemmaHandler, true, (IProgressMonitor)progress.newChild(30));
            this.checkCancelled((IProgressMonitor)progress);
            for (MoveRequest moveRequest : this.moveRequests) {
                IUpdateReport report;
                if (moveRequest.sourceComponent.sameItemId((IItemHandle)moveRequest.targetComponent)) {
                    report = this.moveFoldersWithinComponent(moveRequest, (IProgressMonitor)progress.newChild(50));
                } else {
                    IFolderHandle[] foldersToMove = new IFolderHandle[moveRequest.versionablesToMove.length];
                    int i = 0;
                    while (i < moveRequest.versionablesToMove.length) {
                        foldersToMove[i] = (IFolderHandle)moveRequest.versionablesToMove[i];
                        ++i;
                    }
                    report = moveRequest.workspaceConnection.moveFoldersBetweenComponents(moveRequest.sourceComponent, moveRequest.targetComponent, foldersToMove, moveRequest.toDestinationFolders, moveRequest.sourceChangeSetComment, moveRequest.targetChangeSetComment, (IProgressMonitor)progress.newChild(48));
                }
                this.checkCancelled((IProgressMonitor)progress);
                UpdateOperation op = new UpdateOperation(moveRequest.workspaceConnection, Collections.singletonList(report), 3, this.moveDilemmaHandler, null);
                this.disableVerifyInSync(op);
                progress.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
                op.run((IProgressMonitor)progress.newChild(50));
            }
            for (Map.Entry entry : this.renameRequests.entrySet()) {
                this.processRenames((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), (IProgressMonitor)progress.newChild(100));
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    private IUpdateReport moveFoldersWithinComponent(MoveRequest moveRequest, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        List<IVersionableHandle> toMove = Arrays.asList(moveRequest.versionablesToMove);
        List fullToMove = moveRequest.workspaceConnection.configuration(moveRequest.sourceComponent).fetchCompleteItems(toMove, (IProgressMonitor)monitor.newChild(10));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(moveRequest.workspaceConnection, null);
        int i = 0;
        SubMonitor iterProgress = monitor.newChild(5);
        iterProgress.setWorkRemaining(fullToMove.size());
        for (IVersionable itemToMove : fullToMove) {
            itemToMove = (IVersionable)itemToMove.getWorkingCopy();
            itemToMove.setParent(moveRequest.toDestinationFolders[i]);
            IWorkspaceConnection.ISaveOp op = moveRequest.workspaceConnection.configurationOpFactory().save(itemToMove);
            changeSetChooser.toCommit(moveRequest.sourceComponent, (IVersionableHandle)itemToMove, (IWorkspaceConnection.IConfigurationOp)op, null, moveRequest.sourceChangeSetComment, (IProgressMonitor)iterProgress.newChild(1));
            ++i;
        }
        return changeSetChooser.commit((IProgressMonitor)monitor.newChild(85));
    }

    private void processRenames(IWorkspaceConnection workspaceConnection, List<RenameRequest> renames, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + 15 * renames.size()));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(workspaceConnection, null);
        for (RenameRequest request : renames) {
            List<IVersionableHandle> toRename = Arrays.asList(request.versionablesToRename);
            List fullToRename = workspaceConnection.configuration(request.component).fetchCompleteItems(toRename, (IProgressMonitor)progress.newChild(10));
            int i = 0;
            SubMonitor iterProgress = progress.newChild(5);
            iterProgress.setWorkRemaining(fullToRename.size());
            for (IVersionable itemToRename : fullToRename) {
                itemToRename = (IVersionable)itemToRename.getWorkingCopy();
                itemToRename.setName(request.newNames[i]);
                ++i;
                IWorkspaceConnection.ISaveOp op = workspaceConnection.configurationOpFactory().save(itemToRename);
                changeSetChooser.toCommit(request.component, (IVersionableHandle)itemToRename, (IWorkspaceConnection.IConfigurationOp)op, null, request.changeSetComment, (IProgressMonitor)iterProgress.newChild(1));
            }
        }
        IUpdateReport report = changeSetChooser.commit((IProgressMonitor)progress.newChild(50));
        this.checkCancelled((IProgressMonitor)progress);
        UpdateOperation op = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.moveDilemmaHandler, null);
        this.disableVerifyInSync(op);
        progress.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
        op.run((IProgressMonitor)progress.newChild(50));
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SharingManager sm = SharingManager.getInstance();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.moveRequests.size() + this.renameRequests.size()));
        for (MoveRequest moveRequest : this.moveRequests) {
            SubMonitor folderMon = monitor.newChild(1);
            folderMon.setWorkRemaining(moveRequest.versionablesToMove.length);
            int i = 0;
            while (i < moveRequest.toDestinationFolders.length) {
                SubMonitor sandboxMon = folderMon.newChild(1);
                sandboxMon.setWorkRemaining(affectedAreas.size() * 2);
                for (ISandbox sb : affectedAreas.keySet()) {
                    Shareable target;
                    IShareable source = sm.findShareable(sb.getRoot(), moveRequest.workspaceConnection.getContextHandle(), moveRequest.sourceComponent, moveRequest.versionablesToMove[i], (IProgressMonitor)sandboxMon.newChild(1));
                    if (source == null) continue;
                    refresher.addToRefresh(source);
                    IShareable parent = sm.findShareable(sb.getRoot(), moveRequest.workspaceConnection.getContextHandle(), moveRequest.targetComponent, (IVersionableHandle)moveRequest.toDestinationFolders[i], (IProgressMonitor)sandboxMon.newChild(1));
                    if (parent == null || (target = sm.findShareable(sb, parent.getLocalPath().append(source.getLocalPath().getName()), ResourceType.FOLDER)) == null) continue;
                    refresher.addToRefresh(target);
                }
                ++i;
            }
        }
        for (List list : this.renameRequests.values()) {
            SubMonitor reqGroupMon = monitor.newChild(1);
            reqGroupMon.setWorkRemaining(list.size());
            for (RenameRequest req : list) {
                SubMonitor folderMon = reqGroupMon.newChild(1);
                folderMon.setWorkRemaining(req.versionablesToRename.length);
                int i = 0;
                while (i < req.versionablesToRename.length) {
                    SubMonitor reqMon = folderMon.newChild(1);
                    reqMon.setWorkRemaining(affectedAreas.size());
                    for (ISandbox sb : affectedAreas.keySet()) {
                        IShareable source = sm.findShareable(sb.getRoot(), req.workspaceConnection.getContextHandle(), req.component, req.versionablesToRename[i], (IProgressMonitor)reqMon.newChild(1));
                        if (source == null) continue;
                        refresher.addToRefresh(source);
                        Shareable target = sm.findShareable(sb, source.getLocalPath().removeLastSegments(1).append(req.newNames[i]), ResourceType.FOLDER);
                        if (target == null) continue;
                        refresher.addToRefresh(target);
                    }
                    ++i;
                }
            }
        }
    }

    private class MoveRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle sourceComponent;
        final IVersionableHandle[] versionablesToMove;
        final IComponentHandle targetComponent;
        final IFolderHandle[] toDestinationFolders;
        final String sourceChangeSetComment;
        final String targetChangeSetComment;

        public MoveRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IVersionableHandle[] versionablesToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.sourceComponent = sourceComponent;
            this.versionablesToMove = versionablesToMove;
            this.targetComponent = targetComponent;
            this.toDestinationFolders = toDestinationFolders;
            this.sourceChangeSetComment = sourceChangeSetComment;
            this.targetChangeSetComment = targetChangeSetComment;
        }
    }

    private class RenameRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle component;
        final IVersionableHandle[] versionablesToRename;
        final String[] newNames;
        final String changeSetComment;

        public RenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle[] versionablesToRename, String[] newNames, String changeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.component = component;
            this.versionablesToRename = versionablesToRename;
            this.newNames = newNames;
            this.changeSetComment = changeSetComment;
        }
    }
}

