/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.share.MultipleSandboxShare;
import com.ibm.team.filesystem.client.internal.share.ReshareVersionables;
import com.ibm.team.filesystem.client.internal.share.ShareOverlap;
import com.ibm.team.filesystem.client.internal.share.ShareUploadHandler;
import com.ibm.team.filesystem.client.internal.share.ShareVersionables;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.common.FolderEntryConflictException;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ShareOperation
extends FileSystemOperation
implements IShareOperation {
    private ShareDilemmaHandler problemHandler;
    private HashMap<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> shareRequests = new HashMap();
    private HashMap<ConfigurationDescriptor, List<ReshareVersionables>> reshares;
    private HashMap<ConfigurationDescriptor, List<ShareVersionables>> shares;
    private boolean checkInChildrenAutomatically = true;
    private HashMap<UUID, IChangeSetHandle> changeSetsCommitted;
    private HashSet<IShareable> allShares;

    public ShareOperation(ShareDilemmaHandler problemHandler) {
        super(problemHandler);
        this.problemHandler = problemHandler == null ? ShareDilemmaHandler.getDefault() : problemHandler;
        this.changeSetsCommitted = new HashMap();
        this.allShares = new HashSet();
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        this.addShareRequest(workspace, changeSet, component, null, new String[0], shareRoots, overwrite, progress);
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, shareRoots, overwrite, progress);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void share(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        Object descriptor;
        void var7_17;
        ArrayList<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (componentName == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderRoot == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderRoot;
        int n = newFolderUnderRoot.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (shareRoots == null) {
            throw new IllegalArgumentException();
        }
        for (ILocation iLocation : shareRoots) {
            if (iLocation != null) continue;
            throw new IllegalArgumentException("Share root can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> hashMap = this.shareRequests.get(workspace);
        if (hashMap == null) {
            HashMap hashMap2 = new HashMap();
            this.shareRequests.put(workspace, hashMap2);
        }
        if ((requests = (ArrayList<ShareRequest>)var7_17.get(descriptor = null)) == null) {
            requests = new ArrayList<ShareRequest>();
            var7_17.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, componentName, newFolderUnderRoot, shareRoots, overwrite, progress));
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<? extends IRelativeLocation> relativeSharePaths, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException("Sandbox must be supplied");
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, sandbox, relativeSharePaths, null, overwrite, null, progress);
    }

    @Override
    public void share(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<? extends IRelativeLocation> relativeSharePaths, List<String> remoteNames, boolean overwrite, Map<String, byte[]> clientData, IProgressMonitor progress) throws TeamRepositoryException {
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException("Sandbox must be supplied");
        }
        this.addShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, sandbox, relativeSharePaths, remoteNames, overwrite, clientData, progress);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void share(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, ISandbox sandbox, List<? extends IRelativeLocation> relativeSharePaths, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        Object descriptor;
        void var8_18;
        ArrayList<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (componentName == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderRoot == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderRoot;
        int n = newFolderUnderRoot.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (relativeSharePaths == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException("Sandbox must be supplied");
        }
        for (IRelativeLocation iRelativeLocation : relativeSharePaths) {
            if (iRelativeLocation != null) continue;
            throw new IllegalArgumentException("Project can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> hashMap = this.shareRequests.get(workspace);
        if (hashMap == null) {
            HashMap hashMap2 = new HashMap();
            this.shareRequests.put(workspace, hashMap2);
        }
        if ((requests = (ArrayList<ShareRequest>)var8_18.get(descriptor = null)) == null) {
            requests = new ArrayList<ShareRequest>();
            var8_18.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, componentName, newFolderUnderRoot, sandbox, relativeSharePaths, overwrite, progress));
    }

    @Override
    public void reshareAs(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, IVersionableHandle remoteShare, ISandbox sandbox, IRelativeLocation relativeSharePath, IProgressMonitor progress) throws TeamRepositoryException {
        ConfigurationDescriptor descriptor;
        List<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (remoteShare == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        if (relativeSharePath == null || relativeSharePath.segmentCount() < 1) {
            throw new IllegalArgumentException("share root must be supplied");
        }
        HashMap<Object, List<ShareRequest>> requestsByConnection = this.shareRequests.get(workspace);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap();
            this.shareRequests.put(workspace, requestsByConnection);
        }
        if ((requests = requestsByConnection.get(descriptor = new ConfigurationDescriptor(workspace.teamRepository().getId(), workspace.teamRepository().getRepositoryURI(), workspace.getContextHandle(), component))) == null) {
            requests = new ArrayList<ShareRequest>();
            requestsByConnection.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, component, changeSet, remoteShare, sandbox, relativeSharePath, progress));
    }

    /*
     * WARNING - void declaration
     */
    private void addShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
        ConfigurationDescriptor descriptor;
        void var9_19;
        ArrayList<ShareRequest> requests;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderParent;
        int n = newFolderUnderParent.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (shareRoots == null) {
            throw new IllegalArgumentException();
        }
        for (ILocation iLocation : shareRoots) {
            if (iLocation != null) continue;
            throw new IllegalArgumentException("share root can not be null");
        }
        HashMap<ConfigurationDescriptor, List<ShareRequest>> hashMap = this.shareRequests.get(workspace);
        if (hashMap == null) {
            HashMap hashMap2 = new HashMap();
            this.shareRequests.put(workspace, hashMap2);
        }
        if ((requests = (ArrayList<ShareRequest>)var9_19.get(descriptor = new ConfigurationDescriptor(workspace.teamRepository().getId(), workspace.teamRepository().getRepositoryURI(), workspace.getContextHandle(), component))) == null) {
            requests = new ArrayList<ShareRequest>();
            var9_19.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, shareRoots, overwrite, progress));
    }

    /*
     * WARNING - void declaration
     */
    private void addShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<? extends IRelativeLocation> shareRoots, List<String> remoteNames, boolean overwrite, Map<String, byte[]> clientData, IProgressMonitor progress) throws TeamRepositoryException {
        ConfigurationDescriptor descriptor;
        void var12_24;
        ArrayList<ShareRequest> requests;
        HashMap<ConfigurationDescriptor, List<ShareRequest>> hashMap;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (newFolderUnderParent == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = newFolderUnderParent;
        int n = newFolderUnderParent.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (shareRoots == null) {
            throw new IllegalArgumentException();
        }
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        for (IRelativeLocation iRelativeLocation : shareRoots) {
            if (iRelativeLocation != null) continue;
            throw new IllegalArgumentException("share root can not be null");
        }
        if (remoteNames != null) {
            if (remoteNames.size() != shareRoots.size()) {
                throw new IllegalArgumentException("remote names size must match share root size");
            }
            for (String string : remoteNames) {
                if (string == null) {
                    throw new IllegalArgumentException("remote name can not be null");
                }
                if (string.indexOf(47) == -1) continue;
                throw new IllegalArgumentException("remote name most be a single path segment: " + string);
            }
        }
        if ((hashMap = this.shareRequests.get(workspace)) == null) {
            HashMap hashMap2 = new HashMap();
            this.shareRequests.put(workspace, hashMap2);
        }
        if ((requests = (ArrayList<ShareRequest>)var12_24.get(descriptor = new ConfigurationDescriptor(workspace.teamRepository().getId(), workspace.teamRepository().getRepositoryURI(), workspace.getContextHandle(), component))) == null) {
            requests = new ArrayList<ShareRequest>();
            var12_24.put(descriptor, requests);
        }
        requests.add(new ShareRequest(workspace, changeSet, component, parentFolder, newFolderUnderParent, sandbox, shareRoots, remoteNames, overwrite, clientData, progress));
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        monitor.setTaskName(Messages.ShareProjectsOperation_4);
        if (this.shareRequests.isEmpty()) {
            throw new IllegalStateException();
        }
        final HashSet<RepoIdConnectionComponentTriple> configurations = new HashSet<RepoIdConnectionComponentTriple>();
        ArrayList<IContextHandle> contexts = new ArrayList<IContextHandle>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)202);
        this.getAffectedConfigurations(configurations, contexts, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurations, contexts, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, (IProgressMonitor)progress.newChild(1));
        try {
            TeamRepositoryException[] repositoryException = new TeamRepositoryException[1];
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ShareOperation.this.doShare(configurations, monitor);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.ShareOperation_5, (IProgressMonitor)progress.newChild(100));
            if (repositoryException[0] != null) {
                throw repositoryException[0];
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.setWorkRemaining(this.shares.size() * 100);
        for (Map.Entry<ConfigurationDescriptor, List<ShareVersionables>> sharesEntry : this.shares.entrySet()) {
            List<ShareVersionables> pendingShareProjects = sharesEntry.getValue();
            SubMonitor iterProgress = progress.newChild(100);
            iterProgress.setWorkRemaining(pendingShareProjects.size() * 10);
            for (ShareVersionables shareProjects : pendingShareProjects) {
                shareProjects.commitNewProjectContents((IProgressMonitor)iterProgress.newChild(10));
                Collection<IChangeSetHandle> csCommitted = shareProjects.getCommittedChangeSets();
                for (IChangeSetHandle changeSet : csCommitted) {
                    this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doShare(Set<RepoIdConnectionComponentTriple> configurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ShareOperation_SHARE_PROGRESS_MESSAGE, (int)100);
        SubMonitor subProgress = reporter.newChild(5);
        subProgress.setWorkRemaining(this.shareRequests.size() * 100);
        SharingManager sharingManager = SharingManager.getInstance();
        HashMap<RepoIdConnectionComponentTriple, Set<ILocation>> cfasAffected = new HashMap<RepoIdConnectionComponentTriple, Set<ILocation>>();
        HashSet<ICopyFileAreaLockRequest> cfaLocksNeeded = new HashSet<ICopyFileAreaLockRequest>();
        for (Map.Entry<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> entryByConnection : this.shareRequests.entrySet()) {
            List<ShareRequest> sharesForNewComponents = entryByConnection.getValue().remove(null);
            if (sharesForNewComponents != null) {
                SubMonitor subMonitor = subProgress.newChild(50);
                subMonitor.setWorkRemaining(sharesForNewComponents.size());
                ArrayList<IFlowNodeConnection.IComponentAdditionOp> arrayList = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>(sharesForNewComponents.size());
                IWorkspaceConnection workspace = entryByConnection.getKey();
                IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)workspace.teamRepository());
                for (ShareRequest shareRequest : sharesForNewComponents) {
                    IContributorHandle iContributorHandle = RepositoryUtils.getLoggedInContributor(workspace.teamRepository());
                    shareRequest.component = (IComponentHandle)iWorkspaceManager.createComponent(shareRequest.componentName, (IAuditableHandle)iContributorHandle, (IProgressMonitor)subMonitor.newChild(1));
                    arrayList.add(workspace.componentOpFactory().addComponent(shareRequest.component, false));
                }
                workspace.applyComponentOperations(arrayList, (IProgressMonitor)subProgress.newChild(20));
                for (ShareRequest shareRequest : sharesForNewComponents) {
                    ArrayList<ShareRequest> arrayList2 = new ArrayList<ShareRequest>(1);
                    arrayList2.add(shareRequest);
                    ConfigurationDescriptor configuration = new ConfigurationDescriptor(workspace.teamRepository().getId(), workspace.teamRepository().getRepositoryURI(), workspace.getContextHandle(), shareRequest.component);
                    entryByConnection.getValue().put(configuration, arrayList2);
                    configurations.add(new RepoIdConnectionComponentTriple(workspace.teamRepository().getId(), workspace.getContextHandle(), shareRequest.component));
                }
            }
            subProgress.setWorkRemaining(10 * entryByConnection.getValue().size());
            for (List<ShareRequest> list : entryByConnection.getValue().values()) {
                SubMonitor iterProgress = subProgress.newChild(10).setWorkRemaining(list.size());
                for (ShareRequest shareRequest : list) {
                    cfaLocksNeeded.addAll(shareRequest.getCopyFileAreaLocksNeeded((IProgressMonitor)iterProgress.newChild(1)));
                    Map<RepoIdConnectionComponentTriple, Set<ILocation>> map = shareRequest.getCopyFileAreasOfInterest();
                    for (Map.Entry<RepoIdConnectionComponentTriple, Set<ILocation>> entry : map.entrySet()) {
                        RepoIdConnectionComponentTriple configuration = entry.getKey();
                        Set<ILocation> roots = entry.getValue();
                        HashSet<ILocation> otherRoots = (HashSet<ILocation>)cfasAffected.get(configuration);
                        if (otherRoots == null) {
                            otherRoots = new HashSet<ILocation>();
                            cfasAffected.put(configuration, otherRoots);
                        }
                        otherRoots.addAll(roots);
                    }
                }
            }
        }
        ICopyFileAreasLock cfaLock = ICopyFileAreaManager.instance.lock(cfaLocksNeeded, (IProgressMonitor)reporter.newChild(1));
        try {
            void var12_25;
            ConfigurationDescriptor descriptor;
            this.reshares = new HashMap();
            this.shares = new HashMap();
            HashMap<IShareable, ShareOverlap> overlaps = new HashMap<IShareable, ShareOverlap>();
            HashMap<ConfigurationDescriptor, MultipleSandboxShare> multipleSandboxesForConfiguration = new HashMap<ConfigurationDescriptor, MultipleSandboxShare>();
            HashSet<Object> hashSet = new HashSet<Object>();
            subProgress = reporter.newChild(5);
            subProgress.setWorkRemaining(this.shareRequests.size() * 10);
            for (Map.Entry entry : this.shareRequests.entrySet()) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)entry.getKey();
                HashMap<ISandbox, List<OverlapRequest>> hashMap = new HashMap<ISandbox, List<OverlapRequest>>();
                SubMonitor subMonitor = subProgress.newChild(8);
                subMonitor.setWorkRemaining(((HashMap)entry.getValue()).size() * 3);
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    descriptor = (ConfigurationDescriptor)entry2.getKey();
                    List requests = (List)entry2.getValue();
                    this.determineReshares((IConnection)iWorkspaceConnection, descriptor, requests, cfasAffected, (IProgressMonitor)subMonitor.newChild(1));
                    this.buildOverlapRequest(iWorkspaceConnection, descriptor, overlaps, hashMap, (IProgressMonitor)subMonitor.newChild(1));
                    RepoIdConnectionComponentTriple cfasAffectedKey = new RepoIdConnectionComponentTriple(descriptor.id, descriptor.connectionHandle, descriptor.componentHandle);
                    Set<ILocation> sandboxRoots = cfasAffected.get(cfasAffectedKey);
                    HashSet<ISandbox> sandboxes = new HashSet<ISandbox>();
                    if (sandboxRoots != null) {
                        for (ILocation sandboxRoot : sandboxRoots) {
                            ISandbox sandbox = sharingManager.getSandbox(sandboxRoot, false);
                            hashSet.add(sandbox);
                            sandboxes.add(sandbox);
                        }
                        if (sandboxRoots.size() > 1) {
                            boolean multipleSandboxesAllowed;
                            block46: {
                                multipleSandboxesAllowed = true;
                                for (ShareRequest request : requests) {
                                    if (request.allFileShares()) continue;
                                    multipleSandboxesAllowed = false;
                                    break;
                                }
                                if (multipleSandboxesAllowed) {
                                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)(3 * sandboxes.size()));
                                    List<ReshareVersionables> resharesForDtor = this.reshares.get(descriptor);
                                    for (ISandbox sandbox : sandboxes) {
                                        IShare[] iShareArray = sandbox.allShares((IProgressMonitor)progress.newChild(1));
                                        int n = iShareArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IShare share = iShareArray[n2];
                                            ISharingDescriptor sharingDtor = share.getSharingDescriptor();
                                            if (sharingDtor.getRepositoryId().equals((Object)descriptor.id) && sharingDtor.getComponent().getItemId().equals((Object)descriptor.componentHandle.getItemId()) && sharingDtor.isAssociatedWithConnection((IConnection)iWorkspaceConnection)) {
                                                if (share.getShareable().getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FILE) {
                                                    multipleSandboxesAllowed = false;
                                                    break block46;
                                                }
                                            } else {
                                                progress.worked(1);
                                            }
                                            if (resharesForDtor != null && multipleSandboxesAllowed) {
                                                SubMonitor progress2 = SubMonitor.convert((IProgressMonitor)progress, (int)resharesForDtor.size());
                                                for (ReshareVersionables reshare : resharesForDtor) {
                                                    if (sandbox.findShareable(iWorkspaceConnection.getContextHandle(), descriptor.getComponentHandle(), reshare.remoteShare, (IProgressMonitor)progress2.newChild(1)) == null) continue;
                                                    multipleSandboxesAllowed = false;
                                                    break block46;
                                                }
                                            } else {
                                                progress.worked(1);
                                            }
                                            ++n2;
                                        }
                                    }
                                } else {
                                    subMonitor.worked(1);
                                }
                            }
                            if (multipleSandboxesAllowed) continue;
                            MultipleSandboxShare multipleSandboxShare = (MultipleSandboxShare)multipleSandboxesForConfiguration.get(descriptor);
                            if (multipleSandboxShare == null) {
                                multipleSandboxShare = new MultipleSandboxShare(descriptor, sandboxes);
                                multipleSandboxesForConfiguration.put(descriptor, multipleSandboxShare);
                            }
                            for (ShareRequest request : requests) {
                                multipleSandboxShare.addShareables(request.getShareableRoots());
                            }
                            continue;
                        }
                        subMonitor.worked(1);
                        continue;
                    }
                    subMonitor.worked(1);
                }
                subMonitor.done();
                this.detectOverlaps(iWorkspaceConnection, hashMap, overlaps, (IProgressMonitor)subProgress.newChild(2));
            }
            for (ISandbox iSandbox : hashSet) {
                if (!sharingManager.hasSandboxListener(iSandbox)) continue;
                ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getCopyFileAreaForPath(iSandbox.getRoot());
                iCopyFileArea.markSandboxListenerEvent(new Date());
            }
            subProgress.done();
            if (!multipleSandboxesForConfiguration.isEmpty()) {
                int n = this.problemHandler.multipleSandboxesForConfigurations(multipleSandboxesForConfiguration.values());
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                if (n != 0) {
                    throw new FileSystemException(Messages.ShareOperation_6);
                }
            }
            if (!overlaps.isEmpty()) {
                int n = this.problemHandler.overlappingShareRequests(overlaps.values());
                if (n == 1) {
                    throw new OperationCanceledException();
                }
                if (n != 0) {
                    throw new FileSystemException(Messages.ShareProjectsOperation_0);
                }
                this.updateSharesToDo(overlaps);
            }
            boolean bl = false;
            int reshareSize = 0;
            for (List<ShareVersionables> list : this.shares.values()) {
                for (ShareVersionables shareVersionables : list) {
                    var12_25 += shareVersionables.getShareableCount();
                }
            }
            for (List<ReshareVersionables> list : this.reshares.values()) {
                reshareSize += list.size();
            }
            reporter.setWorkRemaining(reshareSize * 10 + var12_25 * 5 + 1);
            HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> hashMap = new HashMap<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>>();
            ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
            for (Map.Entry<ConfigurationDescriptor, List<ShareVersionables>> entry : this.shares.entrySet()) {
                List<ShareVersionables> pendingShareProjects = entry.getValue();
                descriptor = entry.getKey();
                for (ShareVersionables shareProjects : pendingShareProjects) {
                    Map<String, IFolder> foldersCreated = this.getNewFoldersCreatedUnderParent(descriptor, shareProjects, hashMap);
                    try {
                        arrayList.addAll(shareProjects.share(foldersCreated, (IProgressMonitor)reporter.newChild(shareProjects.getShareableCount() * 5)));
                    }
                    catch (FolderEntryConflictException e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                RepositoryUtils.throwAppropriateException(Messages.ShareVersionables_0, arrayList.toArray(new IStatus[arrayList.size()]));
            }
            for (List<ReshareVersionables> list : this.reshares.values()) {
                for (ReshareVersionables reshareProject : list) {
                    reshareProject.reShare((IProgressMonitor)reporter.newChild(10));
                }
            }
        }
        finally {
            cfaLock.release((IProgressMonitor)reporter.newChild(1));
        }
    }

    private void buildOverlapRequest(IWorkspaceConnection connection, ConfigurationDescriptor descriptor, HashMap<IShareable, ShareOverlap> overlaps, Map<ISandbox, List<OverlapRequest>> overlapRequestsBySandbox, IProgressMonitor progress) throws FileSystemException {
        List<ShareVersionables> toShare = this.shares.get(descriptor);
        List<ReshareVersionables> toReshare = this.reshares.get(descriptor);
        int count = 0;
        if (toShare != null) {
            count += toShare.size();
        }
        if (toReshare != null) {
            count += toReshare.size();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)count);
        if (toShare != null) {
            for (ShareVersionables shareRequest : toShare) {
                shareRequest.determineOverlaps(overlaps, (IProgressMonitor)monitor.newChild(1));
                HashSet<ISandbox> sandboxesSeen = new HashSet<ISandbox>();
                for (IShareable shareable : shareRequest.getShareables()) {
                    if (!sandboxesSeen.add(shareable.getSandbox())) continue;
                    this.addOverlapRequest(descriptor, overlapRequestsBySandbox, shareable, (IVersionableHandle)shareRequest.parentFolder);
                }
            }
        }
        if (toReshare != null) {
            for (ReshareVersionables request : this.reshares.get(descriptor)) {
                request.determineOverlaps(overlaps, (IProgressMonitor)monitor.newChild(1));
                this.addOverlapRequest(descriptor, overlapRequestsBySandbox, request.shareableRoot, request.remoteShare);
            }
        }
    }

    private void addOverlapRequest(ConfigurationDescriptor descriptor, Map<ISandbox, List<OverlapRequest>> overlapRequestsBySandbox, IShareable shareable, IVersionableHandle remote) {
        List<OverlapRequest> overlapRequests = overlapRequestsBySandbox.get(shareable.getSandbox());
        if (overlapRequests == null) {
            overlapRequests = new ArrayList<OverlapRequest>();
            overlapRequestsBySandbox.put(shareable.getSandbox(), overlapRequests);
        }
        OverlapRequest overlapRequest = null;
        for (OverlapRequest request : overlapRequests) {
            if (!request.getContext().sameItemId((IItemHandle)descriptor.connectionHandle) || !request.getComponent().sameItemId((IItemHandle)descriptor.componentHandle)) continue;
            overlapRequest = request;
            break;
        }
        if (overlapRequest == null) {
            overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
            overlapRequest.setContext(descriptor.connectionHandle);
            overlapRequest.setComponent(descriptor.componentHandle);
            overlapRequests.add(overlapRequest);
        }
        List toVerfiyForOverlap = overlapRequest.getGroup();
        toVerfiyForOverlap.add(remote);
    }

    private void detectOverlaps(IWorkspaceConnection connection, Map<ISandbox, List<OverlapRequest>> overlapRequests, HashMap<IShareable, ShareOverlap> overlaps, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<OverlapRequest> requests = new ArrayList<OverlapRequest>();
        for (List<OverlapRequest> overlapRequestForSandbox : overlapRequests.values()) {
            for (OverlapRequest overlapRequest : overlapRequestForSandbox) {
                if (overlapRequest.getGroup().size() <= 1) continue;
                requests.add(overlapRequest);
            }
        }
        if (!requests.isEmpty()) {
            FileSystemManager fsm = (FileSystemManager)FileSystemCore.getFileSystemManager(connection.teamRepository());
            FileSystemServiceProxy fss = fsm.getFileSystemService();
            List<OverlapResponse> overlapResults = fss.detectOverlap(requests, null, (IProgressMonitor)monitor.newChild(95));
            this.recordOverlaps(connection, overlapResults, overlaps, (IProgressMonitor)monitor.newChild(5));
        }
    }

    private Map<String, IFolder> getNewFoldersCreatedUnderParent(ConfigurationDescriptor descriptor, ShareVersionables shareProjects, Map<ConfigurationDescriptor, Map<UUID, Map<String, IFolder>>> newFolders) {
        Map<String, IFolder> foldersCreated;
        if (shareProjects.newFolderUnderParent.length > 0) {
            Map<UUID, Map<String, IFolder>> newFoldersUnderParents = newFolders.get(descriptor);
            if (newFoldersUnderParents == null) {
                newFoldersUnderParents = new HashMap<UUID, Map<String, IFolder>>();
                newFolders.put(descriptor, newFoldersUnderParents);
            }
            if ((foldersCreated = newFoldersUnderParents.get(shareProjects.parentFolder.getItemId())) == null) {
                foldersCreated = new HashMap<String, IFolder>();
                newFoldersUnderParents.put(shareProjects.parentFolder.getItemId(), foldersCreated);
            }
        } else {
            foldersCreated = Collections.EMPTY_MAP;
        }
        return foldersCreated;
    }

    private void updateSharesToDo(HashMap<IShareable, ShareOverlap> overlaps) {
        for (ShareOverlap shareOverlap : overlaps.values()) {
            List<ShareVersionables> pendingShares;
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareOverlap.getConnection().teamRepository().getId(), shareOverlap.getConnection().teamRepository().getRepositoryURI(), shareOverlap.getConnection().getContextHandle(), shareOverlap.getComponent());
            IShareable project = shareOverlap.getShareRoot();
            List<ReshareVersionables> pendingReshares = this.reshares.get(descriptor);
            if (pendingReshares != null) {
                Iterator<ReshareVersionables> i = pendingReshares.iterator();
                while (i.hasNext()) {
                    ReshareVersionables reshareProject = i.next();
                    if (!reshareProject.shareableRoot.equals(project)) continue;
                    i.remove();
                }
            }
            if ((pendingShares = this.shares.get(descriptor)) == null) continue;
            for (ShareVersionables shareProjects : pendingShares) {
                shareProjects.removeProject(project);
            }
        }
    }

    private void recordOverlaps(IWorkspaceConnection connection, List<OverlapResponse> overlapResults, HashMap<IShareable, ShareOverlap> overlaps, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)overlapResults.size());
        for (OverlapResponse response : overlapResults) {
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection.teamRepository().getId(), connection.teamRepository().getRepositoryURI(), connection.getContextHandle(), response.getComponent());
            SubMonitor subMonitor = monitor.newChild(1);
            subMonitor.setWorkRemaining(response.getOverlapDescriptions().size());
            for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                ReshareVersionables reshareRequest = this.getReshareRequest(descriptor, overlapDescription.getElement());
                if (reshareRequest == null) continue;
                Shareable project = reshareRequest.shareableRoot;
                ShareOverlap overlap = overlaps.get(project);
                if (overlap == null) {
                    overlap = new ShareOverlap((IConnection)connection, response.getComponent(), project);
                    overlaps.put(project, overlap);
                }
                SubMonitor subSubMonitor = subMonitor.newChild(1);
                subSubMonitor.setWorkRemaining(overlapDescription.getOverlappedChildren().size());
                for (IVersionableHandle versionableOverlapped : overlapDescription.getOverlappedChildren()) {
                    ReshareVersionables otherReshareRequest = this.getReshareRequest(descriptor, versionableOverlapped);
                    if (otherReshareRequest != null) {
                        overlap.addShareRootOverlap(otherReshareRequest.shareableRoot);
                        ShareOverlap overlap2 = overlaps.get(otherReshareRequest.shareableRoot);
                        if (overlap2 == null) {
                            overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), otherReshareRequest.shareableRoot);
                            overlaps.put(otherReshareRequest.shareableRoot, overlap2);
                        }
                        overlap2.addShareRootOverlap(project);
                    }
                    Collection<ShareVersionables> sharesForParent = this.getSharesForParent(descriptor, versionableOverlapped);
                    for (ShareVersionables shareProjects : sharesForParent) {
                        for (IShareable p2 : shareProjects.getShareables()) {
                            overlap.addShareRootOverlap(p2);
                            ShareOverlap overlap2 = overlaps.get(p2);
                            if (overlap2 == null) {
                                overlap2 = new ShareOverlap((IConnection)connection, response.getComponent(), p2);
                                overlaps.put(p2, overlap2);
                            }
                            overlap2.addShareRootOverlap(project);
                        }
                    }
                    IShareable shareable = reshareRequest.shareableRoot.getSandbox().findShareable(descriptor.connectionHandle, descriptor.componentHandle, versionableOverlapped, (IProgressMonitor)subSubMonitor.newChild(1));
                    if (shareable == null) continue;
                    subSubMonitor.setWorkRemaining(1);
                    IShare share = shareable.getShare((IProgressMonitor)subSubMonitor.newChild(1));
                    if (share == null) continue;
                    overlap.addShareOverlap(share);
                }
            }
        }
    }

    private Collection<ShareVersionables> getSharesForParent(ConfigurationDescriptor descriptor, IVersionableHandle versionableOverlapped) {
        ArrayList<ShareVersionables> result = new ArrayList<ShareVersionables>();
        List<ShareVersionables> currentShares = this.shares.get(descriptor);
        if (currentShares != null) {
            for (ShareVersionables shareProjects : currentShares) {
                if (!shareProjects.parentFolder.sameItemId((IItemHandle)versionableOverlapped)) continue;
                result.add(shareProjects);
            }
        }
        return result;
    }

    private ReshareVersionables getReshareRequest(ConfigurationDescriptor descriptor, IVersionableHandle versionable) {
        List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
        if (currentReshares != null) {
            for (ReshareVersionables reshareProject : currentReshares) {
                if (!reshareProject.remoteShare.sameItemId((IItemHandle)versionable)) continue;
                return reshareProject;
            }
        }
        return null;
    }

    private void determineReshares(IConnection connection, ConfigurationDescriptor descriptor, List<ShareRequest> requests, HashMap<RepoIdConnectionComponentTriple, Set<ILocation>> cfasAffected, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IComponent fullComponent = (IComponent)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)descriptor.componentHandle, 0, (IProgressMonitor)monitor.newChild(2));
        ArrayList<IFolderHandle> foldersToRetrieve = new ArrayList<IFolderHandle>(requests.size());
        for (ShareRequest request : requests) {
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            foldersToRetrieve.add(parentFolderForShare);
        }
        IConfiguration configuration = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(descriptor.componentHandle) : ((IBaselineConnection)connection).configuration();
        List folderChildren = configuration.childEntries(foldersToRetrieve, (IProgressMonitor)monitor);
        int i = 0;
        while (i < requests.size()) {
            Map children = (Map)folderChildren.get(i);
            if (children == null) {
                throw new FileSystemException(Messages.ShareProjectsOperation_1);
            }
            ShareRequest request = requests.get(i);
            if (request.isKnownReshare()) {
                List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
                if (currentReshares == null) {
                    currentReshares = new ArrayList<ReshareVersionables>();
                    this.reshares.put(descriptor, currentReshares);
                }
                IVersionable remote = configuration.fetchCompleteItem(request.remoteShare, (IProgressMonitor)monitor.newChild(1));
                currentReshares.add(new ReshareVersionables(connection, fullComponent, remote.getParent(), request.remoteShare, remote.getName(), (Shareable)request.getShareableRoots().get(0), request.properties, request.getClientData(), request.overwrite));
                break;
            }
            IFolderHandle parentFolderForShare = request.parentFolder;
            if (parentFolderForShare == null) {
                parentFolderForShare = fullComponent.getRootFolder();
            }
            if (request.newFolderUnderParent.length > 0 && children.get(request.newFolderUnderParent[0]) != null) {
                throw new FileSystemException(NLS.bind((String)Messages.ShareProjectsOperation_2, (Object)PathUtils.getString(request.newFolderUnderParent), (Object[])new Object[0]));
            }
            ShareVersionables shareProjects = new ShareVersionables(request.workspace, request.changeSet, fullComponent, parentFolderForShare, request.newFolderUnderParent, request.overwrite, request.properties, request.getClientData(), this.checkInChildrenAutomatically, cfasAffected, this.problemHandler);
            for (IShareable shareable : request.getShareableRoots()) {
                String remoteName = request.getRemoteName(shareable);
                if (request.newFolderUnderParent.length > 0) {
                    shareProjects.addShareable(shareable, remoteName);
                    continue;
                }
                IVersionableHandle child = (IVersionableHandle)children.get(remoteName);
                if (child == null) {
                    shareProjects.addShareable(shareable, remoteName);
                    continue;
                }
                if (ResourceType.getResourceType(child) == shareable.getResourceType((IProgressMonitor)monitor.newChild(1))) {
                    List<ReshareVersionables> currentReshares = this.reshares.get(descriptor);
                    if (currentReshares == null) {
                        currentReshares = new ArrayList<ReshareVersionables>();
                        this.reshares.put(descriptor, currentReshares);
                    }
                    currentReshares.add(new ReshareVersionables(connection, fullComponent, parentFolderForShare, child, remoteName, (Shareable)shareable, request.properties, request.getClientData(), request.overwrite));
                    continue;
                }
                throw new FileSystemException(NLS.bind((String)Messages.ShareProjectsOperation_3, (Object)shareable.getLocalPath(), (Object[])new Object[0]));
            }
            if (shareProjects.getShareableCount() != 0) {
                List<ShareVersionables> currentShares = this.shares.get(descriptor);
                if (currentShares == null) {
                    currentShares = new ArrayList<ShareVersionables>();
                    this.shares.put(descriptor, currentShares);
                }
                currentShares.add(shareProjects);
            }
            ++i;
        }
    }

    private Set<RepoIdConnectionComponentTriple> getAffectedConfigurations(Set<RepoIdConnectionComponentTriple> configurations, Collection<IContextHandle> contexts, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.shareRequests.size());
        for (Map.Entry<IWorkspaceConnection, HashMap<ConfigurationDescriptor, List<ShareRequest>>> sharesByConnection : this.shareRequests.entrySet()) {
            IWorkspaceConnection workspace = sharesByConnection.getKey();
            HashMap<ConfigurationDescriptor, List<ShareRequest>> shares = sharesByConnection.getValue();
            SubMonitor iterProgress = progress.newChild(1).setWorkRemaining(shares.size());
            for (Map.Entry<ConfigurationDescriptor, List<ShareRequest>> requestsByConfiguration : shares.entrySet()) {
                List<ShareRequest> requests = requestsByConfiguration.getValue();
                for (ShareRequest request : requests) {
                    configurations.addAll(request.getConfigurationAffected((IProgressMonitor)iterProgress.newChild(1)));
                }
                if (requestsByConfiguration.getKey() != null) continue;
                contexts.add(workspace.getContextHandle());
            }
        }
        return configurations;
    }

    @Override
    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    @Override
    public void assignProperties(ILocation location, Map<String, String> properties, IProgressMonitor monitor) {
        ShareRequest request = this.getShareRequest(location);
        if (request == null) {
            throw new IllegalArgumentException(NLS.bind((String)"The location {0} is not part of a subtree that is being shared", (Object)location.toOSString(), (Object[])new Object[0]));
        }
        request.assignProperties(location, properties, monitor);
    }

    @Override
    public void assignFileProperties(ILocation location, FileLineDelimiter lineDelimiter, String contentType, IProgressMonitor monitor) {
        ShareRequest request = this.getShareRequest(location);
        if (request == null) {
            throw new IllegalArgumentException(NLS.bind((String)"The location {0} is not part of a subtree that is being shared", (Object)location.toOSString(), (Object[])new Object[0]));
        }
        request.assignFileProperties(location, lineDelimiter, contentType);
    }

    private ShareRequest getShareRequest(ILocation location) {
        for (HashMap<ConfigurationDescriptor, List<ShareRequest>> requestsByComponent : this.shareRequests.values()) {
            for (List<ShareRequest> requests : requestsByComponent.values()) {
                for (ShareRequest shareRequest : requests) {
                    if (!shareRequest.contains(location)) continue;
                    return shareRequest;
                }
            }
        }
        return null;
    }

    @Override
    public void checkInNewShareChildren(boolean checkInChildrenAutomatically) {
        this.checkInChildrenAutomatically = checkInChildrenAutomatically;
    }

    static class ShareProperties {
        private String contentType;
        private FileLineDelimiter lineDelimiter;
        private Map<String, String> properties;

        public ShareProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public ShareProperties(FileLineDelimiter lineDelimiter, String contentType) {
            this.lineDelimiter = lineDelimiter;
            this.contentType = contentType;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public void setFileProperties(FileLineDelimiter lineDelimiter, String contentType) {
            this.lineDelimiter = lineDelimiter;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public FileLineDelimiter getLineDelimiter() {
            return this.lineDelimiter;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void update(IVersionable versionable) {
            Map<String, String> userProperties = this.getProperties();
            if (userProperties != null) {
                for (Map.Entry<String, String> entry : userProperties.entrySet()) {
                    versionable.setUserProperty(entry.getKey(), entry.getValue());
                }
            }
        }

        public void update(IShareable shareable, ShareUploadHandler uh) {
            uh.setLineDelimiter(this.lineDelimiter);
            uh.setContentType(this.contentType);
            uh.setProperties(this.properties);
        }
    }

    private class ShareRequest {
        private final IWorkspaceConnection workspace;
        private final IChangeSetHandle changeSet;
        private IComponentHandle component;
        private String componentName;
        private IFolderHandle parentFolder;
        private String[] newFolderUnderParent;
        private final boolean overwrite;
        private final List<IShareable> shareableRoots = new ArrayList<IShareable>();
        private final IVersionableHandle remoteShare;
        private final Map<ILocation, ShareProperties> properties = new HashMap<ILocation, ShareProperties>();
        private final Map<String, byte[]> clientData;
        private Map<IShareable, String> remoteNames;
        private HashMap<RepoIdConnectionComponentTriple, Set<ILocation>> cfaConfigurationOfInterest;
        private boolean allFiles = true;

        public ShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, ISandbox sandbox, List<? extends IRelativeLocation> shareRoots, List<String> remoteNames, boolean overwrite, Map<String, byte[]> clientData, IProgressMonitor progress) throws TeamRepositoryException {
            if (workspace == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_0);
            }
            if (component == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_1);
            }
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.parentFolder = parentFolder;
            this.newFolderUnderParent = newFolderUnderParent;
            this.overwrite = overwrite;
            this.remoteShare = null;
            this.clientData = clientData;
            this.init(sandbox, shareRoots, remoteNames, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, ISandbox sandbox, List<? extends IRelativeLocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
            this.workspace = workspace;
            this.changeSet = null;
            this.componentName = componentName;
            this.parentFolder = null;
            this.newFolderUnderParent = newFolderUnderRoot;
            this.overwrite = overwrite;
            this.remoteShare = null;
            this.clientData = null;
            this.init(sandbox, shareRoots, null, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, IVersionableHandle remoteShare, ISandbox sandbox, IRelativeLocation relativeSharePath, IProgressMonitor progress) throws TeamRepositoryException {
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.overwrite = false;
            this.remoteShare = remoteShare;
            this.clientData = null;
            this.init(sandbox, Collections.singletonList(relativeSharePath), null, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponentHandle component, IFolderHandle parentFolder, String[] newFolderUnderParent, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
            if (workspace == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_0);
            }
            if (component == null) {
                throw new IllegalArgumentException(Messages.ShareOperation_1);
            }
            this.workspace = workspace;
            this.changeSet = changeSet;
            this.component = component;
            this.parentFolder = parentFolder;
            this.newFolderUnderParent = newFolderUnderParent;
            this.overwrite = overwrite;
            this.remoteShare = null;
            this.clientData = null;
            this.init(shareRoots, progress);
        }

        public ShareRequest(IWorkspaceConnection workspace, String componentName, String[] newFolderUnderRoot, List<? extends ILocation> shareRoots, boolean overwrite, IProgressMonitor progress) throws TeamRepositoryException {
            this.workspace = workspace;
            this.changeSet = null;
            this.componentName = componentName;
            this.parentFolder = null;
            this.newFolderUnderParent = newFolderUnderRoot;
            this.overwrite = overwrite;
            this.remoteShare = null;
            this.clientData = null;
            this.init(shareRoots, progress);
        }

        private void init(List<? extends ILocation> roots, IProgressMonitor progress) throws TeamRepositoryException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
            SharingManager sharingManager = SharingManager.getInstance();
            for (ILocation iLocation : roots) {
                ILocation realLocation;
                if (iLocation.getStorageId().equals("com.ibm.team.filesystem.hfs")) {
                    String realPathString = PathUtils.getRealPath(iLocation.toOSString());
                    if (realPathString == null) {
                        throw new FileSystemException(NLS.bind((String)Messages.ShareOperation_7, (Object)iLocation.toOSString(), (Object[])new Object[0]));
                    }
                    Path realPath = new Path(realPathString);
                    realLocation = new PathLocation((IPath)realPath);
                } else {
                    realLocation = iLocation;
                }
                ResourceType type = this.getType(realLocation, (IProgressMonitor)monitor.newChild(1));
                IShareable shareable = sharingManager.findShareable(realLocation, type);
                if (shareable == null) {
                    ILocation cfaPath = realLocation.getParent();
                    boolean found = false;
                    while (!found && !cfaPath.isEmpty()) {
                        if (cfaMgr.copyFileAreaExists(cfaPath, 1)) {
                            found = true;
                            continue;
                        }
                        cfaPath = cfaPath.getParent();
                    }
                    if (!found) {
                        cfaPath = realLocation.getParent();
                    }
                    IRelativeLocation relativeLocation = realLocation.getLocationRelativeTo(cfaPath);
                    shareable = sharingManager.findShareable(sharingManager.getSandbox(cfaPath, false), relativeLocation, type);
                }
                this.getShareableRoots().add(shareable);
                if (type == ResourceType.FILE) continue;
                this.allFiles = false;
            }
            for (IShareable iShareable : this.getShareableRoots()) {
                if (ShareOperation.this.allShares.add(iShareable)) continue;
                throw new IllegalArgumentException("Share root specified in more than 1 request: " + iShareable.getFullPath().toString());
            }
        }

        private void init(ISandbox sandbox, List<? extends IRelativeLocation> roots, List<String> remoteNames, IProgressMonitor progress) throws TeamRepositoryException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            SharingManager sharingManager = SharingManager.getInstance();
            boolean isHierarchical = sandbox.getRoot().getStorageId().equals("com.ibm.team.filesystem.hfs");
            int i = 0;
            while (i < roots.size()) {
                ILocation realLocation;
                IRelativeLocation path = roots.get(i);
                if (isHierarchical) {
                    String realPathString = PathUtils.getRealPath(sandbox.getRoot().append(path).toOSString());
                    if (realPathString == null) {
                        throw new FileSystemException(NLS.bind((String)Messages.ShareOperation_8, (Object)sandbox.getRoot().append(path).toOSString(), (Object[])new Object[0]));
                    }
                    Path realPath = new Path(realPathString);
                    realLocation = new PathLocation((IPath)realPath);
                } else {
                    realLocation = sandbox.getRoot().append(path);
                }
                ResourceType type = this.getType(realLocation, (IProgressMonitor)monitor.newChild(1));
                if (realLocation.isPrefixOf(sandbox.getRoot(), sandbox.isCaseSensitive())) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_4, (Object)realLocation.toOSString(), (Object[])new Object[]{sandbox.toString()}));
                }
                path = realLocation.getLocationRelativeTo(sandbox.getRoot());
                Shareable shareable = sharingManager.findShareable(sandbox, path, type);
                this.getShareableRoots().add(shareable);
                if (type != ResourceType.FILE) {
                    this.allFiles = false;
                }
                if (remoteNames != null) {
                    String remoteName = remoteNames.get(i);
                    if (this.remoteNames == null) {
                        this.remoteNames = new HashMap<IShareable, String>();
                    }
                    this.remoteNames.put(shareable, remoteName);
                }
                ++i;
            }
            for (IShareable shareable : this.getShareableRoots()) {
                if (ShareOperation.this.allShares.add(shareable)) continue;
                throw new IllegalArgumentException("Share root specified in more than 1 request: " + shareable.getFullPath().toString());
            }
        }

        private boolean allFileShares() {
            return this.allFiles;
        }

        private ResourceType getType(ILocation location, IProgressMonitor monitor) throws FileSystemException {
            IPath realPath;
            if (SharingManager.getInstance().hasEFSSupport(location) && (realPath = (IPath)location.getAdapter(IPath.class)) != null) {
                IFileInfo fileInfo;
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(realPath);
                try {
                    fileInfo = fileStore.fetchInfo(0, monitor);
                }
                catch (CoreException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.ShareOperation_10, (Object)realPath.toOSString(), (Object[])new Object[0]), e);
                }
                ResourceType type = null;
                if (fileInfo.getAttribute(32)) {
                    type = ResourceType.SYMBOLIC_LINK;
                } else if (fileInfo.isDirectory()) {
                    type = ResourceType.FOLDER;
                } else if (fileInfo.exists()) {
                    type = ResourceType.FILE;
                }
                if (type == null) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.ShareOperation_3, (Object)realPath.toOSString(), (Object[])new Object[0]));
                }
                return type;
            }
            return ResourceType.FOLDER;
        }

        Collection<RepoIdConnectionComponentTriple> getConfigurationAffected(IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getShareableRoots().size());
            if (!this.overwrite) {
                if (this.component == null) {
                    return Collections.EMPTY_LIST;
                }
                RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(this.workspace.teamRepository().getId(), this.workspace.getContextHandle(), this.component);
                return Collections.singletonList(configuration);
            }
            ArrayList<RepoIdConnectionComponentTriple> configurations = new ArrayList<RepoIdConnectionComponentTriple>(2);
            if (this.component != null) {
                RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(this.workspace.teamRepository().getId(), this.workspace.getContextHandle(), this.component);
                configurations.add(configuration);
            }
            for (IShareable shareable : this.getShareableRoots()) {
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share == null) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurations.add(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent()));
            }
            return configurations;
        }

        Map<RepoIdConnectionComponentTriple, Set<ILocation>> getCopyFileAreasOfInterest() {
            return this.cfaConfigurationOfInterest;
        }

        Collection<ICopyFileAreaLockRequest> getCopyFileAreaLocksNeeded(IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.getShareableRoots().size() + 100));
            ICopyFileAreaManager.ICopyFileAreaLockRequestFactory cfaLockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
            HashSet<ICopyFileAreaLockRequest> locksNeeded = new HashSet<ICopyFileAreaLockRequest>();
            this.cfaConfigurationOfInterest = new HashMap();
            for (IShareable shareable : this.getShareableRoots()) {
                RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(this.workspace.teamRepository().getId(), this.workspace.getContextHandle(), this.component);
                this.addCopyFileAreaOfInterest(configuration, shareable.getSandbox().getRoot());
                locksNeeded.add(cfaLockFactory.getLockRequest(shareable.getSandbox().getRoot(), Collections.singleton(configuration), false));
                if (!this.overwrite) continue;
                FileSystemCore.getSharingManager().register(shareable.getSandbox(), false, (IProgressMonitor)progress.newChild(1));
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share == null) continue;
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                RepoIdConnectionComponentTriple config = new RepoIdConnectionComponentTriple(sharingDescriptor.getRepositoryId(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
                locksNeeded.add(cfaLockFactory.getLockRequest(shareable.getSandbox().getRoot(), Collections.singleton(config), false));
            }
            Collection<RepoIdConnectionComponentTriple> configurationAffected = this.getConfigurationAffected((IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(configurationAffected.size());
            for (RepoIdConnectionComponentTriple configuration : configurationAffected) {
                Collection<ICopyFileArea> affectedCopyFileAreas = ICopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)progress.newChild(1));
                for (ICopyFileArea cfa : affectedCopyFileAreas) {
                    this.addCopyFileAreaOfInterest(configuration, cfa.getRoot());
                    locksNeeded.add(cfaLockFactory.getLockRequest(cfa.getRoot(), Collections.singleton(configuration), false));
                }
            }
            return locksNeeded;
        }

        private void addCopyFileAreaOfInterest(RepoIdConnectionComponentTriple configuration, ILocation root) {
            Set<ILocation> cfaRoots = this.cfaConfigurationOfInterest.get(configuration);
            if (cfaRoots == null) {
                cfaRoots = new HashSet<ILocation>();
                this.cfaConfigurationOfInterest.put(configuration, cfaRoots);
            }
            cfaRoots.add(root);
        }

        boolean isKnownReshare() {
            return this.remoteShare != null;
        }

        public void assignProperties(ILocation location, Map<String, String> properties, IProgressMonitor monitor) {
            ShareProperties sp = this.properties.get(location);
            if (sp == null) {
                this.properties.put(location, new ShareProperties(properties));
            } else {
                sp.setProperties(properties);
            }
        }

        public void assignFileProperties(ILocation location, FileLineDelimiter lineDelimiter, String contentType) {
            ShareProperties sp = this.properties.get(location);
            if (sp == null) {
                this.properties.put(location, new ShareProperties(lineDelimiter, contentType));
            } else {
                sp.setFileProperties(lineDelimiter, contentType);
            }
        }

        public boolean contains(ILocation location) {
            for (IShareable shareable : this.getShareableRoots()) {
                if (!shareable.getFullPath().isPrefixOf(location)) continue;
                return true;
            }
            return false;
        }

        public Map<String, byte[]> getClientData() {
            return this.clientData;
        }

        private List<IShareable> getShareableRoots() {
            return this.shareableRoots;
        }

        public String getRemoteName(IShareable shareable) {
            if (this.remoteNames != null) {
                return this.remoteNames.get(shareable);
            }
            return shareable.getLocalPath().getName();
        }
    }
}

