/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.ILinkDetectorContextProvider;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.internal.text.HTML2TextReader;
import com.ibm.team.foundation.common.text.HTMLHandler;
import com.ibm.team.foundation.common.text.PlainTextHandler;
import com.ibm.team.foundation.common.text.XMLString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class LinkDetector {
    private Set<TextLinkDetector> fContributions = new HashSet<TextLinkDetector>();
    private Set<ILinkDetectorListener> fListeners = new HashSet<ILinkDetectorListener>();
    private ILinkDetectorListener fListener = new ILinkDetectorListener(){

        @Override
        public void linkDetectorChanged() {
            LinkDetector.this.notifyListeners();
        }
    };

    public void addTextLinkDetector(TextLinkDetector detector) {
        detector.initialize();
        detector.setListener(this.fListener);
        this.fContributions.add(detector);
    }

    public void removeTextLinkDetector(TextLinkDetector detector) {
        detector.cleanup();
        this.fContributions.remove(detector);
    }

    public List<TextLinkDetector> getTextLinkDetectors() {
        return new ArrayList<TextLinkDetector>(this.fContributions);
    }

    public void setBaseURI(final URI baseURI) {
        for (final TextLinkDetector contribution : this.fContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.setBaseURI(baseURI);
                }
            });
        }
    }

    public void setContext(final ILinkDetectorContextProvider context) {
        for (final TextLinkDetector contribution : this.fContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.setContext(context);
                }
            });
        }
    }

    public void dispose() {
        for (final TextLinkDetector contribution : this.fContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    contribution.cleanup();
                }
            });
        }
        this.fContributions.clear();
    }

    public List<DetectedTextLink> match(String text, boolean verify) {
        return this.match(text);
    }

    public List<DetectedTextLink> match(final String text) {
        final ArrayList<DetectedTextLink> results = new ArrayList<DetectedTextLink>();
        if (text.length() == 0) {
            return results;
        }
        final ArrayList failedDetectors = new ArrayList();
        for (final TextLinkDetector contribution : this.fContributions) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    failedDetectors.add(contribution);
                }

                public void run() throws Exception {
                    Pattern pattern = contribution.getPattern();
                    if (pattern == null) {
                        return;
                    }
                    Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        DetectedTextLink result = contribution.createDetectedLink(matcher);
                        if (result == null) continue;
                        results.add(result);
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        this.fContributions.removeAll(failedDetectors);
        this.removeOverlapping(results);
        return results;
    }

    public List<DetectedTextLink> match(XMLString text) {
        PlainTextHandler handler = new PlainTextHandler();
        String xmlText = text.getXMLText();
        InternalHTMLReader textReader = new InternalHTMLReader(new StringReader(xmlText), handler);
        textReader.parse();
        String plainText = handler.getText();
        List<DetectedTextLink> detectedLinks = this.match(plainText);
        ArrayList<DetectedTextLink> correctedLinks = new ArrayList<DetectedTextLink>(detectedLinks.size());
        for (DetectedTextLink t : detectedLinks) {
            int start = t.getOffset();
            int end = start + t.getLength();
            int actualStart = textReader.convertStartIndex(start);
            int actualEnd = textReader.convertEndIndex(end);
            if (actualEnd <= actualStart || actualStart < 0 || actualStart >= xmlText.length() || actualEnd > xmlText.length()) continue;
            t.internalSetInStructuredLink(textReader.isInStructuredLink(start, end));
            t.internalSetOffSet(actualStart);
            t.internalSetLength(actualEnd - actualStart);
            correctedLinks.add(t);
        }
        return correctedLinks;
    }

    public void addListener(ILinkDetectorListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ILinkDetectorListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyListeners() {
        for (ILinkDetectorListener listener : this.fListeners) {
            listener.linkDetectorChanged();
        }
    }

    private void removeOverlapping(List<DetectedTextLink> candidates) {
        HashSet<DetectedTextLink> losers = new HashSet<DetectedTextLink>();
        for (DetectedTextLink candidate : candidates) {
            if (losers.contains(candidate)) continue;
            for (DetectedTextLink link : candidates) {
                if (losers.contains(link) || link == candidate || candidate.getOffset() + candidate.getLength() <= link.getOffset() || link.getOffset() + link.getLength() <= candidate.getOffset()) continue;
                if (candidate.getLength() < link.getLength()) {
                    losers.add(candidate);
                    continue;
                }
                if (link.getLength() < candidate.getLength()) {
                    losers.add(link);
                    continue;
                }
                if (candidate.getOffset() > link.getOffset()) {
                    losers.add(candidate);
                    continue;
                }
                losers.add(link);
            }
        }
        candidates.removeAll(losers);
    }

    public static interface ILinkDetectorListener {
        public void linkDetectorChanged();
    }

    private static class InternalHTMLReader
    extends HTML2TextReader {
        private int fTotalOffset = 0;
        private int fHyperLinkStartIndex = 0;
        List<Integer> indices = new ArrayList<Integer>();
        Map<Integer, Integer> fIgnore = new HashMap<Integer, Integer>();

        private InternalHTMLReader(Reader reader, HTMLHandler handler) {
            super(reader, handler);
        }

        @Override
        protected void parse() {
            super.parse();
        }

        @Override
        protected String computeSubstitution(int c) throws IOException {
            int start = this.fCurrentIndex;
            String substitution = super.computeSubstitution(c);
            int end = this.fCurrentIndex;
            if (end <= start) {
                this.indices.add(this.fTotalOffset);
            } else {
                int currentOffset = end - start + 1 - substitution.length();
                this.fTotalOffset += currentOffset;
                int i = 0;
                while (i < substitution.length()) {
                    this.indices.add(this.fTotalOffset);
                    ++i;
                }
            }
            return substitution;
        }

        private int convertStartIndex(int index) {
            if (index < this.indices.size()) {
                int offset = this.indices.get(index);
                return index + offset;
            }
            return index;
        }

        private int convertEndIndex(int index) {
            if (index < this.indices.size()) {
                int offset = this.indices.get(index - 1);
                return index + offset;
            }
            return index;
        }

        private boolean isInStructuredLink(int start, int end) {
            for (int i : this.fIgnore.keySet()) {
                int endIgnoreIndex = this.fIgnore.get(i);
                if (start < i || end > endIgnoreIndex) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void hyperlinkStarted(String reference) {
            super.hyperlinkStarted(reference);
            this.fHyperLinkStartIndex = this.indices.size();
        }

        @Override
        protected void hyperlinkEnded() {
            super.hyperlinkEnded();
            this.fIgnore.put(this.fHyperLinkStartIndex, this.indices.size());
        }
    }
}

