/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LinkCollection
extends AbstractCollection<ILink>
implements ILinkCollection {
    private HashMap<String, List<ILink>> nameToLinkMap;
    private Collection<ILink> list;

    public LinkCollection() {
        this.list = this.removeUnknownLinks(new ArrayList<ILink>());
    }

    public LinkCollection(ILink[] array) {
        this.list = this.removeUnknownLinks(Arrays.asList(array));
    }

    public LinkCollection(Collection<ILink> c) {
        this.list = this.removeUnknownLinks(c == null ? new ArrayList() : c);
    }

    public LinkCollection(ILink[] array, boolean includeUnregistered) {
        this.list = !includeUnregistered ? this.removeUnknownLinks(Arrays.asList(array)) : Arrays.asList(array);
    }

    @Override
    public Collection getLinksById(String linkTypeId) {
        this.initMap();
        Collection links = null;
        if (this.nameToLinkMap != null) {
            links = this.nameToLinkMap.get(linkTypeId);
        }
        return links == null ? new ArrayList(0) : links;
    }

    @Override
    public Collection getLinkTypeIds() {
        this.initMap();
        return this.nameToLinkMap.keySet();
    }

    private void initMap() {
        if (this.nameToLinkMap == null) {
            this.nameToLinkMap = new HashMap();
            for (ILink link : this.list) {
                this.addLinkToMap(link);
            }
        }
    }

    private void addLinkToMap(ILink link) {
        String linkTypeId = link.getLinkTypeId();
        List<ILink> links = this.nameToLinkMap.get(linkTypeId);
        if (links == null) {
            links = new ArrayList<ILink>();
            this.nameToLinkMap.put(linkTypeId, links);
        }
        links.add(link);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean addAll(Collection s) {
        return this.list.addAll(s);
    }

    public Collection getLinksByName(String linkTypeId) {
        return this.getLinksById(linkTypeId);
    }

    public Collection getLinkTypeNames() {
        return this.getLinkTypeIds();
    }

    private Collection<ILink> removeUnknownLinks(Collection<ILink> allLinks) {
        ArrayList<ILink> knownLinks = new ArrayList<ILink>();
        if (allLinks == null) {
            return knownLinks;
        }
        for (ILink link : allLinks) {
            if (!ILinkTypeRegistry.INSTANCE.isRegistered(link.getLinkTypeId())) continue;
            knownLinks.add(link);
        }
        return knownLinks;
    }
}

