/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.internal.nls.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;

public class HashUtil {
    private static final Log LOG = LogFactory.getLog(HashUtil.class.getName());
    private static final String NLS_FAILED_TO_GENERATE_HASH_VALUE = "HashUtil.FailedToGenerateHashValue";

    public static String getStacktraceHash(Throwable exp) {
        StringWriter writer = new StringWriter(500);
        exp.printStackTrace(new PrintWriter(writer));
        String stacktrace = writer.toString();
        return HashUtil.getHashValue(stacktrace);
    }

    public static String getHashValue(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hashBytes = digest.digest(message.getBytes("UTF-8"));
            StringBuilder hashString = new StringBuilder(hashBytes.length * 2);
            byte[] byArray = hashBytes;
            int n = hashBytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                hashString.append(String.format("%02X", element));
                ++n2;
            }
            return hashString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)Messages.getServerString(NLS_FAILED_TO_GENERATE_HASH_VALUE), (Throwable)e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)Messages.getServerString(NLS_FAILED_TO_GENERATE_HASH_VALUE), (Throwable)e);
            return null;
        }
    }

    public static final int getStackTraceHashCode(Throwable t) {
        int i = 0;
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            i ^= e.hashCode() ^ e.getLineNumber();
            ++n2;
        }
        return i;
    }
}

