/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.Version;
import com.ibm.team.repository.common.internal.util.GeneralizedAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.NewAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.NewTypeDescriptor;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class EvolutionDescriptor
extends AbstractElementDescriptor {
    private static final String DTO_EVOLUTION_ELEMENT_NAME = "dtoEvolution";
    private static final String NEW_ATTRIBUTE_ELEMENT = "addedAttribute";
    private static final String NEW_TYPE_ELEMENT = "addedType";
    private static final String GENERALIZED_ATTRIBUTE_ELEMENT = "generalizedAttribute";
    private static final String COMPONENT_VERSION_ATTRIBUTE = "componentVersion";
    private static final String MODEL_VERSION_ATTRIBUTE = "modelVersion";
    private static final String NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE = "nonClientCompatibilityBreakingChange";
    private Map<String, Map<String, NewAttributeDescriptor>> newAttributes;
    private Map<String, NewTypeDescriptor> newTypes;
    private Map<String, Map<String, GeneralizedAttributeDescriptor>> generalizedAttributeDescriptors;
    private String modelVersionString;
    private Version modelVersion;
    private String componentVersionString;
    private Version componentVersion;
    private Boolean isDtoEvolution;
    private boolean isNonClientCompatibilityBreakingChange;

    EvolutionDescriptor(IConfigurationElement element) {
        super(element, element.getName());
    }

    public NewAttributeDescriptor getNewAttribute(String className, String attribName) {
        if (this.getNewAttributes().get(className) == null) {
            return null;
        }
        return this.getNewAttributes().get(className).get(attribName);
    }

    public NewTypeDescriptor getNewType(String className) {
        return this.getNewTypes().get(className);
    }

    public String getComponentVersion() {
        return this.componentVersionString;
    }

    public Version getComponentVersionVersion() {
        return this.componentVersion;
    }

    public String getModelVersion() {
        return this.modelVersionString;
    }

    public Version getModelVersionVersion() {
        return this.modelVersion;
    }

    public GeneralizedAttributeDescriptor getGeneralizedAttribute(String className, String attribName) {
        Map<String, GeneralizedAttributeDescriptor> classList = this.getGeneralizedAttributeDescriptors().get(className);
        if (classList == null) {
            return null;
        }
        return classList.get(attribName);
    }

    public boolean isNonClientCompatibilityBreakingChange() {
        return this.isNonClientCompatibilityBreakingChange;
    }

    @Override
    protected void processChild(IConfigurationElement child) {
        String name = child.getName();
        if (NEW_ATTRIBUTE_ELEMENT.equalsIgnoreCase(name)) {
            this.processNewAttributeElement(child);
        } else if (NEW_TYPE_ELEMENT.equalsIgnoreCase(name)) {
            this.processNewTypeElement(child);
        } else if (GENERALIZED_ATTRIBUTE_ELEMENT.equalsIgnoreCase(name)) {
            this.processGeneralizedAttributeElement(child);
        } else {
            super.processChild(child);
        }
    }

    @Override
    protected void checkElement() {
        super.checkElement();
        this.checkComponentVersionAttribute();
        this.checkModelVersionAttribute();
        this.checkNonClientCompatibilityBreakingChangeAttribute();
    }

    private void processNewAttributeElement(IConfigurationElement child) {
        Map<Object, Object> attribMap;
        NewAttributeDescriptor newAttrib = new NewAttributeDescriptor(child);
        if (this.getNewAttributes().containsKey(newAttrib.getClassName())) {
            attribMap = this.getNewAttributes().get(newAttrib.getClassName());
        } else {
            attribMap = new HashMap(5);
            this.getNewAttributes().put(newAttrib.getClassName(), attribMap);
        }
        attribMap.put(newAttrib.getName(), newAttrib);
    }

    private void processNewTypeElement(IConfigurationElement child) {
        NewTypeDescriptor newType = new NewTypeDescriptor(child);
        this.getNewTypes().put(newType.getName(), newType);
    }

    private void processGeneralizedAttributeElement(IConfigurationElement child) {
        GeneralizedAttributeDescriptor generalizedAttribute = new GeneralizedAttributeDescriptor(child);
        String typeName = generalizedAttribute.getTypeName();
        Map<String, GeneralizedAttributeDescriptor> classMap = this.getGeneralizedAttributeDescriptors().get(typeName);
        if (classMap == null) {
            classMap = new HashMap<String, GeneralizedAttributeDescriptor>(5);
            this.getGeneralizedAttributeDescriptors().put(typeName, classMap);
        }
        String attribName = generalizedAttribute.getAttributeName();
        classMap.put(attribName, generalizedAttribute);
    }

    private Map<String, Map<String, NewAttributeDescriptor>> getNewAttributes() {
        if (this.newAttributes == null) {
            this.newAttributes = new HashMap<String, Map<String, NewAttributeDescriptor>>(5);
        }
        return this.newAttributes;
    }

    private Map<String, NewTypeDescriptor> getNewTypes() {
        if (this.newTypes == null) {
            this.newTypes = new HashMap<String, NewTypeDescriptor>(5);
        }
        return this.newTypes;
    }

    public Map<String, Map<String, GeneralizedAttributeDescriptor>> getGeneralizedAttributeDescriptors() {
        if (this.generalizedAttributeDescriptors == null) {
            this.generalizedAttributeDescriptors = new HashMap<String, Map<String, GeneralizedAttributeDescriptor>>(5);
        }
        return this.generalizedAttributeDescriptors;
    }

    private void checkComponentVersionAttribute() {
        this.checkAttributeIsSet(this.getComponentVersion(), COMPONENT_VERSION_ATTRIBUTE);
    }

    private void checkModelVersionAttribute() {
        if (this.isDtoEvolution()) {
            return;
        }
        this.checkAttributeIsSet(this.getModelVersion(), MODEL_VERSION_ATTRIBUTE);
    }

    private void checkNonClientCompatibilityBreakingChangeAttribute() {
        String attrib = Boolean.toString(this.isNonClientCompatibilityBreakingChange());
        this.checkAttributeIsLegal(attrib, NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE, false, Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    protected boolean isDtoEvolution() {
        return this.isDtoEvolution;
    }

    @Override
    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printOn(buffer, MODEL_VERSION_ATTRIBUTE, this.getModelVersion());
        this.printOn(buffer, COMPONENT_VERSION_ATTRIBUTE, this.getComponentVersion());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.componentVersionString = this.getAttribute(COMPONENT_VERSION_ATTRIBUTE);
        this.modelVersionString = this.getAttribute(MODEL_VERSION_ATTRIBUTE);
        this.isDtoEvolution = DTO_EVOLUTION_ELEMENT_NAME.equals(this.getElement().getName());
        this.modelVersion = Version.getVersion(this.getModelVersion());
        this.componentVersion = Version.getVersion(this.getComponentVersion());
        this.isNonClientCompatibilityBreakingChange = Boolean.parseBoolean(this.getAttribute(NON_CLIENT_COMPATIBILITY_BREAKING_CHANGE_ATTRIBUTE, "false"));
    }
}

