/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.util.LocationUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.StringTokenizer;

public class OAuthUtil {
    public static String removeCallbackURLFromRequest(String authorizeURL) throws URISyntaxException, UnsupportedEncodingException {
        String queryString = new URI(authorizeURL).getRawQuery();
        StringTokenizer queryTokenizer = new StringTokenizer(queryString, "&");
        String base = OAuthUtil.extractBase(authorizeURL);
        String oauthToken = null;
        String callbackURL = null;
        while (queryTokenizer.hasMoreTokens()) {
            StringTokenizer parmTokenizer = new StringTokenizer(queryTokenizer.nextToken(), "=");
            if (parmTokenizer.countTokens() == 0) continue;
            String name = parmTokenizer.nextToken();
            if (name.toLowerCase(Locale.ROOT).equals("oauth_callback")) {
                callbackURL = LocationUtil.decode(parmTokenizer.nextToken());
                continue;
            }
            if (!name.toLowerCase(Locale.ROOT).equals("oauth_token")) continue;
            oauthToken = LocationUtil.decode(parmTokenizer.nextToken());
        }
        String requestTokenSecret = OAuthUtil.extractRequestTokenSecret(callbackURL);
        String newURL = String.format("%s?%s=%s&%s", base, "oauth_token", oauthToken, requestTokenSecret);
        return newURL;
    }

    public static String extractBase(String redirectBase) {
        int ndx = redirectBase.indexOf(63);
        if (ndx == -1) {
            throw new IllegalArgumentException(String.format("URI \"%s\" is missing expected query parameters", redirectBase));
        }
        redirectBase = redirectBase.substring(0, ndx);
        return redirectBase;
    }

    private static String extractRequestTokenSecret(String callbackURL) throws URISyntaxException {
        String queryString = new URI(callbackURL).getRawQuery();
        return queryString;
    }
}

