/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.HashCode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class HashComputingInputStream
extends FilterInputStream {
    private final Checksum hashCode = HashCode.newChecksum();
    private long contentSize = 0L;

    @Override
    public int read() throws IOException {
        int byteVal = super.read();
        if (byteVal != -1) {
            this.hashCode.update(byteVal);
            ++this.contentSize;
        }
        return byteVal;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.hashCode.update(b, off, result);
            this.contentSize += (long)result;
        }
        return result;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.hashCode.reset();
        this.contentSize = 0L;
    }

    public HashComputingInputStream(InputStream underStream) {
        super(underStream);
    }

    public long getHash() {
        return this.hashCode.getValue();
    }

    public Checksum getChecksum() {
        return this.hashCode;
    }

    public long getContentSize() {
        return this.contentSize;
    }
}

