/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.impl.PrimitiveTypeMarshallerImpl;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.PrimitiveDataArg;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import com.ibm.team.repository.common.utils.DateUtils;
import java.sql.Timestamp;
import java.util.Date;

public class TimestampMarshaller
extends PrimitiveTypeMarshallerImpl {
    public TimestampMarshaller() {
        this.setSupportedType(Timestamp.class);
        this.setMarshallerType(MarshallerType.TIMESTAMP_LITERAL);
    }

    @Override
    public DataArgType getSupportedDataArgType() {
        return DataArgType.TIMESTAMP_LITERAL;
    }

    @Override
    public Object demarshalDataArgToObject(DataArg dataArg, Class classZ) {
        String stringValue = ((PrimitiveDataArg)dataArg).getValue();
        if (stringValue == null) {
            return null;
        }
        return this.demarshalObjectFromString(stringValue);
    }

    @Override
    public Object demarshalObjectFromString(String value) {
        Object o = RepositoryFactory.eINSTANCE.createFromString(RepositoryPackage.eINSTANCE.getTimestamp(), value);
        return o;
    }

    @Override
    public DataArg marshalObjectToDataArg(Object object) {
        PrimitiveDataArg primitiveDataArg = ServicesFactory.eINSTANCE.createPrimitiveDataArg();
        primitiveDataArg.setType(this.getSupportedDataArgType());
        if (object == null) {
            primitiveDataArg.setValue(null);
        } else {
            primitiveDataArg.setValue(this.convertTimestampToString((Timestamp)object));
        }
        return primitiveDataArg;
    }

    @Override
    public String marshalObjectToString(Object object) {
        return this.convertTimestampToString((Timestamp)object);
    }

    private String convertTimestampToString(Timestamp timestamp) {
        return DateUtils.formatTimeRFC3339((Date)timestamp);
    }
}

