/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common;

import com.ibm.team.build.common.model.IBuildAction;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.common.model.IBuildActivityId;
import com.ibm.team.build.common.model.IBuildAverageData;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestParams;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultPruningPolicy;
import com.ibm.team.build.common.model.IBuildSchedule;
import com.ibm.team.build.common.model.IBuildScheduleEntry;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompileOutputFile;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.common.model.IContributionProperty;
import com.ibm.team.build.common.model.IExpectedContribution;
import com.ibm.team.build.common.model.IJUnitTestCase;
import com.ibm.team.build.common.model.IJUnitTestClass;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.BuildAction;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildEngine;
import com.ibm.team.build.internal.common.model.BuildFactory;
import com.ibm.team.build.internal.common.model.BuildPackage;
import com.ibm.team.build.internal.common.model.BuildRequest;
import com.ibm.team.build.internal.common.model.BuildResult;
import com.ibm.team.build.internal.common.model.BuildResultContribution;
import com.ibm.team.build.internal.common.model.BuildResultPruningPolicy;
import com.ibm.team.build.internal.common.model.BuildSchedule;
import com.ibm.team.build.internal.common.model.CompileContribution;
import com.ibm.team.build.internal.common.model.CompilePackage;
import com.ibm.team.build.internal.common.model.ConfigurationProperty;
import com.ibm.team.build.internal.common.model.JUnitTestClass;
import com.ibm.team.build.internal.common.model.JUnitTestSuiteContribution;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;

public class BuildItemFactory {
    private BuildItemFactory() {
    }

    public static void initializeBuildPackage() {
        BuildPackage.eINSTANCE.eContents();
        new BuildItemFactory();
    }

    public static IBuildResult createBuildResult() {
        return (IBuildResult)BuildResult.ITEM_TYPE.createItem();
    }

    public static IBuildResult createBuildResult(IBuildDefinition buildDefinition) {
        IBuildResult buildResult = (IBuildResult)BuildResult.ITEM_TYPE.createItem();
        buildResult.setBuildDefinition(buildDefinition);
        buildResult.setContextId(buildDefinition.getContextId());
        return buildResult;
    }

    public static IBuildDefinition createBuildDefinition() {
        BuildResultPruningPolicy policy = BuildFactory.eINSTANCE.createBuildResultPruningPolicy();
        BuildSchedule schedule = BuildFactory.eINSTANCE.createBuildSchedule();
        BuildDefinition buildDefinition = (BuildDefinition)BuildDefinition.ITEM_TYPE.createItem();
        buildDefinition.setBuildResultPruningPolicy(policy);
        buildDefinition.setBuildSchedule(schedule);
        return buildDefinition;
    }

    public static IBuildDefinition createBuildDefinition(IProcessArea processArea) {
        ValidationHelper.validateNotNull("processArea", processArea);
        BuildResultPruningPolicy policy = BuildFactory.eINSTANCE.createBuildResultPruningPolicy();
        BuildSchedule schedule = BuildFactory.eINSTANCE.createBuildSchedule();
        BuildDefinition buildDefinition = (BuildDefinition)BuildDefinition.ITEM_TYPE.createItem();
        buildDefinition.setProcessArea((IProcessAreaHandle)processArea);
        buildDefinition.setContextId(processArea.getContextId());
        buildDefinition.setBuildResultPruningPolicy(policy);
        buildDefinition.setBuildSchedule(schedule);
        return buildDefinition;
    }

    public static IBuildEngine createBuildEngine() {
        return (IBuildEngine)BuildEngine.ITEM_TYPE.createItem();
    }

    public static IBuildEngine createBuildEngine(IProcessArea processArea) {
        ValidationHelper.validateNotNull("processArea", processArea);
        IBuildEngine buildEngine = (IBuildEngine)BuildEngine.ITEM_TYPE.createItem();
        buildEngine.setProcessArea((IProcessAreaHandle)processArea);
        buildEngine.setContextId(processArea.getContextId());
        return buildEngine;
    }

    public static ICompileContribution createCompileContribution() {
        return (ICompileContribution)CompileContribution.ITEM_TYPE.createItem();
    }

    public static ICompilePackage createCompilePackage() {
        return (ICompilePackage)CompilePackage.ITEM_TYPE.createItem();
    }

    public static ICompileSource createCompileSource() {
        return BuildFactory.eINSTANCE.createCompileSource();
    }

    public static ICompileProblem createCompileProblem() {
        return BuildFactory.eINSTANCE.createCompileProblem();
    }

    public static ICompileOutputFile createCompileOutputFile() {
        return BuildFactory.eINSTANCE.createCompileOutputFile();
    }

    public static IJUnitTestSuiteContribution createJUnitTestSuiteContribution() {
        return (IJUnitTestSuiteContribution)JUnitTestSuiteContribution.ITEM_TYPE.createItem();
    }

    public static IJUnitTestClass createJUnitTestClass() {
        return (IJUnitTestClass)JUnitTestClass.ITEM_TYPE.createItem();
    }

    public static IBuildResultContribution createBuildResultContribution() {
        BuildResultContribution contribution = BuildFactory.eINSTANCE.createBuildResultContribution();
        return contribution;
    }

    public static IBuildActivity createBuildActivity() {
        return BuildFactory.eINSTANCE.createBuildActivity();
    }

    public static IBuildActivityId createBuildActivityId() {
        return BuildFactory.eINSTANCE.createBuildActivityId();
    }

    public static IJUnitTestCase createJUnitTestCase() {
        return BuildFactory.eINSTANCE.createJUnitTestCase();
    }

    public static IContributionProperty createContributionProperty() {
        return BuildFactory.eINSTANCE.createContributionProperty();
    }

    public static IBuildProperty createBuildProperty() {
        return BuildFactory.eINSTANCE.createBuildProperty();
    }

    public static IBuildProperty createBuildProperty(String name, String value) {
        IBuildProperty property = BuildItemFactory.createBuildProperty();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    public static IConfigurationProperty createConfigurationProperty() {
        return BuildFactory.eINSTANCE.createConfigurationProperty();
    }

    public static IConfigurationProperty createConfigurationProperty(String name, String value) {
        ConfigurationProperty property = BuildFactory.eINSTANCE.createConfigurationProperty();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    public static IExpectedContribution createExpectedContribution() {
        return BuildFactory.eINSTANCE.createExpectedContribution();
    }

    public static IBuildRequest createBuildRequest() {
        IBuildRequest buildRequest = (IBuildRequest)BuildRequest.ITEM_TYPE.createItem();
        buildRequest.setProcessed(false);
        return buildRequest;
    }

    public static IBuildRequestParams createBuildRequestParams() {
        return BuildFactory.eINSTANCE.createBuildRequestParams();
    }

    public static IBuildAction createBuildAction(String action) throws IllegalArgumentException {
        ValidationHelper.validateNotNull("action", action);
        ValidationHelper.validateNotEmpty("action", action.trim());
        BuildAction buildAction = BuildFactory.eINSTANCE.createBuildAction();
        buildAction.setAction(action);
        return buildAction;
    }

    public static IBuildDefinitionInstance createBuildDefinitionInstance() {
        return BuildFactory.eINSTANCE.createBuildDefinitionInstance();
    }

    public static IBuildSchedule createBuildSchedule() {
        return BuildFactory.eINSTANCE.createBuildSchedule();
    }

    public static IBuildScheduleEntry createBuildScheduleEntry() {
        return BuildFactory.eINSTANCE.createBuildScheduleEntry();
    }

    public static IBuildResultPruningPolicy createBuildResultPruningPolicy() {
        return BuildFactory.eINSTANCE.createBuildResultPruningPolicy();
    }

    public static IBuildAverageData createBuildAverageData() {
        return (IBuildAverageData)IBuildAverageData.ITEM_TYPE.createItem();
    }

    public static IBuildConfigurationElement createBuildConfigurationElement() {
        return BuildFactory.eINSTANCE.createBuildConfigurationElement();
    }

    public static IBuildFolder createBuildFolder() {
        return (IBuildFolder)IBuildFolder.ITEM_TYPE.createItem();
    }

    public static IBuildFolder createBuildFolder(IBuildFolderHandle parentFolderHandle, String name, IProcessAreaHandle processAreaHandle) {
        IBuildFolder buildFolder = (IBuildFolder)IBuildFolder.ITEM_TYPE.createItem();
        buildFolder.setName(name);
        buildFolder.setParent(parentFolderHandle);
        buildFolder.setProcessArea(processAreaHandle);
        return buildFolder;
    }
}

