/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common;

import java.util.ArrayList;
import java.util.List;

public class MicrosoftBuildItem {
    public static final String BUILD_STR = "Build";
    public static final String REBUILD_STR = "ReBuild";
    private static final String EOT = "-E_o_T-";
    private static final String EMPTY_TOKEN = "-e_M_p_T_y_T_o_K_e_N-";
    public static final String END_OF_BUILD_ITEM = "-E_o_B_i-";
    private String fBuildFileName;
    private String fBuildConfig;
    private String fBuildType;
    private String fAdditionalArguments;
    private String fBuildLogFile;
    private String fWorkingDir;

    public MicrosoftBuildItem(String buildFileName, String buildConfig, String buildType, String additionalArgs, String logFile, String workingDir) {
        this.fBuildFileName = MicrosoftBuildItem.getActualValue(buildFileName);
        this.fBuildConfig = MicrosoftBuildItem.getActualValue(buildConfig);
        this.fBuildType = buildType;
        this.fAdditionalArguments = MicrosoftBuildItem.getActualValue(additionalArgs);
        this.fBuildLogFile = MicrosoftBuildItem.getActualValue(logFile);
        this.fWorkingDir = MicrosoftBuildItem.getActualValue(workingDir);
    }

    public String getBuildFileName() {
        return this.fBuildFileName;
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public String getBuildType() {
        return this.fBuildType;
    }

    public String getAdditionalArguments() {
        return this.fAdditionalArguments;
    }

    public String getBuildLogFile() {
        return this.fBuildLogFile;
    }

    public String getWorkingDir() {
        return this.fWorkingDir;
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MicrosoftBuildItem.getNormalizedValue(this.fBuildFileName));
        sb.append(EOT);
        sb.append(MicrosoftBuildItem.getNormalizedValue(this.fBuildConfig));
        sb.append(EOT);
        sb.append(this.fBuildType);
        sb.append(EOT);
        sb.append(MicrosoftBuildItem.getNormalizedValue(this.fAdditionalArguments));
        sb.append(EOT);
        sb.append(MicrosoftBuildItem.getNormalizedValue(this.fBuildLogFile));
        sb.append(EOT);
        sb.append(MicrosoftBuildItem.getNormalizedValue(this.fWorkingDir));
        return sb.toString();
    }

    public static String getString(List<MicrosoftBuildItem> buildItems) {
        StringBuilder bldStr = new StringBuilder();
        if (buildItems != null) {
            for (MicrosoftBuildItem buildItem : buildItems) {
                bldStr.append(buildItem.getString());
                bldStr.append(END_OF_BUILD_ITEM);
            }
        }
        return bldStr.toString();
    }

    public static MicrosoftBuildItem getItem(String tokenizedStr) {
        String[] tokens;
        if (tokenizedStr != null && (tokens = tokenizedStr.split(EOT)) != null && tokens.length == 6) {
            String buildFileName = MicrosoftBuildItem.getActualValue(tokens[0]);
            String buildConfig = MicrosoftBuildItem.getActualValue(tokens[1]);
            String buildType = MicrosoftBuildItem.getActualValue(tokens[2]);
            String additionalArgs = MicrosoftBuildItem.getActualValue(tokens[3]);
            String logFile = MicrosoftBuildItem.getActualValue(tokens[4]);
            String workingDir = MicrosoftBuildItem.getActualValue(tokens[5]);
            return new MicrosoftBuildItem(buildFileName, buildConfig, buildType, additionalArgs, logFile, workingDir);
        }
        return null;
    }

    public static List<MicrosoftBuildItem> getItems(String tokenizedStr) {
        String[] tokens;
        ArrayList<MicrosoftBuildItem> buildItems = new ArrayList<MicrosoftBuildItem>();
        if (tokenizedStr != null && (tokens = tokenizedStr.split(END_OF_BUILD_ITEM)) != null) {
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                MicrosoftBuildItem bldItem;
                String bldStr = stringArray[n2];
                if (bldStr != null && bldStr.trim().length() >= 1 && (bldItem = MicrosoftBuildItem.getItem(bldStr.trim())) != null) {
                    buildItems.add(bldItem);
                }
                ++n2;
            }
        }
        return buildItems;
    }

    private static String getNormalizedValue(String value) {
        if (value == null || value.trim().length() == 0) {
            return EMPTY_TOKEN;
        }
        return value.trim();
    }

    private static String getActualValue(String value) {
        if (value == null || value.trim().length() == 0 || EMPTY_TOKEN.equals(value)) {
            return "";
        }
        return value.trim();
    }

    public void setBuildFileName(String buildFileName) {
        this.fBuildFileName = buildFileName;
    }

    public void setBuildConfig(String buildConfig) {
        this.fBuildConfig = buildConfig;
    }

    public void setBuildType(String buildType) {
        this.fBuildType = buildType;
    }

    public void setAdditionalArguments(String additionalArguments) {
        this.fAdditionalArguments = additionalArguments;
    }

    public void setBuildLogFile(String buildLogFile) {
        this.fBuildLogFile = buildLogFile;
    }

    public void setWorkingDir(String workingDir) {
        this.fWorkingDir = workingDir;
    }

    public boolean isValidDevEnvBuildType() {
        return BUILD_STR.equalsIgnoreCase(this.fBuildType) || REBUILD_STR.equals(this.fBuildType);
    }

    public boolean isValidBuildConfig() {
        return MicrosoftBuildItem.getActualValue(this.fBuildConfig).length() >= 1;
    }
}

