/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.l10n.Messages;
import java.util.Arrays;
import org.eclipse.osgi.util.NLS;

public class ValidationHelper {
    static {
        new ValidationHelper();
    }

    private ValidationHelper() {
    }

    public static void validateNotNull(String parameterName, Object parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
    }

    public static void validateNotNull(String parameterName, Object[] parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        int i = 0;
        while (i < parameterValue.length) {
            if (parameterValue[i] == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.1"), (Object)parameterName, (Object)new Integer(i)));
            }
            ++i;
        }
    }

    public static void validateNotNullElements(String parameterName, Object[] parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValue != null) {
            int i = 0;
            while (i < parameterValue.length) {
                if (parameterValue[i] == null) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.1"), (Object)parameterName, (Object)new Integer(i)));
                }
                ++i;
            }
        }
    }

    public static void validateNotEmpty(String parameterName, String parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        if (parameterValue.length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.2"), (Object)parameterName, (Object)parameterValue));
        }
    }

    public static void validateNotEmpty(String parameterName, Object[] parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        if (parameterValue.length == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.2"), (Object)parameterName, (Object)parameterValue));
        }
    }

    public static void validateIsType(String parameterName, Class requiredType, Object parameterValue) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (requiredType == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"requiredType"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        if (!requiredType.isInstance(parameterValue)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.3"), (Object[])new Object[]{parameterName, parameterValue.getClass().getName(), requiredType.getName()}));
        }
    }

    public static void validateIsOneOfTypes(String parameterName, Object parameterValue, Class[] validTypes) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (validTypes == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"validTypes"));
        }
        if (validTypes.length == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.2"), (Object)"validTypes"));
        }
        if (parameterValue == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        int i = 0;
        while (i < validTypes.length) {
            if (validTypes[i].isInstance(parameterValue)) break;
            if (i == validTypes.length - 1) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.7"), (Object[])new Object[]{parameterName, parameterValue.getClass().getName(), Arrays.toString(validTypes)}));
            }
            ++i;
        }
    }

    public static void validateElementsAreOneOfTypes(String parameterName, Object[] parameterValues, Class[] validTypes) throws IllegalArgumentException {
        if (parameterName == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"parameterName"));
        }
        if (parameterValues == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)parameterName));
        }
        if (parameterValues.length == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.2"), (Object)parameterName));
        }
        if (validTypes == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.0"), (Object)"validTypes"));
        }
        if (validTypes.length == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.2"), (Object)"validTypes"));
        }
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.1"), (Object)parameterName, (Object)new Integer(i)));
            }
            int j = 0;
            while (j < validTypes.length) {
                if (validTypes[j] == null) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.1"), (Object)"validTypes", (Object)new Integer(j)));
                }
                if (validTypes[j].isInstance(parameterValues[i])) break;
                if (j == validTypes.length - 1) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.6"), (Object[])new Object[]{parameterName, i, parameterValues[i].getClass().getName(), Arrays.toString(validTypes)}));
                }
                ++j;
            }
            ++i;
        }
    }

    public static void validateIsInteger(String parameterName, String parameterValue) {
        ValidationHelper.validateNotEmpty(parameterName, parameterValue);
        try {
            Integer.parseInt(parameterValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.4"), (Object)parameterName, (Object)parameterValue));
        }
    }

    public static void validateIsPositiveInteger(String parameterName, int parameterValue) {
        if (parameterValue <= 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getCommonString("ValidationHelper.5"), (Object)parameterName, (Object)parameterValue));
        }
    }
}

