/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.registry;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.registry.AbstractBuildExtension;
import com.ibm.team.build.internal.common.registry.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractBuildTemplateExtension
extends AbstractBuildExtension {
    private final List<String> fConfigurationElementIds = new ArrayList<String>();
    private final List<String> fAvailableConfigurationElementIds = new ArrayList<String>();
    private final List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();

    public AbstractBuildTemplateExtension(IConfigurationElement pluginConfigurationElement) {
        super(pluginConfigurationElement);
        this.processConfigurationElements(pluginConfigurationElement);
        this.processGenericProperties(pluginConfigurationElement, this.fGenericProperties, true);
        this.processAvailableConfigurationElements(pluginConfigurationElement);
    }

    protected abstract String getConfigurationElementName();

    private void processConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        String elementName = this.getConfigurationElementName();
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren(elementName);
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute("id");
            ValidationHelper.validateNotNull("id", id);
            ValidationHelper.validateNotEmpty("id", id.trim());
            if (!this.fConfigurationElementIds.contains(id)) {
                this.fConfigurationElementIds.add(id);
            }
            ++n2;
        }
        if (this.fConfigurationElementIds.isEmpty()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AbstractBuildTemplateExtension_MISSING_CONFIG_ELEMENT, (Object)elementName, (Object[])new Object[0]));
        }
    }

    public String[] getConfigurationElementIds() {
        return this.fConfigurationElementIds.toArray(new String[this.fConfigurationElementIds.size()]);
    }

    private void processAvailableConfigurationElements(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren("availableBuildConfigurationElement");
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String id = pluginElement.getAttribute("id");
            ValidationHelper.validateNotNull("id", id);
            ValidationHelper.validateNotEmpty("id", id.trim());
            if (!this.fAvailableConfigurationElementIds.contains(id) && !this.fConfigurationElementIds.contains(id)) {
                this.fAvailableConfigurationElementIds.add(id);
            }
            ++n2;
        }
    }

    public String[] getAvailableConfigurationElementIds() {
        return this.fAvailableConfigurationElementIds.toArray(new String[this.fAvailableConfigurationElementIds.size()]);
    }

    public IBuildProperty[] getGenericProperties() {
        return this.fGenericProperties.toArray(new IBuildProperty[this.fGenericProperties.size()]);
    }
}

