/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.filesystem.client.workitems.internal.WorkItemUtils;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixParameter;
import com.ibm.team.filesystem.client.workitems.operations.IDeliverAndFixOperation;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeliverAndFixOperation
extends FileSystemOperation
implements IDeliverAndFixOperation {
    private DeliverAndFixParameter deliverAndFixParameters;
    private DeliverAndFixDilemmaHandler dilemmaHandler;
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private boolean autoReleaseLocks = false;

    public DeliverAndFixOperation(DeliverAndFixDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? DeliverAndFixDilemmaHandler.getDefault() : dilemmaHandler));
        this.dilemmaHandler = dilemmaHandler == null ? DeliverAndFixDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void deliverAndFix(DeliverAndFixParameter parms) {
        this.deliverAndFixParameters = parms;
    }

    public void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.deliverAndFixParameters.getTarget().teamRepository();
        if (!repo.equals(this.deliverAndFixParameters.getSource().teamRepository())) {
            throw new TeamRepositoryException(Messages.DeliverAndFixOperation_0);
        }
        IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        List<Object> locks = new ArrayList<IComponentLockReport>();
        ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(this.deliverAndFixParameters.getWorkItems());
        Iterator i = workItems.iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        List fullWorkItems = repo.itemManager().fetchCompleteItems(workItems, 1, (IProgressMonitor)loopProgress.newChild(20));
        ArrayList<IWorkItemHandle> inaccessibleWorkItems = new ArrayList<IWorkItemHandle>();
        int j = 0;
        while (j < workItems.size()) {
            if (fullWorkItems.get(j) == null) {
                inaccessibleWorkItems.add((IWorkItemHandle)workItems.get(j));
            }
            ++j;
        }
        this.processInaccessibleWorkItems(inaccessibleWorkItems, fullWorkItems, monitor);
        for (IWorkItemHandle workItemToAssign : fullWorkItems) {
            boolean associated = false;
            for (IChangeSetHandle changeSet : this.deliverAndFixParameters.getChangeSets()) {
                if (!WorkItemUtils.isWorkItemAssociated(workItemToAssign, repo, changeSet)) continue;
                associated = true;
                break;
            }
            if (associated) continue;
            for (IChangeSetHandle changeSet : this.deliverAndFixParameters.getChangeSets()) {
                workItemManager.createLink((IWorkspaceHandle)this.deliverAndFixParameters.getTarget().getResolvedWorkspace(), changeSet, new IWorkItemHandle[]{workItemToAssign}, (IProgressMonitor)loopProgress.newChild(1));
            }
        }
        IDeliverOperation deliverOp = IOperationFactory.instance.getDeliverOperation(this.dilemmaHandler.getDeliverDilemmaHandler());
        deliverOp.setRefreshBeforeRun(this.refreshBeforeRun);
        if (this.nonAtomicCommitIsAnOption) {
            deliverOp.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            deliverOp.disableNonAtomicCommit();
        }
        deliverOp.deliver(this.deliverAndFixParameters.getSource(), this.deliverAndFixParameters.getTarget(), this.deliverAndFixParameters.getSyncReport(), new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()));
        if (fullWorkItems.size() > 0) {
            List outgoingChangeSetHandles;
            boolean addReview = this.deliverAndFixParameters.getReviewers().length > 0;
            workItemManager.deliverAndResolve(this.deliverAndFixParameters.getSyncReport(), this.deliverAndFixParameters.getSource(), this.deliverAndFixParameters.getTarget(), new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()), locks, new ArrayList<IWorkItem>(fullWorkItems), this.deliverAndFixParameters.isShouldResolve(), this.deliverAndFixParameters.getComment(), addReview, this.deliverAndFixParameters.getSubject(), Arrays.asList(this.deliverAndFixParameters.getReviewers()), this.deliverAndFixParameters.getDueDate(), deliverOp, monitor);
            DeliverOperation.DeliverOperationRequest deliverRequest = new DeliverOperation.DeliverOperationRequest(this.deliverAndFixParameters.getSource(), this.deliverAndFixParameters.getTarget(), this.deliverAndFixParameters.getSyncReport(), new ArrayList(), new ArrayList(), new ArrayList());
            deliverRequest.addChangeSet(new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()));
            DeliverDilemmaHandler deliverDilemmaHandler = this.dilemmaHandler.getDeliverDilemmaHandler();
            IChangeHistorySyncReport updatedReport = deliverRequest.getWorkspace().compareTo((IFlowNodeConnection)deliverRequest.getTargetWorkspace(), 0, Collections.EMPTY_LIST, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            if (locks.size() > 0 && (outgoingChangeSetHandles = updatedReport.outgoingChangeSets()).size() != 0) {
                locks = ExclusiveFileLockPatternUtil.updateComponentLocks(locks, (ITeamRepository)deliverRequest.getWorkspace().teamRepository(), (List)outgoingChangeSetHandles, (SubMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
            if (locks.size() > 0) {
                IWorkspaceConnection target = this.deliverAndFixParameters.getTarget();
                HashMap<IStreamLockReport, IWorkspaceConnection> locksToRelease = new HashMap<IStreamLockReport, IWorkspaceConnection>();
                locksToRelease.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)target.getResolvedWorkspace(), locks), target);
                Map<Object, Object> locksToRelease2 = this.autoReleaseLocks ? locksToRelease : deliverDilemmaHandler.locksToRelease(locksToRelease);
                if (locksToRelease2.size() > 0) {
                    UnlockOperation unlockOperation = new UnlockOperation(deliverDilemmaHandler.getLockDilemmaHandler());
                    for (Map.Entry entry : locksToRelease2.entrySet()) {
                        List locksEntries = LockEntry.createEntries((ITeamRepository)((IWorkspaceConnection)entry.getValue()).teamRepository(), (IStreamLockReport)((IStreamLockReport)entry.getKey()));
                        for (LockEntry lockEntry : locksEntries) {
                            unlockOperation.unlock(lockEntry.getWorkspaceConnection((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)), lockEntry.getComponent(), lockEntry.getVersionable(), lockEntry.getContributor());
                        }
                    }
                    unlockOperation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                }
            }
            if (ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)this.deliverAndFixParameters.getSource(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)).size() != 0) {
                ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
                Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(Collections.singletonList(deliverRequest), determinants, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                ArrayList<IWorkspace> targets = new ArrayList<IWorkspace>(2);
                targets.add(this.deliverAndFixParameters.getSource().getResolvedWorkspace());
                targets.add(this.deliverAndFixParameters.getTarget().getResolvedWorkspace());
                FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, targets, determinants, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                try {
                    HashMap<IWorkspaceConnection, List> workspaceToDeliveredChangeSets = new HashMap<IWorkspaceConnection, List>();
                    HashMap workspaceComponentOps = new HashMap();
                    IItemManager itemManager = this.deliverAndFixParameters.getSource().teamRepository().itemManager();
                    List changeSets = null;
                    try {
                        changeSets = itemManager.fetchCompleteItems(new ArrayList<IChangeSetHandle>(this.deliverAndFixParameters.getChangeSets()), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
                        workspaceToDeliveredChangeSets.put(this.deliverAndFixParameters.getSource(), changeSets);
                        ExclusiveFileLockPatternUtil.refreshFileAttributes(affectedConfigurations, workspaceToDeliveredChangeSets, workspaceComponentOps, (boolean)true, (SubMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                }
                finally {
                    WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
                }
            }
        } else {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            deliverOp.run((IProgressMonitor)progress);
        }
        monitor.done();
    }

    private void processInaccessibleWorkItems(List<IWorkItemHandle> inaccessibleWorkItems, List<IWorkItem> fullWorkItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inaccessibleWorkItems.size() == 0) {
            return;
        }
        int action = this.dilemmaHandler.workItemsUnreachable(inaccessibleWorkItems.size(), fullWorkItems.size());
        if (action == 0) {
            Iterator<IWorkItem> i = fullWorkItems.iterator();
            while (i.hasNext()) {
                IWorkItem wi = i.next();
                if (wi != null) continue;
                i.remove();
            }
        } else {
            if (action == 2) {
                throw new TeamRepositoryException(Messages.DeliverAndFixOperation_1);
            }
            throw new OperationCanceledException();
        }
    }

    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    protected Set<ConfigurationFacade> getAffectedConfigurations(Collection<? extends OperationRequest> acceptRequests, List<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)acceptRequests.size());
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        for (OperationRequest operationRequest : acceptRequests) {
            configurations.addAll(operationRequest.getAffectedConfigurations(determinants, (IProgressMonitor)monitor.newChild(1)));
        }
        return configurations;
    }

    @Override
    public void setAutoReleaseLocks(boolean value) {
        this.autoReleaseLocks = value;
    }
}

