/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CategoryCache
extends CacheHelper {
    private final AuditableCache.ScopedItemTypeCache<ICategory> fCategoryCache = new AuditableCache.ScopedItemTypeCache(ICategory.ITEM_TYPE, ICategory.PROJECT_AREA_PROPERTY, Integer.MAX_VALUE);

    public CategoryCache(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ICategoryHandle> categoryHandle = CategoriesHelper.findExistingCategories(auditableCommon, projectAreaHandle, monitor);
        ItemProfile profile = ItemProfile.createFullProfile(ICategory.ITEM_TYPE);
        List categories = auditableCommon.resolveAuditables2(categoryHandle, profile, 3, monitor);
        this.fCategoryCache.invalidate((IAuditableHandle)projectAreaHandle);
        this.fCategoryCache.cacheAll((IAuditableHandle)projectAreaHandle, categories, profile);
    }

    public List<ICategory> getCachedCategories(IProjectAreaHandle projectAreaHandle, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectAreaHandle, monitor);
        return this.fCategoryCache.getAll((IAuditableHandle)projectAreaHandle, profile);
    }

    public AuditableCache.IItemTypeCache<? extends IAuditable> getCache() {
        return this.fCategoryCache;
    }

    @Override
    protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCacheStateForItemType(ICategory.ITEM_TYPE, projectAreaHandle, auditableCommon, monitor);
    }

    @Override
    protected void doFlushCache(IProjectAreaHandle projectArea) {
        this.fCategoryCache.invalidate((IAuditableHandle)projectArea);
    }
}

