/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlTemplateUtils {
    private static final Pattern tagPattern = Pattern.compile("\\s*<\\s*?(/\\s*?)??([a-zA-Z]+)([^>]*?)>\\s*");
    private static final Pattern hrefPattern = Pattern.compile("href=\\s*?[\"']([^\"']*?)[\"']");

    private HtmlTemplateUtils() {
        throw new AssertionError((Object)"Initialization not allowed");
    }

    public static String HTMLTemplateToPlainTextTemplate(String htmlTemplate) {
        String tag;
        StringBuffer output = new StringBuffer();
        StringBuffer garbage = new StringBuffer();
        Matcher template = tagPattern.matcher(htmlTemplate);
        while (template.find()) {
            tag = HtmlTemplateUtils.getNextTag(template);
            if (tag.equals("head")) {
                while (template.find() && !HtmlTemplateUtils.getNextTag(template).equals("/" + tag)) {
                }
                template.appendReplacement(garbage, "");
                continue;
            }
            if (tag.equals("p") || tag.equals("/p") || tag.equals("div")) {
                template.appendReplacement(output, "\n\n");
                continue;
            }
            if (tag.equals("li") || tag.equals("br")) {
                template.appendReplacement(output, "\n");
                continue;
            }
            template.appendReplacement(output, "$0");
        }
        template.appendTail(output);
        template.reset(output.toString());
        output = new StringBuffer();
        while (template.find()) {
            tag = HtmlTemplateUtils.getNextTag(template);
            if (tag.equals("a")) {
                template.appendReplacement(output, "");
                String url = null;
                Matcher matcher = hrefPattern.matcher(template.group(3));
                template.group(0);
                if (matcher.find() && (url = matcher.group(1).trim()).startsWith("mailto:")) {
                    url = url.substring(7);
                }
                template.find();
                if (!HtmlTemplateUtils.getNextTag(template).equals("/a")) {
                    template.appendReplacement(output, "$0");
                    continue;
                }
                template.appendReplacement(output, ": ");
                output.append(url);
                output.append(" ");
                continue;
            }
            template.appendReplacement(output, "$0");
        }
        template.appendTail(output);
        template.reset(output.toString());
        output = new StringBuffer();
        while (template.find()) {
            tag = HtmlTemplateUtils.getNextTag(template);
            if (tag.equals("table")) {
                template.appendReplacement(output, "");
                Table table = new Table();
                while (template.find() && !HtmlTemplateUtils.getNextTag(template).equals("/table")) {
                    if (!HtmlTemplateUtils.getNextTag(template).equals("tr")) continue;
                    template.appendReplacement(garbage, "");
                    TableRow.Builder builder = new TableRow.Builder();
                    while (template.find() && !HtmlTemplateUtils.getNextTag(template).equals("/tr")) {
                        if (!HtmlTemplateUtils.getNextTag(template).equals("td")) break;
                        template.appendReplacement(garbage, "");
                        template.find();
                        if (!HtmlTemplateUtils.getNextTag(template).equals("/td")) break;
                        StringBuffer temp = new StringBuffer();
                        template.appendReplacement(temp, "");
                        builder.addCell(temp.toString());
                    }
                    table.addRow(builder.build());
                    template.appendReplacement(garbage, "");
                }
                template.appendReplacement(garbage, "");
                output.append("\n");
                for (TableRow row : table) {
                    int j = 0;
                    while (j < row.getLength() - 1) {
                        output.append(HtmlTemplateUtils.pad(row.getCell(j), table.getColumnWidth(j) + 1));
                        ++j;
                    }
                    output.append(String.valueOf(row.getCell(row.getLength() - 1)) + "\n");
                }
                output.append("\n");
                continue;
            }
            template.appendReplacement(output, "");
        }
        template.appendTail(output);
        return output.toString().replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&nbsp;", " ").replaceAll("&amp;", "&").replaceAll("&circ;", "^").replaceAll("&tilde;", "~").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
    }

    private static String getNextTag(Matcher template) {
        boolean isClosingTag = template.group(1) != null;
        String tag = String.valueOf(isClosingTag ? "/" : "") + template.group(2).toLowerCase(Locale.ROOT);
        return tag;
    }

    private static String pad(String s, int pad) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        int n = pad - s.length();
        int i = 0;
        while (i < n) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private static class Table
    implements Iterable<TableRow> {
        private List<TableRow> fRows = new LinkedList<TableRow>();

        private Table() {
        }

        public void addRow(TableRow row) {
            this.fRows.add(row);
        }

        @Override
        public Iterator<TableRow> iterator() {
            return Collections.unmodifiableList(this.fRows).iterator();
        }

        public int getColumnWidth(int column) {
            int max = 0;
            for (TableRow row : this.fRows) {
                try {
                    max = Math.max(max, row.getCell(column).length());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            return max;
        }
    }

    private static class TableRow {
        private final String[] fCells;

        public TableRow(String[] cells) {
            this.fCells = cells;
        }

        public String getCell(int index) {
            return this.fCells[index];
        }

        public int getLength() {
            return this.fCells.length;
        }

        public static class Builder {
            private final LinkedList<String> fCells = new LinkedList();

            public void addCell(String cell) {
                this.fCells.add(cell);
            }

            public TableRow build() {
                return new TableRow(this.fCells.toArray(new String[this.fCells.size()]));
            }
        }
    }
}

