/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ContributorQueryAttributeFactory
implements IQueryableAttributeFactory {
    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        LocalizationContext projectContext = this.getContext(projectArea, auditableCommon, monitor);
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = ContributorQueryAttributeFactory.getQueryableAttributeDescriptor(projectContext);
        int n = queryableAttributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            if (descriptor.getIdentifier().equals(attributeIdentifier)) {
                return this.createQueryAttribute(descriptor);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        LocalizationContext projectContext = this.getContext(projectArea, auditableCommon, monitor);
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = ContributorQueryAttributeFactory.getQueryableAttributeDescriptor(projectContext);
        int n = queryableAttributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            attributes.add(this.createQueryAttribute(descriptor));
            ++n2;
        }
        return attributes;
    }

    public ItemProfile<IContributor> computeProfile(List<IQueryableAttribute> attributes) {
        ArrayList<String> attributeIds = new ArrayList<String>(attributes.size());
        for (IQueryableAttribute attribute : attributes) {
            attributeIds.add(attribute.getIdentifier());
        }
        return ItemProfile.CONTRIBUTOR_DEFAULT.createExtension(attributeIds);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IContributor.NAME_PROPERTY, IContributor.EMAIL_ADDRESS_PROPERTY);
    }

    protected QueryableAttribute createQueryAttribute(QueryableAttributeDescriptor descriptor) {
        return new QueryableAttribute(descriptor);
    }

    private static QueryableAttributeDescriptor[] getQueryableAttributeDescriptor(LocalizationContext projectContext) {
        return new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IContributor.EMAIL_ADDRESS_PROPERTY, Messages.getString(projectContext, "ContributorQueryAttributeFactory.CONTRIBUTOR_EMAIL"), "smallString"), new QueryableAttributeDescriptor(IContributor.NAME_PROPERTY, Messages.getString(projectContext, "ContributorQueryAttributeFactory.CONTRIBUTOR_NAME"), "smallString"), new QueryableAttributeDescriptor(IContributor.USERID_PROPERTY, Messages.getString(projectContext, "ContributorQueryAttributeFactory.CONTRIBUTOR_USER_ID"), "smallString"), new QueryableAttributeDescriptor(IContributor.ARCHIVED_PROPERTY, Messages.getString(projectContext, "ContributorQueryAttributeFactory.CONTRIBUTOR_ARCHIVED"), "boolean")};
    }

    private LocalizationContext getContext(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return projectArea != null ? LocalizationContext.createProjectAreaContext(auditableCommon, projectArea, monitor) : LocalizationContext.getDefault();
    }
}

