/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.ContributorBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.internal.model.Approval;
import com.ibm.team.workitem.common.internal.model.ModelFactory;
import com.ibm.team.workitem.common.internal.setup.builders.ApprovalDescriptorBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilderContext;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovals;

public class ApprovalBuilder
extends AbstractArtifactBuilder<IApproval> {
    protected static final ValueKey<IContributorHandle> APPROVER = new ValueKey(String.valueOf(ApprovalBuilder.class.getName()) + ".approver");
    protected static final ValueKey<String> STATE_IDENTIFIER = new ValueKey(String.valueOf(ApprovalBuilder.class.getName()) + ".stateIdentifier");
    protected static final ValueKey<UUID> INTERNAL_ID = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".internalId");

    public ApprovalBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
    }

    public ApprovalBuilder internalId(UUID uuid) {
        this.setBuilderValue(INTERNAL_ID, uuid);
        return this;
    }

    public ApprovalBuilder stateIdentifier(String stateIdentifier) {
        this.setBuilderValue(STATE_IDENTIFIER, stateIdentifier);
        return this;
    }

    public ApprovalBuilder state(IApprovalState state) {
        this.setBuilderValue(STATE_IDENTIFIER, state != null ? state.getIdentifier() : null);
        return this;
    }

    public ApprovalBuilder approver(IContributorHandle contributor) {
        this.setBuilderValue(APPROVER, contributor);
        return this;
    }

    public ApprovalBuilder approver(ContributorBuilder contributorBuilder) {
        this.setBuilderValue(APPROVER, (IContributorHandle)contributorBuilder.build());
        return this;
    }

    protected IApproval doBuild(BuildContext buildContext) {
        IApprovals approvals = (IApprovals)buildContext.getProperty(WorkItemBuilderContext.APPROVALS);
        IApprovalDescriptor descriptor = (IApprovalDescriptor)buildContext.getProperty(WorkItemBuilderContext.APPROVAL_DESCRIPTOR);
        Approval approval = this.artifactExists() ? (Approval)this.getExistingArtifact() : (approvals != null ? (Approval)approvals.createApproval(descriptor, (IContributorHandle)this.getBuilderValue(APPROVER)) : ModelFactory.eINSTANCE.createApproval());
        approval.setStateIdentifier((String)this.chooseValue(STATE_IDENTIFIER, approval.getStateIdentifier()));
        approval.setApprover((IContributorHandle)this.chooseValue(APPROVER, approval.getApprover()));
        approval.setInternalId((UUID)this.chooseValue(INTERNAL_ID, approval.getInternalId(), UUID.generate()));
        if (approvals != null) {
            approvals.add(approval);
        }
        return approval;
    }

    protected IApproval doSave(BuildContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Cannot save approvals standalone. To save an apporval, build it into a workitem and save the workitem");
    }
}

