/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.ExtendedRichTextHandlers;
import com.ibm.team.workitem.common.internal.util.HTMLOutputHandler;

public class ScanRules {

    public static class EntityRule
    implements HTMLOutputHandler.IScanRule {
        private static final String CHARS = "<>&^~\"\t";
        private static final String[] ENTITIES = new String[]{"&lt;", "&gt;", "&amp;", "&circ;", "&#126;", "&quot;", "&#09;"};
        private final boolean fUseExtendedRichTextTagRule;
        private final ExtendedRichTextHandlers.ExtendedRichTextTagRule fTagRule = new ExtendedRichTextHandlers.ExtendedRichTextTagRule();

        public EntityRule(boolean useExtendedRichTextTagRule) {
            this.fUseExtendedRichTextTagRule = useExtendedRichTextTagRule;
        }

        @Override
        public String evaluate(HTMLOutputHandler.Scanner scanner) {
            int ch = scanner.read();
            int index = CHARS.indexOf(ch);
            if (index > -1) {
                String replacement = ENTITIES[index];
                if (this.fUseExtendedRichTextTagRule && ch == 60) {
                    String value = this.fTagRule.evaluate(scanner);
                    replacement = value != null ? String.valueOf(replacement) + value : replacement;
                }
                return replacement;
            }
            scanner.unread();
            return null;
        }
    }

    public static class LineDelimiterRule
    implements HTMLOutputHandler.IScanRule {
        private static final String BREAK_TAG = "<br/>";
        private static final String CANONICAL_BREAK_TAG = "<br></br>";
        private final String fBreakTag;

        public LineDelimiterRule(boolean canonical) {
            this.fBreakTag = canonical ? CANONICAL_BREAK_TAG : BREAK_TAG;
        }

        @Override
        public String evaluate(HTMLOutputHandler.Scanner scanner) {
            int ch = scanner.read();
            if (ch == 10) {
                return this.fBreakTag;
            }
            if (ch == 13) {
                ch = scanner.read();
                if (ch != 10) {
                    scanner.unread();
                }
                return this.fBreakTag;
            }
            scanner.unread();
            return null;
        }
    }

    public static class SpaceRule
    implements HTMLOutputHandler.IScanRule {
        private static final String ENTITY_REF_NBSP = "&nbsp;";

        @Override
        public String evaluate(HTMLOutputHandler.Scanner scanner) {
            int ch = scanner.read();
            if (ch == 32) {
                ch = scanner.read();
                scanner.unread();
                if (ch == 32) {
                    return ENTITY_REF_NBSP;
                }
            }
            scanner.unread();
            return null;
        }
    }
}

