/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.api.common.ExtendedRichTextSupport;
import com.ibm.team.workitem.common.internal.model.CategoryAttributeType;
import com.ibm.team.workitem.common.internal.model.ContributorAttributeType;
import com.ibm.team.workitem.common.internal.model.DecimalAttributeType;
import com.ibm.team.workitem.common.internal.model.DeliverableAttributeType;
import com.ibm.team.workitem.common.internal.model.EnumerationAttributeType;
import com.ibm.team.workitem.common.internal.model.EnumerationListAttributeType;
import com.ibm.team.workitem.common.internal.model.HTMLAttributeType;
import com.ibm.team.workitem.common.internal.model.IntegerAttributeType;
import com.ibm.team.workitem.common.internal.model.IterationAttributeType;
import com.ibm.team.workitem.common.internal.model.ListAttributeType;
import com.ibm.team.workitem.common.internal.model.NumericAttributeType;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.internal.model.SimpleAttributeType;
import com.ibm.team.workitem.common.internal.model.TimestampAttributeType;
import com.ibm.team.workitem.common.internal.model.TypeAttributeType;
import com.ibm.team.workitem.common.internal.model.UUIDAttributeType;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.ApprovalStateAttributeType;
import com.ibm.team.workitem.common.model.ApprovalTypeAttributeType;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IStateTransitions;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemAttributeType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.Messages;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributeTypes {
    public static final String SMALL_STRING = "smallString";
    public static final String MEDIUM_STRING = "mediumString";
    public static final String LARGE_STRING = "string";
    public static final String MEDIUM_HTML = "mediumHtml";
    public static final String LARGE_HTML = "html";
    public static final String TIMESTAMP = "timestamp";
    public static final String PROJECT_AREA = "projectArea";
    public static final String TEAM_AREA = "teamArea";
    public static final String PROCESS_AREA = "processArea";
    public static final String CATEGORY = "category";
    public static final String PRIORITY = "priority";
    public static final String ITERATION = "interval";
    public static final String CONTRIBUTOR = "contributor";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String DECIMAL = "decimal";
    public static final String SEVERITY = "severity";
    public static final String DELIVERABLE = "deliverable";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String COMMENTS = "comments";
    public static final String SUBSCRIPTIONS = "subscriptions";
    public static final String APPROVAL_DESCRIPTORS = "approvalDescriptors";
    public static final String APPROVALS = "approvals";
    public static final String WORK_ITEM = "workItem";
    public static final String TIME_SHEET = "timeSheet";
    public static final String TIME_SHEET_ENTRY = "timeSheetEntry";
    public static final String TAGS = "tags";
    public static final String TYPE = "type";
    public static final String CUSTOM_ATTRIBUTE = "customAttribute";
    public static final String APPROVAL_STATE = "approvalState";
    public static final String APPROVAL_TYPE = "approvalType";
    public static final String DURATION = "duration";
    public static final String CONTENT = "content";
    public static final String FILE_SIZE = "fileSize";
    public static final String UUID = "uuid";
    public static final String STATE_TRANSITIONS = "stateTransitions";
    public static final String TIMELINE = "timeline";
    public static final String REFERENCE = "reference";
    public static final String TAG = "tag";
    public static final String WORK_ITEM_LIST = "workItemList";
    public static final String CONTRIBUTOR_LIST = "contributorList";
    public static final String PROCESS_AREA_LIST = "processAreaList";
    public static final String PROJECT_AREA_LIST = "projectAreaList";
    public static final String TEAM_AREA_LIST = "teamAreaList";
    public static final String E_SIGNATURE = "eSignature";
    public static final String WIKI = "wiki";
    public static final String ITEM = "item";
    public static final String ITEM_LIST = "itemList";
    public static final List<String> STRING_TYPES = Arrays.asList("smallString", "mediumString", "string");
    public static final List<String> HTML_TYPES = Arrays.asList("mediumHtml", "html");
    public static final List<String> EXTENDED_RICH_TEXT_TYPES = Arrays.asList(ExtendedRichTextSupport.TYPES);
    public static final List<String> ITEM_TYPES = Arrays.asList("contributor", "deliverable", "category", "interval", "teamArea", "processArea", "projectArea", "workItem", "item");
    public static final List<String> ITEM_LIST_TYPES = Arrays.asList("contributorList", "teamAreaList", "processAreaList", "projectAreaList", "workItemList", "itemList");
    public static final String PROGRESS_INFO = "progress";
    public static final String SCHEDULE_INFO = "schedule";
    public static final List<String> NUMBER_TYPES = Arrays.asList("integer", "long", "float", "decimal", "duration", "fileSize");
    public static final String STRING_LIST = "stringList";
    private static final AttributeType SMALL_STRING_TYPE = new SimpleAttributeType("smallString", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.MATCHES, AttributeOperation.NOT_MATCHES, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType MEDIUM_STRING_TYPE = new SimpleAttributeType("mediumString", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.MATCHES, AttributeOperation.NOT_MATCHES, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType LARGE_STRING_TYPE = new SimpleAttributeType("string", String.class, new AttributeOperation[0], "", null, "_meta");
    private static final AttributeType MEDIUM_HTML_TYPE = new HTMLAttributeType("mediumHtml", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType LARGE_HTML_TYPE = new HTMLAttributeType("html", String.class, new AttributeOperation[0], "", null, "_meta");
    private static final AttributeType TIMESTAMP_TYPE = new TimestampAttributeType("timestamp");
    private static final AttributeType PROJECT_AREA_TYPE = new SetAttributeType("projectArea", IProjectAreaHandle.class, ItemProfile.PROJECT_AREA_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0]);
    private static final AttributeType TEAM_AREA_TYPE = new SetAttributeType("teamArea", ITeamAreaHandle.class, ItemProfile.TEAM_AREA_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0]);
    private static final AttributeType PROCESS_AREA_TYPE = new SetAttributeType("processArea", IProcessAreaHandle.class, ItemProfile.PROCESS_AREA_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0]);
    private static final AttributeType ITEM_TYPE = new ItemAttributeType("item");
    private static final AttributeType CATEGORY_TYPE = new CategoryAttributeType("category");
    private static final AttributeType ITERATION_TYPE = new IterationAttributeType("interval");
    private static final AttributeType PRIORITY_TYPE = new EnumerationAttributeType("priority", IPriority.class);
    private static final AttributeType CONTRIBUTOR_TYPE = new ContributorAttributeType("contributor");
    private static final AttributeType INTEGER_TYPE = new IntegerAttributeType("integer", Integer.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new Integer(0));
    private static final AttributeType FLOAT_TYPE = new DecimalAttributeType("float", Float.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, Float.valueOf(0.0f));
    private static final AttributeType DECIMAL_TYPE = new DecimalAttributeType("decimal", BigDecimal.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, BigDecimal.ZERO);
    private static final AttributeType SEVERITY_TYPE = new EnumerationAttributeType("severity", ISeverity.class);
    private static final AttributeType DELIVERABLE_TYPE = new DeliverableAttributeType("deliverable");
    private static final AttributeType LONG_TYPE = new IntegerAttributeType("long", Long.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new Long(0L));
    private static final AttributeType BOOLEAN_TYPE = new SimpleAttributeType("boolean", Boolean.class, new AttributeOperation[]{AttributeOperation.EQUALS}, Boolean.FALSE, new Object[]{Boolean.FALSE, Boolean.TRUE}, "");
    private static final AttributeType COMMENTS_TYPE = new AttributeType("comments", IComments.class, new AttributeOperation[]{AttributeOperation.AUTHORED_BY}, new String[]{"currentUser"}, "_content");
    private static final AttributeType SUBSCRIPTIONS_TYPE = new ListAttributeType("subscriptions", "contributor");
    private static final AttributeType APPROVAL_DESCRIPTORS_TYPE = new AttributeType("approvalDescriptors", IApprovalDescriptor.class, new AttributeOperation[0], new String[0], "_meta");
    private static final AttributeType APPROVALS_TYPE = new AttributeType("approvals", IApprovals.class, new AttributeOperation[]{AttributeOperation.TO_BE_APPROVED_BY, AttributeOperation.APPROVED_BY, AttributeOperation.REJECTED_BY, AttributeOperation.INVOLVES}, new String[]{"currentUser", "anyone"}, "_meta");
    private static final AttributeType WORK_ITEM_TYPE = new SetAttributeType("workItem", IWorkItemHandle.class, IWorkItem.SMALL_PROFILE, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0], new Object[0]);
    private static final AttributeType TAG_TYPE = new TagsAttributeType("tag");
    private static final AttributeType TYPE_TYPE = new TypeAttributeType("type", (Class)String.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS});
    private static final AttributeType APPROVAL_STATE_TYPE = new ApprovalStateAttributeType("approvalState");
    private static final AttributeType APPROVAL_TYPE_TYPE = new ApprovalTypeAttributeType("approvalType");
    private static final AttributeType DURATION_TYPE = new SimpleAttributeType("duration", Long.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, Duration.UNSPECIFIED.longValue(), null, "");
    private static final AttributeType CUSTOM_ATTRIBUTE_TYPE = new AttributeType("customAttribute", IAttributeHandle.class, new AttributeOperation[]{AttributeOperation.CONTAINING, AttributeOperation.NOT_CONTAINING}, new String[0], "");
    private static final AttributeType CONTENT_TYPE = new AttributeType("content", IContent.class, new AttributeOperation[0], new String[0], "");
    private static final AttributeType FILE_SIZE_TYPE = new AttributeType("fileSize", Long.class, new AttributeOperation[]{AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new String[0], "");
    private static final AttributeType REFERENCE_TYPE = new SimpleAttributeType("reference", IReference.class, new AttributeOperation[]{AttributeOperation.LINK_EXISTS, AttributeOperation.LINK_NOT_EXISTS}, "", null, "");
    private static final AttributeType UUID_TYPE = new UUIDAttributeType("uuid", UUID.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS});
    private static final AttributeType STATE_TRANSITIONS_TYPE = new AttributeType("stateTransitions", IStateTransitions.class, new AttributeOperation[0], new String[0], "");
    private static final AttributeType TIMELINE_TYPE = new SetAttributeType("timeline", IDevelopmentLineHandle.class, ItemProfile.DEVELOPMENT_LINE_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0]);
    private static final AttributeType TAGS_TYPE = new ListAttributeType("tags", "tag", new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS});
    private static final AttributeType WORK_ITEM_LIST_TYPE = new ListAttributeType("workItemList", "workItem");
    private static final AttributeType CONTRIBUTOR_LIST_TYPE = new ListAttributeType("contributorList", "contributor");
    private static final AttributeType PROCESS_AREA_LIST_TYPE = new ListAttributeType("processAreaList", "processArea");
    private static final AttributeType PROJECT_AREA_LIST_TYPE = new ListAttributeType("projectAreaList", "projectArea");
    private static final AttributeType TEAM_AREA_LIST_TYPE = new ListAttributeType("teamAreaList", "teamArea");
    private static final AttributeType ITEM_LIST_TYPE = new ListAttributeType("itemList", "item");
    private static final AttributeType STRING_LIST_TYPE = new ListAttributeType("stringList", "mediumString");
    private static final AttributeType E_SIGNATURE_TYPE = new SimpleAttributeType("eSignature", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.MATCHES, AttributeOperation.NOT_MATCHES, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType WIKI_TYPE = new SimpleAttributeType("wiki", String.class, new AttributeOperation[0], "", null, "_meta");
    private static final List<String> CUSTOM_ATTRIBUTE_TYPES = Arrays.asList("smallString", "mediumString", "string", "mediumHtml", "html", "integer", "long", "decimal", "boolean", "timestamp", "tags", "duration", "wiki", "eSignature", "stringList");
    private static final Map<String, AttributeType> fgRegistry = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> fgNameRegistry = Collections.synchronizedMap(new HashMap());

    static {
        fgRegistry.put(SMALL_STRING, SMALL_STRING_TYPE);
        fgNameRegistry.put(SMALL_STRING, "AttributeTypes.SMALLSTRING");
        fgRegistry.put(MEDIUM_STRING, MEDIUM_STRING_TYPE);
        fgNameRegistry.put(MEDIUM_STRING, "AttributeTypes.MEDIUMSTRING");
        fgRegistry.put(LARGE_STRING, LARGE_STRING_TYPE);
        fgNameRegistry.put(LARGE_STRING, "AttributeTypes.LARGESTRING");
        fgRegistry.put(MEDIUM_HTML, MEDIUM_HTML_TYPE);
        fgNameRegistry.put(MEDIUM_HTML, "AttributeTypes.MEDIUMHTML");
        fgRegistry.put(LARGE_HTML, LARGE_HTML_TYPE);
        fgNameRegistry.put(LARGE_HTML, "AttributeTypes.LARGEHTML");
        fgRegistry.put(TIMESTAMP, TIMESTAMP_TYPE);
        fgNameRegistry.put(TIMESTAMP, "AttributeTypes.TIMESTAMP");
        fgRegistry.put(PROJECT_AREA, PROJECT_AREA_TYPE);
        fgNameRegistry.put(PROJECT_AREA, "AttributeTypes.PROJECTAREA");
        fgRegistry.put(TEAM_AREA, TEAM_AREA_TYPE);
        fgNameRegistry.put(TEAM_AREA, "AttributeTypes.TEAMAREA");
        fgRegistry.put(PROCESS_AREA, PROCESS_AREA_TYPE);
        fgNameRegistry.put(PROCESS_AREA, "AttributeTypes.PROCESSAREA");
        fgRegistry.put(ITEM, ITEM_TYPE);
        fgNameRegistry.put(ITEM, "AttributeTypes.ITEM");
        fgRegistry.put(CATEGORY, CATEGORY_TYPE);
        fgNameRegistry.put(CATEGORY, "AttributeTypes.CATEGORY");
        fgRegistry.put(ITERATION, ITERATION_TYPE);
        fgNameRegistry.put(ITERATION, "AttributeTypes.ITERATION");
        fgRegistry.put(PRIORITY, PRIORITY_TYPE);
        fgNameRegistry.put(PRIORITY, "AttributeTypes.PRIORITY");
        fgRegistry.put(CONTRIBUTOR, CONTRIBUTOR_TYPE);
        fgNameRegistry.put(CONTRIBUTOR, "AttributeTypes.CONTRIBUTOR");
        fgRegistry.put(INTEGER, INTEGER_TYPE);
        fgNameRegistry.put(INTEGER, "AttributeTypes.INTEGER");
        fgRegistry.put(FLOAT, FLOAT_TYPE);
        fgNameRegistry.put(FLOAT, "AttributeTypes.FLOAT");
        fgRegistry.put(DECIMAL, DECIMAL_TYPE);
        fgNameRegistry.put(DECIMAL, "AttributeTypes.DECIMAL");
        fgRegistry.put(SEVERITY, SEVERITY_TYPE);
        fgNameRegistry.put(SEVERITY, "AttributeTypes.SEVERITY");
        fgRegistry.put(DELIVERABLE, DELIVERABLE_TYPE);
        fgNameRegistry.put(DELIVERABLE, "AttributeTypes.DELIVERABLE");
        fgRegistry.put(LONG, LONG_TYPE);
        fgNameRegistry.put(LONG, "AttributeTypes.LONG");
        fgRegistry.put(BOOLEAN, BOOLEAN_TYPE);
        fgNameRegistry.put(BOOLEAN, "AttributeTypes.BOOLEAN");
        fgRegistry.put(COMMENTS, COMMENTS_TYPE);
        fgNameRegistry.put(COMMENTS, "AttributeTypes.COMMENTS");
        fgRegistry.put(SUBSCRIPTIONS, SUBSCRIPTIONS_TYPE);
        fgNameRegistry.put(SUBSCRIPTIONS, "AttributeTypes.SUBSCRIPTIONS");
        fgRegistry.put(APPROVAL_DESCRIPTORS, APPROVAL_DESCRIPTORS_TYPE);
        fgNameRegistry.put(APPROVAL_DESCRIPTORS, "AttributeTypes.APPROVALDESCRIPTOR");
        fgRegistry.put(APPROVALS, APPROVALS_TYPE);
        fgNameRegistry.put(APPROVALS, "AttributeTypes.APPROVAL");
        fgRegistry.put(WORK_ITEM, WORK_ITEM_TYPE);
        fgNameRegistry.put(WORK_ITEM, "AttributeTypes.WORKITEM");
        fgRegistry.put(TAGS, TAGS_TYPE);
        fgNameRegistry.put(TAGS, "AttributeTypes.TAG");
        fgRegistry.put(TAG, TAG_TYPE);
        fgNameRegistry.put(TAG, "AttributeTypes.TAG");
        fgRegistry.put(TYPE, TYPE_TYPE);
        fgNameRegistry.put(TYPE, "AttributeTypes.TYPE");
        fgRegistry.put(APPROVAL_STATE, APPROVAL_STATE_TYPE);
        fgNameRegistry.put(APPROVAL_STATE, "AttributeTypes.APPROVALSTATE");
        fgRegistry.put(APPROVAL_TYPE, APPROVAL_TYPE_TYPE);
        fgNameRegistry.put(APPROVAL_TYPE, "AttributeTypes.APPROVALTYPE");
        fgRegistry.put(DURATION, DURATION_TYPE);
        fgNameRegistry.put(DURATION, "AttributeTypes.DURATION");
        fgRegistry.put(CUSTOM_ATTRIBUTE, CUSTOM_ATTRIBUTE_TYPE);
        fgNameRegistry.put(CUSTOM_ATTRIBUTE, "AttributeTypes.CUSTOMATTRIBUTE");
        fgRegistry.put(CONTENT, CONTENT_TYPE);
        fgNameRegistry.put(CONTENT, "AttributeTypes.CONTENT");
        fgRegistry.put(FILE_SIZE, FILE_SIZE_TYPE);
        fgNameRegistry.put(FILE_SIZE, "AttributeTypes.FILESIZE");
        fgRegistry.put(REFERENCE, REFERENCE_TYPE);
        fgNameRegistry.put(REFERENCE, "AttributeTypes.REFERENCE");
        fgRegistry.put(UUID, UUID_TYPE);
        fgNameRegistry.put(UUID, "AttributeTypes.UUID");
        fgRegistry.put(WORK_ITEM_LIST, WORK_ITEM_LIST_TYPE);
        fgNameRegistry.put(WORK_ITEM_LIST, "AttributeTypes.WORKITEMLIST");
        fgRegistry.put(CONTRIBUTOR_LIST, CONTRIBUTOR_LIST_TYPE);
        fgNameRegistry.put(CONTRIBUTOR_LIST, "AttributeTypes.CONTRIBUTORLIST");
        fgRegistry.put(PROCESS_AREA_LIST, PROCESS_AREA_LIST_TYPE);
        fgNameRegistry.put(PROCESS_AREA_LIST, "AttributeTypes.PROCESSAREALIST");
        fgRegistry.put(PROJECT_AREA_LIST, PROJECT_AREA_LIST_TYPE);
        fgNameRegistry.put(PROJECT_AREA_LIST, "AttributeTypes.PROJECTAREALIST");
        fgRegistry.put(TEAM_AREA_LIST, TEAM_AREA_LIST_TYPE);
        fgNameRegistry.put(TEAM_AREA_LIST, "AttributeTypes.TEAMAREALIST");
        fgRegistry.put(ITEM_LIST, ITEM_LIST_TYPE);
        fgNameRegistry.put(ITEM_LIST, "AttributeTypes.ITEMLIST");
        fgRegistry.put(WIKI, WIKI_TYPE);
        fgNameRegistry.put(WIKI, "AttributeTypes.WIKI");
        fgRegistry.put(E_SIGNATURE, E_SIGNATURE_TYPE);
        fgNameRegistry.put(E_SIGNATURE, "AttributeTypes.ESIGNATURE");
        fgRegistry.put(STATE_TRANSITIONS, STATE_TRANSITIONS_TYPE);
        fgNameRegistry.put(STATE_TRANSITIONS, "AttributeTypes.STATE_TRANSITIONS");
        fgRegistry.put(TIMELINE, TIMELINE_TYPE);
        fgNameRegistry.put(TIMELINE, "AttributeTypes.TIMELINE");
        fgRegistry.put(STRING_LIST, STRING_LIST_TYPE);
        fgNameRegistry.put(STRING_LIST, "AttributeTypes.STRING_LIST");
    }

    public static AttributeType getAttributeType(String attributeTypeIdentifier) {
        AttributeType attributeType = fgRegistry.get(attributeTypeIdentifier);
        if (attributeType == null) {
            attributeType = EnumerationListAttributeType.isEnumerationListIdentifier(attributeTypeIdentifier) ? new EnumerationListAttributeType(attributeTypeIdentifier) : new EnumerationAttributeType(attributeTypeIdentifier, ILiteral.class);
        }
        return attributeType;
    }

    public static List<AttributeType> getAttributeTypes() {
        return new ArrayList<AttributeType>(fgRegistry.values());
    }

    public static boolean isEnumerationAttributeType(String attributeTypeIdentifier) {
        return AttributeTypes.getAttributeType(attributeTypeIdentifier) instanceof EnumerationAttributeType;
    }

    public static boolean isPrimitiveAttributeType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        return type instanceof SimpleAttributeType || type instanceof NumericAttributeType || type instanceof TimestampAttributeType || type instanceof TagsAttributeType;
    }

    public static boolean isItemAttributeType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        return IItemHandle.class.isAssignableFrom(type.getInstanceType());
    }

    public static boolean isListAttributeType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        return type instanceof ListAttributeType;
    }

    public static boolean isItemListAttributeType(String attributeTypeIdentifier) {
        if (AttributeTypes.isListAttributeType(attributeTypeIdentifier)) {
            return AttributeTypes.isItemAttributeType(AttributeTypes.getContainedType(attributeTypeIdentifier));
        }
        return false;
    }

    public static boolean isEnumerationListAttributeType(String attributeTypeIdentifier) {
        return AttributeTypes.isListAttributeType(attributeTypeIdentifier) && AttributeTypes.isEnumerationAttributeType(AttributeTypes.getContainedType(attributeTypeIdentifier));
    }

    public static IItemType getItemType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        if (type instanceof SetAttributeType) {
            return ((SetAttributeType)type).getItemType();
        }
        return null;
    }

    public static String getContainedType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        if (type instanceof ListAttributeType) {
            return ((ListAttributeType)type).getContainedType();
        }
        return null;
    }

    public static AttributeType getContainerType(String attributeTypeIdentifier) {
        if (attributeTypeIdentifier.equals(CONTRIBUTOR)) {
            return CONTRIBUTOR_LIST_TYPE;
        }
        for (AttributeType type : AttributeTypes.getAttributeTypes()) {
            if (!(type instanceof ListAttributeType) || !attributeTypeIdentifier.equals(((ListAttributeType)type).getContainedType())) continue;
            return type;
        }
        AttributeType attributeType = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        if (attributeType instanceof EnumerationAttributeType) {
            return new EnumerationListAttributeType((EnumerationAttributeType)attributeType);
        }
        return null;
    }

    public static boolean isSupportedCustomAttributeType(String attributeTypeIdentifier) {
        if (CUSTOM_ATTRIBUTE.equals(attributeTypeIdentifier)) {
            return false;
        }
        if (CUSTOM_ATTRIBUTE_TYPES.contains(attributeTypeIdentifier)) {
            return true;
        }
        if (AttributeTypes.isEnumerationAttributeType(attributeTypeIdentifier)) {
            return true;
        }
        if (AttributeTypes.isItemAttributeType(attributeTypeIdentifier)) {
            return true;
        }
        if (AttributeTypes.isItemListAttributeType(attributeTypeIdentifier) && !SUBSCRIPTIONS.equals(attributeTypeIdentifier)) {
            return true;
        }
        return AttributeTypes.isEnumerationListAttributeType(attributeTypeIdentifier);
    }

    public static AttributeType getAttributeType(IItemType itemType) {
        if (itemType != null) {
            for (AttributeType type : AttributeTypes.getAttributeTypes()) {
                if (!(type instanceof SetAttributeType) || !itemType.equals(((SetAttributeType)type).getItemType())) continue;
                return type;
            }
        }
        return null;
    }

    public static String getDisplayName(LocalizationContext context, String attributeTypeIdentifier) {
        String messageKey = fgNameRegistry.get(attributeTypeIdentifier);
        String displayName = null;
        displayName = messageKey == null ? attributeTypeIdentifier : Messages.getString(context, messageKey);
        if (EnumerationListAttributeType.isEnumerationListIdentifier(attributeTypeIdentifier)) {
            displayName = AttributeTypes.getContainedType(attributeTypeIdentifier);
            return NLS.bind((String)Messages.getString(context, "AttributeTypes.TYPE_ENUMERATION_LIST"), (Object)displayName, (Object[])new Object[0]);
        }
        if (AttributeTypes.isEnumerationAttributeType(attributeTypeIdentifier)) {
            return NLS.bind((String)Messages.getString(context, "AttributeTypes.TYPE_ENUMERATION"), (Object)displayName, (Object[])new Object[0]);
        }
        return displayName;
    }
}

