/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.factory.PluginProviderFactory;
import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.UcmImporter;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.connector.scm.cc.syncviabuild.BuildClientForCc;
import com.ibm.team.connector.scm.cc.syncviabuild.BuildClientForCcImport;
import com.ibm.team.connector.scm.cc.syncviabuild.BuildClientForCcSync;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.connector.scm.operations.BuildResultUpdater;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.connector.scm.operations.TaskDetailedFeedback;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.service.IPermissionService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IWorkItemCommon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.wvcm.Baseline;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ConnectorOps {
    public static final String WVCM_JAZZ_PROVIDER_PATH = JzProvider.class.getName();
    private static final String EV_PREFIX = "com.ibm.team.connector.scm.operations.";
    public static final String CT_INITARG_PREFIX = "CTPROVIDER_";
    public static final String JZ_INITARG_PREFIX = "JZPROVIDER_";
    public static final String SYNC_OP_PREFIX = "SYNC_OPERATION_";
    public static final String SYNC_OP_ACTIVIY_ID = "SYNC_OPERATION_ACTIVITY_ID";
    public static final String SYNC_STATUS_PROP = "SYNC_OPERATION_STATUS";
    public static final String SYNC_ERROR_MSG_PROP = "SYNC_OPERATION_ERROR_MESSAGE";
    public static final PropertyRequestItem.PropertyRequest PR_PATH_WS_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE.nest(new PropertyRequestItem[]{Workspace.PATHNAME_LOCATION})});
    public static final PropertyRequestItem.PropertyRequest PR_DISP_NAME = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME});
    public static final PropertyRequestItem.PropertyRequest PR_ID = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER});
    protected static final PropertyRequestItem.PropertyRequest PR_CONFIG_PROP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION});
    public static final PropertyRequestItem.PropertyRequest PR_NAMES = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION, Resource.DISPLAY_NAME});
    static Class<?>[] DEPENDENCIES = new Class[]{IAuditable.class, IFileSystemWorkItemManager.class, IInteropManager.class, ILinkManager.class, IProcessItemService.class, ITeamBuildClient.class, IWorkItemClient.class, IWorkItemCommon.class, ProviderFactory.class};
    public static final PropertyRequestItem.PropertyRequest ALL_JAZZ_STREAM_PROPERTIES = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME, Resource.PATHNAME_LOCATION, InteropCore.PN_INTEROP_STREAM});

    public static JzProvider createJazzProvider(String repositoryURI, String userId, String password) throws Exception {
        JzProvider jazzProvider = null;
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        JzProvider.validateNotEmpty((String)"com.ibm.team.connector.scm.REPOSITORY_URI", (String)repositoryURI);
        JzProvider.validateNotEmpty((String)"userId", (String)userId);
        JzProvider.validateNotNull((String)"password", (Object)password);
        Hashtable<String, String> initArgs = new Hashtable<String, String>();
        initArgs.put("com.ibm.team.connector.scm.REPOSITORY_URI", repositoryURI);
        try {
            JzProvider.doLogin((String)repositoryURI, (String)userId, (String)password);
            jazzProvider = (JzProvider)PluginProviderFactory.pluginCreateProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            if (jazzProvider == null) {
                System.out.println("internal warning: plugin provider factory returned null");
                jazzProvider = (JzProvider)ProviderFactory.createProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            }
            JzProvider.validateNotNull((String)"jazzProvider", (Object)jazzProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return jazzProvider;
    }

    public static void synchronizeStream(InteropStream iStream, TaskDetailedFeedback fb) throws Throwable {
        String completionMessage;
        InteropStream iStreamCopy;
        final Feedback noProgress = fb.nest();
        BuildResultUpdater buildResultUpdater = fb.getBuildResult();
        JzProvider p = (JzProvider)iStream.thisProvider();
        if (buildResultUpdater != null) {
            InteropStream iStreamCopy2;
            IBuildResult buildResult = buildResultUpdater.getBuildResult(null);
            String relativeLocationString = com.ibm.team.repository.common.Location.itemLocation((IItemHandle)buildResult, null).toRelativeUri().toString();
            String storedBuildResultLocString = p.lookupBuildResultLocationString();
            if (storedBuildResultLocString == null || !storedBuildResultLocString.equals(relativeLocationString)) {
                if (storedBuildResultLocString == null) {
                    storedBuildResultLocString = "null";
                }
                fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_UPDATING_BUILD_RESULT_ID_WITH_OLD_VALUE, (Object)storedBuildResultLocString, (Object[])new Object[0]));
                BuildClientForCcSync buildClient = new BuildClientForCcSync(iStream);
                buildClient.persistCurrentBuildResultId((IBuildResultHandle)buildResult, noProgress);
            }
            try {
                iStreamCopy2 = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_INIT_ARGS, "synchronizerProperties.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showProperties(iStreamCopy2, writer, noProgress);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_INIT_ARGS, (Object[])new Object[]{e.getMessage()}));
            }
            try {
                iStreamCopy2 = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_SYNCD_FILES_FOLDERS, "synchronizedFilesBeforeSync.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showSyncdFilesFolders(iStreamCopy2, writer, noProgress);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_SYNCD_FILES_FOLDERS, (Object[])new Object[]{e.getMessage()}));
            }
            String[] roots = iStream.get_unprocessedArguments();
            if (roots != null && roots.length > 0) {
                try {
                    iStreamCopy = iStream;
                    buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_NEW_FILES_FOLDERS_TO_SYNC, "newFilesToSync.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                        @Override
                        public void writeContribution(PrintWriter writer) throws WvcmException {
                            ConnectorOps.showNewFilesFoldersToSync(iStreamCopy, writer, noProgress);
                        }
                    });
                }
                catch (Exception e) {
                    fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_NEW_FILES_FOLDERS_TO_SYNC, (Object[])new Object[]{e.getMessage()}));
                }
            }
        }
        Throwable doOperationThrowable = null;
        try {
            iStream.doOperation(fb.nest(100));
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN.equals((Object)e.getReasonCode())) {
                fb.notifyActive(Messages.ConnectorOps_INFO_REFRESHING_INTEROPSTREAM);
                iStream = iStream.refresh(noProgress);
            } else {
                doOperationThrowable = e;
            }
        }
        catch (Throwable e) {
            doOperationThrowable = e;
        }
        boolean testingThrownExceptions = JzProvider.testingThrownException((String)"com.ibm.team.connector.scm.operations.forceSyncException");
        if (testingThrownExceptions) {
            try {
                throw new WvcmException("Testing exception handling (first one)", WvcmException.ReasonCode.NOT_FOUND);
            }
            catch (WvcmException e) {
                if (buildResultUpdater != null) {
                    buildResultUpdater.contributeExceptionStackTrace(e);
                }
                throw new WvcmException("Testing exception handling (wrapper)", null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)e);
            }
        }
        boolean syncEndedWithoutConflicts = iStream.get_state().equals((Object)InteropCore.InteropStreamState.OK);
        String string = completionMessage = syncEndedWithoutConflicts ? Messages.ConnectorOps_STATUS_SYNC_COMPLETE_NO_CONFLICTS : Messages.ConnectorOps_STATUS_SYNC_COMPLETE_WITH_CONFLICTS;
        if (buildResultUpdater != null) {
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_INFO_SFF_AFTER_SYNC, "synchronizedFilesAfterSync.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showSyncdFilesFolders(iStreamCopy, writer, noProgress);
                    }
                });
            }
            catch (Throwable e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_INFO_SFF_AFTER_SYNC, (Object[])new Object[]{e.getMessage()}));
            }
            try {
                iStreamCopy = iStream;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_SYNC_STATS, "synchronizerStatistics.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showCollectedSyncStats(iStreamCopy, writer, null, noProgress);
                    }
                });
            }
            catch (Throwable e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_SYNC_STATS, (Object[])new Object[]{e.getMessage()}));
            }
            if (doOperationThrowable == null && iStream.get_state() != InteropCore.InteropStreamState.OPERATION_CANCELED) {
                try {
                    buildResultUpdater.startTopLevelActivity(completionMessage);
                    buildResultUpdater.setCompletionStatus(syncEndedWithoutConflicts);
                    if (!syncEndedWithoutConflicts) {
                        fb.notifyWarning(Messages.ConnectorOps_WARNING_MERGE_NEEDED);
                    }
                }
                catch (Throwable e) {
                    fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_COMPLETION_MSG_AND_STATUS_WITH_EXCEPTION_MSG, (Object)e.getMessage(), (Object[])new Object[0]));
                }
            }
        }
        try {
            ConnectorOps.showCollectedSyncStats(iStream, null, fb.get_out(), noProgress);
        }
        catch (Throwable throwable) {}
        if (doOperationThrowable != null) {
            throw doOperationThrowable;
        }
        if (buildResultUpdater == null) {
            fb.notifyActive(completionMessage);
        }
    }

    public static Stream lookupStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        JzProvider.validateNotEmpty((String)"syncStreamLocationString", (String)syncStreamLocationString);
        JzLocation syncStreamLocation = jazzProvider.location(syncStreamLocationString);
        JzProvider.validateNotNull((String)"syncStreamLocation", (Object)syncStreamLocation);
        Stream syncStream = ConnectorOps.resolveStream(jazzProvider, (Location)syncStreamLocation, f);
        return syncStream;
    }

    public static InteropStream lookupInteropStream(JzProvider provider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.lookupStream(provider, syncStreamLocationString, f);
        InteropStream iStream = InteropStream.lookupInteropStream((Stream)syncStream, (Feedback)f);
        return iStream;
    }

    public static String getBVNMessage(JzProvider provider, String packageName) {
        return NLS.bind((String)Messages.ConnectorOps_SYNCHRONIZER_VERSION_NUMBER, (Object)ConnectorOps.getVersionNumber(provider, packageName), (Object[])new Object[0]);
    }

    private static String getVersionNumber(JzProvider provider, String packageName) {
        String result = null;
        try {
            result = ConnectorOps.getBundleVersionNumber(packageName);
            if (result == null) {
                result = ConnectorOps.getVersionNumberFromInstallLocation(provider);
            }
        }
        catch (Throwable throwable) {}
        if (result == null) {
            return Messages.ConnectorOps_UNKNOWN;
        }
        return result;
    }

    private static String getVersionNumberFromInstallLocation(JzProvider provider) {
        String result;
        block6: {
            result = null;
            File buildId = new File(new File(provider.getInstallLocation(), "ScmConnectors"), "buildId.txt");
            try {
                if (!buildId.exists()) break block6;
                FileReader r = new FileReader(buildId);
                BufferedReader br = new BufferedReader(r);
                try {
                    result = br.readLine();
                }
                finally {
                    br.close();
                    r.close();
                }
            }
            catch (FileNotFoundException e) {
                provider.logIgnoredExceptionAsAlwaysVisible("ConnectorOps.getVersionNumberFromInstallLocation", (Exception)e);
            }
            catch (IOException e) {
                provider.logIgnoredExceptionAsAlwaysVisible("ConnectorOps.getVersionNumberFromInstallLocation", (Exception)e);
            }
        }
        return result;
    }

    private static String getBundleVersionNumber(String packageName) {
        Bundle bundle = Platform.getBundle((String)packageName);
        if (bundle == null) {
            return null;
        }
        Dictionary headers = bundle.getHeaders();
        if (headers == null) {
            return null;
        }
        String bundleVersion = (String)headers.get("Bundle-Version");
        if (bundleVersion == null) {
            return null;
        }
        return bundleVersion;
    }

    public static Stream resolveStream(JzProvider provider, Location syncStreamLocation, Feedback feedback) throws WvcmException {
        SrvcFeedback sf = provider.srvcFeedback(feedback);
        JzRepoResource result = provider.lookup(syncStreamLocation, sf);
        if (result != null) {
            return (Stream)result.buildProxy(PR_NAMES, sf);
        }
        return JzRepoStream.lookupStreamByName((JzProvider)provider, (String)syncStreamLocation.string(), (PropertyRequestItem.PropertyRequest)PR_NAMES, (SrvcFeedback)sf);
    }

    public static int listOrUnlinkClones(JzProvider provider, final boolean hasRemoveOption, IComponentHandle compHandle, boolean verbose) throws WvcmException {
        System.out.println(ConnectorOps.getBVNMessage(provider, "com.ibm.team.connector.scm.operations"));
        if (hasRemoveOption) {
            IClientLibraryContext context = (IClientLibraryContext)provider.getRepo();
            IPermissionService service = (IPermissionService)context.getServiceInterface(IPermissionService.class);
            try {
                service.assertPermission("JazzAdmins");
            }
            catch (PermissionDeniedException e) {
                throw new WvcmException(Messages.ConnectorOps_ERROR_REMOVE_LINKS_JAZZ_PERMISSIONS, null, WvcmException.ReasonCode.UNAUTHORIZED, (Throwable)e);
            }
        }
        final ILinkManager linkManager = JzRepoResource.getLinkManager((JzProvider)provider);
        try {
            String compLocation = null;
            if (compHandle != null) {
                compLocation = JzRepoComponent.createComponentLocation((IComponentHandle)compHandle).string();
            }
            final String scopeLocation = compLocation;
            JzRepoResource.CountingVisitor countingVisitor = new JzRepoResource.CountingVisitor(verbose){

                public boolean visit(ILink cloneLink) throws WvcmException {
                    boolean result;
                    if (scopeLocation != null) {
                        String extraInfo = null;
                        IReference sourceRef = cloneLink.getSourceRef();
                        if (sourceRef instanceof IItemReference) {
                            IItemReference itemRef = (IItemReference)sourceRef;
                            extraInfo = itemRef.getExtraInfo();
                            IItemHandle handle = itemRef.getReferencedItem();
                            if (extraInfo == null && handle instanceof IComponentHandle) {
                                extraInfo = JzRepoComponent.createComponentLocation((IComponentHandle)((IComponentHandle)handle)).string();
                            }
                        }
                        if (!scopeLocation.equals(extraInfo)) {
                            return true;
                        }
                    }
                    if ((result = super.visit(cloneLink)) && hasRemoveOption) {
                        try {
                            linkManager.deleteLink(cloneLink, null);
                        }
                        catch (TeamRepositoryException e) {
                            throw new WvcmException(Messages.ConnectorOps_ERROR_DELETION_FAILED, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                        }
                    }
                    return result;
                }
            };
            JzRepoResource.forEachCloneLink((JzProvider)provider, (JzRepoResource.IVisitCloneLink)countingVisitor);
            int matches = countingVisitor.getMatches();
            System.out.println(NLS.bind((String)(hasRemoveOption ? Messages.ConnectorOps_INFO_REMOVED_LINKS_WITH_COUNT : Messages.ConnectorOps_INFO_CLONE_LINKS_FOUND_COUNT), (Object)matches, (Object[])new Object[0]));
            return matches;
        }
        catch (WvcmException we) {
            throw we;
        }
        catch (Exception e) {
            throw new RuntimeException(NLS.bind((String)Messages.ConnectorOps_ERROR_COMMAND_FAILED, (Object)"clones", (Object[])new Object[0]), e);
        }
    }

    public static void checkDependencies(JzProvider provider, boolean verbose) {
        ITeamRepository repo = provider.getRepo();
        Class<?>[] classArray = DEPENDENCIES;
        int n = DEPENDENCIES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            repo.getClientLibrary(c);
            if (verbose) {
                System.out.println(NLS.bind((String)Messages.ConnectorOps_LOADED_CLASS, (Object)c.getName(), (Object[])new Object[0]));
            }
            ++n2;
        }
        System.out.println(Messages.ConnectorOps_DEPS_OK);
    }

    public static void logout(JzProvider provider) {
        ITeamRepository repo;
        ITeamRepository iTeamRepository = repo = provider != null ? provider.getRepo() : null;
        if (repo != null) {
            repo.logout();
        }
    }

    public static List<Stream> getSynchronizedStreamsInMyProcessAreas(JzProvider provider, boolean verbose, Feedback feedback) throws WvcmException {
        List<IProcessAreaHandle> processAreaHandles = ConnectorOps.getMyProcessAreasThatCouldHaveStreams(provider, feedback.nest(10));
        if (verbose) {
            feedback.notifyActive(NLS.bind((String)Messages.ConnectorOps_SEARCHING_FOR_CCSS_IN_X_PROCESS_AREAS, (Object)processAreaHandles.size(), (Object[])new Object[0]));
        }
        ArrayList<Stream> results = new ArrayList<Stream>();
        List someStreams = provider.findInteropStreams(processAreaHandles, ALL_JAZZ_STREAM_PROPERTIES, verbose, provider.srvcFeedback(feedback));
        results.addAll(someStreams);
        return results;
    }

    private static List<IProcessAreaHandle> getMyProcessAreasThatCouldHaveStreams(JzProvider provider, Feedback f) throws WvcmException {
        try {
            ITeamRepository repo = provider.getRepo();
            IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
            IContributor loggedInContributor = repo.loggedInContributor();
            List<IProcessArea> processAreas = ConnectorOps.findProcessAreasFor(loggedInContributor, itemService);
            int myProcessAreasCount = processAreas.size();
            if (myProcessAreasCount == 0) {
                return Collections.emptyList();
            }
            TreeSet<IProcessArea> results = new TreeSet<IProcessArea>(ItemUtil.itemIdComparator);
            for (IProcessArea processArea : processAreas) {
                if (results.contains(processArea)) continue;
                IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
                if (ItemUtil.equivItemRef((IItemHandle)projectAreaHandle, (IItemHandle)processArea)) {
                    results.addAll(((IProjectArea)processArea).getTeamAreas());
                } else {
                    if (results.contains(projectAreaHandle)) continue;
                    List teamAreaHandles = itemService.findTeamAreaHierarchies(loggedInContributor, (IProcessAreaHandle)processArea, IProcessClientService.ALL_PROPERTIES, JzProvider.getMonitor((Feedback)f, (int)55));
                    results.addAll(teamAreaHandles);
                }
                results.add(processArea);
            }
            return new ArrayList<IProcessAreaHandle>(results);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Throwable)e);
        }
    }

    public static List<IProjectArea> findMyProjectAreas(JzProvider provider, SrvcFeedback srvcFeedback) throws WvcmException {
        TreeSet<IProjectArea> projectAreas = new TreeSet<IProjectArea>(ItemUtil.itemIdComparator);
        List<IProcessArea> processAreas = ConnectorOps.findProcessAreasFor(provider, provider.getRepo().loggedInContributor());
        for (IProcessArea processArea : processAreas) {
            IProjectArea projectArea = null;
            IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
            if (projectAreas.contains(projectAreaHandle)) continue;
            projectArea = ItemUtil.equivItemRef((IItemHandle)processArea, (IItemHandle)projectAreaHandle) ? (IProjectArea)processArea : (IProjectArea)provider.fetchCompleteProcessArea((IProcessAreaHandle)projectAreaHandle, srvcFeedback);
            projectAreas.add(projectArea);
        }
        return new ArrayList<IProjectArea>(projectAreas);
    }

    public static List<IProcessArea> findProcessAreasFor(JzProvider provider, IContributor contributor) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
            return ConnectorOps.findProcessAreasFor(contributor, itemService);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Throwable)e);
        }
    }

    public static List<IProcessArea> findProcessAreasFor(IContributor contributor, IProcessItemService itemService) throws TeamRepositoryException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        List processAreas = itemService.findProcessAreas(contributor, null, IProcessClientService.ALL_PROPERTIES, (IProgressMonitor)monitor);
        return processAreas;
    }

    public static Stream getStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.lookupStream(jazzProvider, syncStreamLocationString, f);
        if (syncStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_WVCM_STREAM_WITH_NAME, (Object)syncStreamLocationString, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return syncStream;
    }

    public static InteropStream getInteropStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.getStream(jazzProvider, syncStreamLocationString, f);
        InteropStream iStream = ConnectorOps.getInteropStream(syncStreamLocationString, syncStream, f);
        return iStream;
    }

    public static InteropStream getInteropStream(String syncStreamLocationString, Stream stream, Feedback f) throws WvcmException {
        InteropStream iStream = InteropStream.lookupInteropStream((Stream)stream, (Feedback)f);
        if (iStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_SYNC_STREAM_WITH_NAME, (Object)syncStreamLocationString, (Object[])new Object[0]), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return iStream;
    }

    public static List<InteropStream> getInteropStreams(JzProvider provider, boolean locallySyncd, String thisHostname, boolean verbose, Feedback feedback) throws WvcmException {
        ArrayList<InteropStream> results = new ArrayList<InteropStream>();
        List<Stream> synchronizedStreams = ConnectorOps.getSynchronizedStreamsInMyProcessAreas(provider, verbose, feedback);
        for (Stream stream : synchronizedStreams) {
            InteropStream interopStream = InteropStream.lookupInteropStream((Stream)stream, (Feedback)feedback);
            if (interopStream == null) continue;
            String streamsSyncHost = JzProvider.getSyncHost((Map)interopStream.thisProvider().initArgs());
            if (locallySyncd && !streamsSyncHost.equalsIgnoreCase(thisHostname)) continue;
            results.add(interopStream);
        }
        return results;
    }

    public static Map<String, String> getSyncRoots(boolean getOther, InteropStream stream, Feedback feedback) throws WvcmException {
        String[] locations;
        Workspace ws = getOther ? stream.thatSyncWs() : stream.thisCloneWs();
        List syncRoots = getOther ? stream.thatSyncRoots(ws, feedback) : stream.thisSyncRoots(ws, feedback);
        String[] stringArray = locations = getOther ? stream.thatSegment().get_syncRootPaths() : stream.thisSegment().get_syncRootPaths();
        assert (syncRoots.size() == locations.length);
        HashMap<String, String> results = new HashMap<String, String>(locations.length);
        int i = 0;
        while (i < locations.length) {
            results.put(ConnectorOps.getWorkspaceRelativePath((ControllableResource)syncRoots.get(i)), locations[i]);
            ++i;
        }
        return results;
    }

    public static List<String> getSyncRootList(boolean getOther, InteropStream stream, Feedback feedback) throws WvcmException {
        String[] locations;
        Workspace ws = getOther ? stream.thatSyncWs() : stream.thisCloneWs();
        List syncRoots = getOther ? stream.thatSyncRoots(ws, feedback) : stream.thisSyncRoots(ws, feedback);
        String[] stringArray = locations = getOther ? stream.thatSegment().get_syncRootPaths() : stream.thisSegment().get_syncRootPaths();
        assert (syncRoots.size() == locations.length);
        ArrayList<String> results = new ArrayList<String>(locations.length);
        int i = 0;
        while (i < locations.length) {
            results.add(ConnectorOps.getWorkspaceRelativePath((ControllableResource)syncRoots.get(i)));
            ++i;
        }
        return results;
    }

    public static String getWorkspaceRelativePath(ControllableResource crArg) throws WvcmException {
        return ConnectorOps.getWorkspaceRelativePath(crArg, File.separator);
    }

    public static String getWorkspaceRelativePath(ControllableResource crArg, String separator) throws WvcmException {
        Location wsPathname;
        ControllableResource cr = (ControllableResource)crArg.doReadProperties((Feedback)PR_PATH_WS_PATH);
        Location crPathname = cr.getPathnameLocation();
        if (crPathname.equals(wsPathname = cr.getWorkspace().getPathnameLocation())) {
            return ".";
        }
        String path = crPathname.lastSegment();
        Location location = crPathname.parent();
        while (!location.equals(wsPathname)) {
            path = String.valueOf(location.lastSegment()) + separator + path;
            location = location.parent();
        }
        return path;
    }

    public static void showProperties(InteropStream interopStream, PrintWriter output, Feedback fb) throws WvcmException {
        output.println("Jazz properties:");
        ConnectorOps.printProperties(interopStream.thisProvider().initArgs(), output);
        output.println("ClearCase properties:");
        ConnectorOps.printProperties(interopStream.thatProvider().initArgs(), output);
        output.flush();
    }

    public static void printProperties(Map<String, String> thisProperties, PrintWriter writer) throws WvcmException {
        Object[] keys = thisProperties.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            writer.println(NLS.bind((String)"{0}: {1}", (Object)key, (Object[])new Object[]{thisProperties.get(key)}));
            ++n2;
        }
    }

    public static int showNewFilesFoldersToSync(InteropStream stream, PrintWriter writer, Feedback fb) throws WvcmException {
        InteropCore.InteropStreamOperation ops = stream.get_operation();
        String[] roots = stream.get_unprocessedArguments();
        WorkspaceProvider p = null;
        if (ops.equals((Object)InteropCore.InteropStreamOperation.EXPORT)) {
            writer.println(NLS.bind((String)"{0}: ", (Object)stream.thisProvider().displayName(), (Object[])new Object[0]));
            p = stream.thisProvider();
        } else {
            writer.println(NLS.bind((String)"{0}: ", (Object)stream.thatProvider().displayName(), (Object[])new Object[0]));
            p = stream.thatProvider();
        }
        String[] stringArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            ControllableResource cr = p.controllableResource(p.location(root));
            writer.println(ConnectorOps.getWorkspaceRelativePath(cr));
            ++n2;
        }
        writer.flush();
        return roots.length;
    }

    public static int showSyncdFilesFolders(InteropStream stream, PrintWriter writer, Feedback fb) throws WvcmException {
        int otherRootsSize;
        writer.println(NLS.bind((String)"{0}: ", (Object)stream.thisProvider().displayName(), (Object[])new Object[0]));
        List<String> roots = ConnectorOps.getSyncRootList(false, stream, fb);
        int result = otherRootsSize = roots.size();
        if (result == 0) {
            writer.println(Messages.ConnectorOps_INFO_NONE);
        } else {
            for (String root : roots) {
                writer.println(root);
            }
        }
        writer.println();
        writer.flush();
        writer.println(NLS.bind((String)"{0}: ", (Object)stream.thatProvider().displayName(), (Object[])new Object[0]));
        roots = ConnectorOps.getSyncRootList(true, stream, fb);
        result += otherRootsSize;
        if (otherRootsSize == 0) {
            writer.println(Messages.ConnectorOps_INFO_NONE);
        } else {
            for (String root : roots) {
                writer.println(root);
            }
        }
        writer.flush();
        return result;
    }

    public static void showCollectedSyncStats(InteropStream iStream, PrintWriter writer, PrintStream stream, Feedback fb) throws WvcmException {
        InteropCore.SyncStats thisCollector = iStream.getThisSyncStats();
        InteropCore.SyncStats otherCollector = iStream.getThatSyncStats();
        String thisProviderName = NLS.bind((String)"{0}: ", (Object)iStream.thisProvider().displayName(), (Object[])new Object[0]);
        String thisNumFilesCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FILES_CREATED), (Object[])new Object[0]);
        String thisNumFilesUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_UPDATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FILES_UPDATED), (Object[])new Object[0]);
        String thisNumFoldersCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FOLDERS_CREATED), (Object[])new Object[0]);
        String thisNumFoldersUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_UPDATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FOLDERS_UPDATED), (Object[])new Object[0]);
        String thisNumSymlinksCreated = NLS.bind((String)Messages.ConnectorOps_NUM_SYMLINKS_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.SYMLINKS_CREATED), (Object[])new Object[0]);
        String otherProviderName = NLS.bind((String)"{0}: ", (Object)iStream.thatProvider().displayName(), (Object[])new Object[0]);
        String otherNumFilesCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_CREATED, (Object)otherCollector.getAmount(InteropCore.SyncStatType.FILES_CREATED), (Object[])new Object[0]);
        String otherNumFilesUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_UPDATED, (Object)otherCollector.getAmount(InteropCore.SyncStatType.FILES_UPDATED), (Object[])new Object[0]);
        String otherNumFoldersCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_CREATED, (Object)otherCollector.getAmount(InteropCore.SyncStatType.FOLDERS_CREATED), (Object[])new Object[0]);
        String otherNumFoldersUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_UPDATED, (Object)otherCollector.getAmount(InteropCore.SyncStatType.FOLDERS_UPDATED), (Object[])new Object[0]);
        String otherNumSymlinksCreated = NLS.bind((String)Messages.ConnectorOps_NUM_SYMLINKS_CREATED, (Object)otherCollector.getAmount(InteropCore.SyncStatType.SYMLINKS_CREATED), (Object[])new Object[0]);
        if (writer != null) {
            writer.println(thisProviderName);
            writer.println(thisNumFilesCreated);
            writer.println(thisNumFilesUpdated);
            writer.println(thisNumFoldersCreated);
            writer.println(thisNumFoldersUpdated);
            writer.println(thisNumSymlinksCreated);
            writer.println();
            writer.flush();
            writer.println(otherProviderName);
            writer.println(otherNumFilesCreated);
            writer.println(otherNumFilesUpdated);
            writer.println(otherNumFoldersCreated);
            writer.println(otherNumFoldersUpdated);
            writer.println(otherNumSymlinksCreated);
            writer.flush();
        } else if (stream != null) {
            stream.println(thisProviderName);
            stream.println(thisNumFilesCreated);
            stream.println(thisNumFilesUpdated);
            stream.println(thisNumFoldersCreated);
            stream.println(thisNumFoldersUpdated);
            stream.println(thisNumSymlinksCreated);
            stream.flush();
            stream.println(otherProviderName);
            stream.println(otherNumFilesCreated);
            stream.println(otherNumFilesUpdated);
            stream.println(otherNumFoldersCreated);
            stream.println(otherNumFoldersUpdated);
            stream.println(otherNumSymlinksCreated);
            stream.flush();
        }
    }

    public static int executePostOperation(String commandPath, BuildResultUpdater buildResultUpdater, InteropStream is, Map<String, String> properties, WvcmException syncResult) throws WvcmException {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (properties != null) {
            newProperties.putAll(properties);
        }
        properties = newProperties;
        if (syncResult != null) {
            properties.put(SYNC_STATUS_PROP, syncResult.getReasonCode().toString());
            properties.put(SYNC_ERROR_MSG_PROP, syncResult.getMessage());
        } else {
            properties.put(SYNC_STATUS_PROP, is.get_state().toString());
        }
        return ConnectorOps.executeOperation(false, commandPath, buildResultUpdater, is, properties);
    }

    public static int executeOperation(boolean preOp, String commandPath, BuildResultUpdater buildResultUpdater, InteropStream is, Map<String, String> properties) throws WvcmException {
        ProcessBuilder pb = new ProcessBuilder(ConnectorOps.tokenizeCommandLine(commandPath));
        ConnectorOps.addInitArgsToEnv(pb, is.thisProvider().initArgs(), JZ_INITARG_PREFIX);
        ConnectorOps.addInitArgsToEnv(pb, is.thatProvider().initArgs(), CT_INITARG_PREFIX);
        if (properties != null) {
            pb.environment().putAll(properties);
        }
        String message = preOp ? Messages.ConnectorOps_INFO_RUN_PRESYNC : Messages.ConnectorOps_INFO_RUN_POSTSYNC;
        String label = NLS.bind((String)message, (Object)commandPath, (Object[])new Object[0]);
        System.out.println(label);
        if (buildResultUpdater != null) {
            String activityID = buildResultUpdater.startTopLevelActivity(label);
            pb.environment().put(SYNC_OP_ACTIVIY_ID, activityID);
        }
        if (buildResultUpdater != null) {
            pb = pb.redirectErrorStream(true);
        }
        try {
            Thread outThread;
            Process child = null;
            try {
                child = pb.start();
            }
            catch (IOException ioException) {
                String error = preOp ? Messages.ConnectorOps_ERROR_RUN_PRESYNC : Messages.ConnectorOps_ERROR_RUN_POSTSYNC;
                String explanation = preOp ? Messages.ConnectorOps_ERROR_RUN_PRESYNC$explanation : Messages.ConnectorOps_ERROR_RUN_POSTSYNC$explanation;
                String useraction = preOp ? Messages.ConnectorOps_ERROR_RUN_PRESYNC$useraction : Messages.ConnectorOps_ERROR_RUN_POSTSYNC$useraction;
                throw new WvcmException(String.valueOf(NLS.bind((String)error, (Object)commandPath, (Object[])new Object[0])) + "\n" + explanation + " " + useraction, WvcmException.ReasonCode.FORBIDDEN, (Throwable)ioException);
            }
            Thread errThread = null;
            final StringWriter outString = new StringWriter();
            if (buildResultUpdater == null) {
                outThread = new Thread(new StreamRedirector(child.getInputStream(), new PrintWriter(System.out)));
                errThread = new Thread(new StreamRedirector(child.getErrorStream(), new PrintWriter(System.err)));
            } else {
                outThread = new Thread(new StreamRedirector(child.getInputStream(), new PrintWriter(outString)));
            }
            outThread.start();
            if (errThread != null) {
                errThread.start();
            }
            int rtval = child.waitFor();
            outThread.join(10000L);
            if (errThread != null) {
                errThread.join(10000L);
            }
            if (outString.toString().length() > 0) {
                String fileName = preOp ? "preSyncOperation.log" : "postSyncOperation.log";
                message = preOp ? Messages.ConnectorOps_LABEL_PRESYNC_LOG : Messages.ConnectorOps_LABEL_POSTSYNC_LOG;
                buildResultUpdater.contribute(message, fileName, BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        writer.print(outString.toString());
                    }
                });
            }
            return rtval;
        }
        catch (WvcmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WvcmException(e.getMessage(), WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static void addInitArgsToEnv(ProcessBuilder pb, Map<String, String> initArgs, String prefix) {
        for (String key : initArgs.keySet()) {
            String value = initArgs.get(key);
            int index = key.lastIndexOf(46);
            String newKey = null;
            newKey = index < 0 || index + 1 == key.length() ? key : String.valueOf(prefix) + key.substring(index + 1);
            pb.environment().put(newKey, value);
        }
    }

    public static List<String> tokenizeCommandLine(String commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException();
        }
        boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
        if (IS_WINDOWS) {
            return ConnectorOps.tokenizeWinCommandLine(commandLine);
        }
        return ConnectorOps.tokenizeUnixCommandLine(commandLine);
    }

    public static List<String> tokenizeWinCommandLine(String commandLine) {
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        boolean inQuote = false;
        while (i < commandLine.length()) {
            switch (commandLine.charAt(i)) {
                case '\n': {
                    if (i > 0) {
                        tokens.add(commandLine.substring(0, i));
                    }
                    commandLine = "";
                    i = 0;
                    break;
                }
                case ' ': {
                    if (!inQuote) {
                        if (i > 0) {
                            tokens.add(commandLine.substring(0, i));
                        }
                        commandLine = commandLine.substring(i + 1);
                        i = 0;
                        break;
                    }
                    ++i;
                    break;
                }
                case '\"': {
                    inQuote = !inQuote;
                }
                default: {
                    ++i;
                }
            }
        }
        if (i > 0) {
            tokens.add(commandLine.substring(0, i));
        }
        return tokens;
    }

    public static List<String> tokenizeUnixCommandLine(String commandLine) {
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        QuoteBy quote = QuoteBy.Unquoted;
        while (i < commandLine.length()) {
            switch (commandLine.charAt(i)) {
                case '\n': {
                    if (i > 0) {
                        tokens.add(commandLine.substring(0, i));
                    }
                    commandLine = "";
                    i = 0;
                    break;
                }
                case ' ': {
                    if (quote == QuoteBy.Unquoted) {
                        if (i > 0) {
                            tokens.add(commandLine.substring(0, i));
                        }
                        commandLine = commandLine.substring(i + 1);
                        i = 0;
                        break;
                    }
                    ++i;
                    break;
                }
                case '\\': {
                    commandLine = String.valueOf(commandLine.substring(0, i)) + commandLine.substring(i + 1);
                    i = Math.min(i + 1, commandLine.length());
                    break;
                }
                case '\"': {
                    if (quote == QuoteBy.QuoteDouble) {
                        quote = QuoteBy.Unquoted;
                        commandLine = String.valueOf(commandLine.substring(0, i)) + commandLine.substring(i + 1);
                        break;
                    }
                    if (quote == QuoteBy.Unquoted) {
                        quote = QuoteBy.QuoteDouble;
                        commandLine = String.valueOf(commandLine.substring(0, i)) + commandLine.substring(i + 1);
                        break;
                    }
                    ++i;
                    break;
                }
                case '\'': {
                    if (quote == QuoteBy.QuoteSingle) {
                        quote = QuoteBy.Unquoted;
                        commandLine = String.valueOf(commandLine.substring(0, i)) + commandLine.substring(i + 1);
                        break;
                    }
                    if (quote == QuoteBy.Unquoted) {
                        quote = QuoteBy.QuoteSingle;
                        commandLine = String.valueOf(commandLine.substring(0, i)) + commandLine.substring(i + 1);
                        break;
                    }
                    ++i;
                    break;
                }
                default: {
                    ++i;
                }
            }
        }
        if (i > 0) {
            tokens.add(commandLine.substring(0, i));
        }
        return tokens;
    }

    public static List<ControllableResource> convertPathsToCRs(Collection<String> rootPaths, Workspace currWs, WorkspaceProvider currProvider, Feedback fb) throws WvcmException {
        int size = rootPaths.size();
        ArrayList<ControllableResource> rootCRs = new ArrayList<ControllableResource>(size);
        boolean bIsWindowsOS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
        int nPath = 1;
        for (String path : rootPaths) {
            String separator = File.separator;
            if (bIsWindowsOS) {
                separator = String.valueOf(separator) + File.separator;
            }
            String[] currFields = path.split(separator);
            Location currLoc = currWs.location();
            String[] stringArray = currFields;
            int n = currFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                if (field.length() > 0) {
                    currLoc = currLoc.child(field);
                }
                ++n2;
            }
            ControllableResource currCR = currProvider.controllableResource(currLoc);
            if (!ConnectorOps.exists(currCR)) {
                fb.notifyActive(fb.format(Messages.ConnectorOps_ERROR_PATH_DOES_NOT_EXIST, new Object[]{path}));
                return null;
            }
            Configuration config = (Configuration)(currCR = (ControllableResource)currCR.doReadProperties((Feedback)PR_CONFIG_PROP)).getProperty(ControllableResource.CONFIGURATION);
            if (config == null) {
                String message = Messages.ConnectorOps_ERROR_PATH_NOT_UNDER_CONFIG;
                if (currCR instanceof ControllableSymbolicLink) {
                    message = Messages.ConnectorOps_ERROR_CANNOT_SELECT_SYMBOLIC_LINK;
                }
                fb.notifyActive(fb.format(message, new Object[]{path}));
                return null;
            }
            rootCRs.add(currCR);
            fb.notifyPercentComplete(nPath * 100 / size);
            ++nPath;
        }
        return rootCRs;
    }

    private static boolean exists(ControllableResource cr) throws WvcmException {
        try {
            cr.doReadProperties((Feedback)PR_ID);
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public static CTProvider getCtProvider(Map<String, String> sourceInitArgs) throws WvcmException {
        CTProvider sourceP = (CTProvider)PluginProviderFactory.pluginCreateProvider((String)"com.ibm.rational.wvcm.ct.CTProvider", null, (Map)(sourceInitArgs != null ? sourceInitArgs : new HashMap()));
        return sourceP;
    }

    public static UcmImporter createUcmImporter(JzProvider stagingProvider, String installLoc, String password, String buildEngineSleepTime, boolean startJBE, String streamSelector, Map<String, String> sourceInitArgs, Feedback feedback) throws WvcmException {
        Feedback fb = DetailedFeedback.fb((Feedback)feedback);
        String syncUserId = stagingProvider.getSyncUserId();
        IProcessArea paHandle = stagingProvider.getProcessArea(stagingProvider.srvcFeedback(fb.nest(20)));
        BuildClientForCc.validateSyncUser((JzProvider)stagingProvider, (String)syncUserId, (boolean)true, (IProcessAreaHandle)paHandle, (String)password, (Feedback)fb.nest(40));
        CTProvider ctProvider = ConnectorOps.getCtProvider(sourceInitArgs);
        Stream sourceStream = ctProvider.stream((Location)ctProvider.rootLocation());
        sourceStream.setDisplayName(streamSelector);
        sourceStream = (Stream)sourceStream.doFindOne(fb.nest(60));
        UcmImporter importer = null;
        try {
            importer = UcmImporter.newUcmImporter((WorkspaceProvider)stagingProvider, (Stream)sourceStream, (Feedback)fb.nest(80));
        }
        catch (WvcmException we) {
            if (WvcmException.ReasonCode.CANNOT_OVERWRITE.equals((Object)we.getReasonCode())) {
                Task importerTask = (Task)we.getResource();
                importer = UcmImporter.getUcmImporter((Task)importerTask, (Feedback)fb.nest(85));
                HashMap<String, String> newArgs = new HashMap<String, String>();
                String specifiedProcPath = JzProvider.getProcessAreaPath((Map)stagingProvider.initArgs());
                if (!JzProvider.getProcessAreaPath((Map)importer.destinationProvider().initArgs()).equals(specifiedProcPath)) {
                    IProjectArea procAreaInRepo;
                    IProjectArea procAreaSpecified = stagingProvider.getProjectArea(null);
                    if (procAreaSpecified.sameItemId((IItemHandle)(procAreaInRepo = ((JzProvider)importer.destinationProvider()).getProjectArea(null)))) {
                        JzProvider.setProcessAreaPathInitArg(newArgs, (String)specifiedProcPath);
                    } else {
                        throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_IMPORTER_PROJECT_AREA, (Object)procAreaInRepo.getName(), (Object[])new Object[0]), WvcmException.ReasonCode.FORBIDDEN);
                    }
                }
                JzProvider.setSyncUserId(newArgs, (String)syncUserId);
                importer.updateDestInitArgs(newArgs, fb.nest(85));
                newArgs.clear();
                if (sourceInitArgs != null) {
                    newArgs.putAll(sourceInitArgs);
                }
                UcmImporter.setSourceStreamInitArg(newArgs, (Stream)sourceStream);
                importer.updateSourceInitArgs(newArgs, fb.nest(90));
                fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_INFO_UPDATE_EXISTING_IMPORTER, (Object)importerTask.getProperty(InteropUtilities.PN_TASK_ID), (Object[])new Object[0]));
            }
            throw we;
        }
        BuildClientForCcImport client = new BuildClientForCcImport(importer);
        client.setup(installLoc, password, buildEngineSleepTime, startJBE, fb.nest(100));
        return importer;
    }

    public static void deleteUcmImporter(UcmImporter ucmImporter, Feedback feedback) throws WvcmException {
        Feedback fb = DetailedFeedback.fb((Feedback)feedback);
        UcmImporter.tryRemoveWorkspace((Workspace)ucmImporter.getSourceWorkspace(fb), (Feedback)fb);
        Task task = ucmImporter.destinationImporterTask();
        task.removeProperty(UcmImporter.PN_UCM_IMPORTER_CLONE);
        task.doWriteProperties(fb.nest(30));
        BuildClientForCcImport client = new BuildClientForCcImport(ucmImporter);
        client.deleteMyBuildObjects(fb.nest(80));
        task.removeProperty(UcmImporter.PN_UCM_IMPORTER);
        task.doWriteProperties(fb.nest(100));
    }

    public static void showProperties(UcmImporter importer, PrintWriter output, Feedback fb) throws WvcmException {
        output.println(Messages.ConnectorOps_INFO_JZ_PROPERTIES);
        ConnectorOps.printProperties(importer.destinationProvider().initArgs(), output);
        output.println(Messages.ConnectorOps_INFO_CT_PROPERTIES);
        ConnectorOps.printProperties(importer.sourceProvider().initArgs(), output);
        output.flush();
    }

    public static void showCollectedImportcStats(UcmImporter importer, PrintWriter writer, PrintStream stream, Feedback fb) throws WvcmException {
        InteropCore.SyncStats thisCollector = importer.getImportStats();
        String thisProviderName = NLS.bind((String)"{0}: ", (Object)importer.destinationProvider().displayName(), (Object[])new Object[0]);
        String thisNumFilesCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FILES_CREATED), (Object[])new Object[0]);
        String thisNumFilesUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FILES_UPDATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FILES_UPDATED), (Object[])new Object[0]);
        String thisNumFoldersCreated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FOLDERS_CREATED), (Object[])new Object[0]);
        String thisNumFoldersUpdated = NLS.bind((String)Messages.ConnectorOps_NUM_FOLDERS_UPDATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.FOLDERS_UPDATED), (Object[])new Object[0]);
        String thisNumSymlinksCreated = NLS.bind((String)Messages.ConnectorOps_NUM_SYMLINKS_CREATED, (Object)thisCollector.getAmount(InteropCore.SyncStatType.SYMLINKS_CREATED), (Object[])new Object[0]);
        if (writer != null) {
            writer.println(thisProviderName);
            writer.println(thisNumFilesCreated);
            writer.println(thisNumFilesUpdated);
            writer.println(thisNumFoldersCreated);
            writer.println(thisNumFoldersUpdated);
            writer.println(thisNumSymlinksCreated);
            writer.println();
            writer.flush();
        } else if (stream != null) {
            stream.println(thisProviderName);
            stream.println(thisNumFilesCreated);
            stream.println(thisNumFilesUpdated);
            stream.println(thisNumFoldersCreated);
            stream.println(thisNumFoldersUpdated);
            stream.println(thisNumSymlinksCreated);
            stream.flush();
        }
    }

    public static void importStreams(UcmImporter importer, TaskDetailedFeedback fb) throws Throwable {
        UcmImporter imp;
        final Feedback noProgress = fb.nest();
        BuildResultUpdater buildResultUpdater = fb.getBuildResult();
        JzProvider p = (JzProvider)importer.destinationProvider();
        if (buildResultUpdater != null) {
            IBuildResult buildResult = buildResultUpdater.getBuildResult(null);
            String relativeLocationString = com.ibm.team.repository.common.Location.itemLocation((IItemHandle)buildResult, null).toRelativeUri().toString();
            String storedBuildResultLocString = p.lookupBuildResultLocationString();
            if (storedBuildResultLocString == null || !storedBuildResultLocString.equals(relativeLocationString)) {
                if (storedBuildResultLocString == null) {
                    storedBuildResultLocString = "null";
                }
                fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_UPDATING_BUILD_RESULT_ID_WITH_OLD_VALUE, (Object)storedBuildResultLocString, (Object[])new Object[0]));
                BuildClientForCcImport buildClient = new BuildClientForCcImport(importer);
                buildClient.persistCurrentBuildResultId((IBuildResultHandle)buildResult, noProgress);
            }
            try {
                imp = importer;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_INIT_ARGS, "importerProperties.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showProperties(imp, writer, noProgress);
                    }
                });
            }
            catch (Exception e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_INIT_ARGS, (Object[])new Object[]{e.getMessage()}));
            }
        }
        Throwable doOperationThrowable = null;
        try {
            importer.doOperation((Feedback)fb);
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN.equals((Object)e.getReasonCode())) {
                fb.notifyActive(Messages.ConnectorOps_INFO_REFRESHING_INTEROPSTREAM);
                importer = importer.refresh(noProgress);
            } else {
                doOperationThrowable = e;
            }
        }
        catch (Throwable e) {
            doOperationThrowable = e;
        }
        boolean testingThrownExceptions = JzProvider.testingThrownException((String)"com.ibm.team.connector.scm.operations.forceSyncException");
        if (testingThrownExceptions) {
            try {
                throw new WvcmException("Testing exception handling (first one)", WvcmException.ReasonCode.NOT_FOUND);
            }
            catch (WvcmException e) {
                if (buildResultUpdater != null) {
                    buildResultUpdater.contributeExceptionStackTrace(e);
                }
                throw new WvcmException("Testing exception handling (wrapper)", null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)e);
            }
        }
        String completionMessage = Messages.ConnectorOps_STATUS_SYNC_COMPLETE_NO_CONFLICTS;
        if (buildResultUpdater != null) {
            try {
                imp = importer;
                buildResultUpdater.contribute(Messages.ConnectorOps_LABEL_SYNC_STATS, "importerStatistics.txt", BuildStatus.OK, new BuildResultUpdater.Contributor(){

                    @Override
                    public void writeContribution(PrintWriter writer) throws WvcmException {
                        ConnectorOps.showCollectedImportcStats(imp, writer, null, noProgress);
                    }
                });
            }
            catch (Throwable e) {
                fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_BUILD_RESULT_WITH_FILENAME_EXCEPTION_MSG, (Object)Messages.ConnectorOps_LABEL_SYNC_STATS, (Object[])new Object[]{e.getMessage()}));
            }
            if (doOperationThrowable == null && importer.get_state() != InteropCore.InteropStreamState.OPERATION_CANCELED) {
                try {
                    buildResultUpdater.startTopLevelActivity(completionMessage);
                    buildResultUpdater.setCompletionStatus(true);
                }
                catch (Throwable e) {
                    fb.notifyWarning(NLS.bind((String)Messages.ConnectorOps_WARN_CANT_STORE_COMPLETION_MSG_AND_STATUS_WITH_EXCEPTION_MSG, (Object)e.getMessage(), (Object[])new Object[0]));
                }
            }
        }
        try {
            ConnectorOps.showCollectedImportcStats(importer, null, fb.get_out(), noProgress);
        }
        catch (Throwable throwable) {}
        if (doOperationThrowable != null) {
            throw doOperationThrowable;
        }
        if (buildResultUpdater == null) {
            fb.notifyActive(completionMessage);
        }
    }

    public static void listUcmImporterLinks(JzProvider provider, boolean verbose) throws WvcmException {
        System.out.println(ConnectorOps.getBVNMessage(provider, "com.ibm.team.connector.scm.operations"));
        try {
            JzRepoResource.CountingVisitor countingVisitor = new JzRepoResource.CountingVisitor(verbose);
            JzRepoResource.forEachLink((JzProvider)provider, (String)CcConnectorUtils.TRACKS_UCM_METADATA_OBJECT, (JzRepoResource.IVisitCloneLink)countingVisitor);
            System.out.println(NLS.bind((String)Messages.ConnectorOps_INFO_LIST_TRACKS_LINKS, (Object)countingVisitor.getMatches(), (Object[])new Object[0]));
            countingVisitor.reset();
            JzRepoResource.forEachLink((JzProvider)provider, (String)CcConnectorUtils.UCM_IMP_WORK_ITEM_DEPENDS_UPON_LINK_TYPE, (JzRepoResource.IVisitCloneLink)countingVisitor);
            System.out.println(NLS.bind((String)Messages.ConnectorOps_INFO_LIST_DEPENDS_LINKS, (Object)countingVisitor.getMatches(), (Object[])new Object[0]));
            countingVisitor.reset();
            JzRepoResource.forEachLink((JzProvider)provider, (String)CcConnectorUtils.UCM_IMP_SRC, (JzRepoResource.IVisitCloneLink)countingVisitor);
            System.out.println(NLS.bind((String)Messages.ConnectorOps_INFO_LIST_IMPORTED_LINKS, (Object)countingVisitor.getMatches(), (Object[])new Object[0]));
        }
        catch (WvcmException we) {
            throw we;
        }
        catch (Exception e) {
            throw new RuntimeException(NLS.bind((String)Messages.ConnectorOps_ERROR_COMMAND_FAILED, (Object)"UcmImporterLinks", (Object[])new Object[0]), e);
        }
    }

    public static List<Baseline> findThisBaselinesForOtherStreamFoundation(Stream otherStream, WorkspaceProvider thisProvider, Feedback feedback) throws WvcmException {
        List results = null;
        List otherBls = InteropUtilities.doFindAllCompositeBaselinesInStream((Stream)otherStream, (Feedback)InteropUtilities.PR_DN_BL_SUBS_DN);
        if (!otherBls.isEmpty()) {
            String name = ((Baseline)otherBls.get(0)).getDisplayName();
            results = InteropUtilities.doFindNamedBaselines((WorkspaceProvider)thisProvider, (String)name, (Feedback)feedback);
        }
        return results;
    }

    public static String validateAttype(CTProvider ctProvider, String atTypeSelector) throws WvcmException {
        String kind = ConnectorOps.validateObjSelKind("attype", atTypeSelector);
        String sel = kind == null ? atTypeSelector : ObjSelUtils.formatSelectorNoKind((String)atTypeSelector);
        try {
            ctProvider.validateBaselineFilter(sel);
        }
        catch (WvcmException wvcmException) {
            String msg = NLS.bind((String)Messages.ConnectorOps_ERR_ATTYPE_NOT_FOUND, (Object)atTypeSelector, (Object[])new Object[]{"cleartool describe attype:" + sel});
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        return sel;
    }

    public static String validateObjSelKind(String expectedKind, String selector) throws WvcmException {
        String kind = ObjSelUtils.getObjSelKind((String)selector);
        if (!kind.isEmpty() && !expectedKind.equals(kind)) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERR_UNEXPECTED_OBJ_SEL_KIND, (Object)expectedKind, (Object[])new Object[]{kind}), WvcmException.ReasonCode.FORBIDDEN);
        }
        return kind.isEmpty() ? null : kind;
    }

    public static String validateBrtype(CTProvider ctProvider, String brTypeSelector) throws WvcmException {
        String kind = ConnectorOps.validateObjSelKind("brtype", brTypeSelector);
        String sel = kind == null ? brTypeSelector : ObjSelUtils.formatSelectorNoKind((String)brTypeSelector);
        try {
            ctProvider.validateBranchType(sel);
        }
        catch (WvcmException wvcmException) {
            String msg = NLS.bind((String)Messages.ConnectorOps_ERR_BRTYPE_NOT_FOUND, (Object)brTypeSelector, (Object[])new Object[]{"cleartool describe brtype:" + sel});
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        return sel;
    }

    public static String validateLbtype(CTProvider ctProvider, String lbTypeSelector) throws WvcmException {
        String kind = ConnectorOps.validateObjSelKind("lbtype", lbTypeSelector);
        String sel = kind == null ? lbTypeSelector : ObjSelUtils.formatSelectorNoKind((String)lbTypeSelector);
        try {
            ctProvider.validateLabelType(sel);
        }
        catch (WvcmException wvcmException) {
            String msg = NLS.bind((String)Messages.ConnectorOps_ERR_LBTYPE_NOT_FOUND, (Object)lbTypeSelector, (Object[])new Object[]{"cleartool describe lbtype:" + sel});
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        return sel;
    }

    public static InteropStream createBaseCcSyncStream(JzProvider jazzProvider, String installLoc, String password, String buildEngineSleepTime, boolean startJBE, String brtypeSelector, String lbtypeSelector, String mergeWorkspaceName, IBaselineSetHandle snapshotHandle, Map<String, String> sourceInitArgs, Feedback feedback) throws WvcmException {
        CTProvider p = ConnectorOps.getCtProvider(sourceInitArgs);
        String brtype = ConnectorOps.validateBrtype(p, brtypeSelector);
        String streamSelector = String.valueOf(brtype) + CTProvider.BASECC_CHAR;
        if (lbtypeSelector != null) {
            String sel = ConnectorOps.validateLbtype(p, lbtypeSelector);
            streamSelector = String.valueOf(streamSelector) + sel;
        }
        return ConnectorOps.createSyncStream(false, jazzProvider, installLoc, password, buildEngineSleepTime, startJBE, ObjSelUtils.getObjSelName((String)streamSelector), streamSelector, null, mergeWorkspaceName, snapshotHandle, sourceInitArgs, feedback);
    }

    public static InteropStream createBaseCcImportOnlyStream(JzProvider jazzProvider, String installLoc, String password, String buildEngineSleepTime, boolean startJBE, String attypeSelector, String lbtypeSelector, String mergeWorkspaceName, IBaselineSetHandle snapshot, Map<String, String> sourceInitArgs, Feedback feedback) throws WvcmException {
        CTProvider p = ConnectorOps.getCtProvider(sourceInitArgs);
        lbtypeSelector = ConnectorOps.validateLbtype(p, lbtypeSelector);
        String streamSelector = String.valueOf(CTProvider.BASECC_CHAR) + lbtypeSelector;
        return ConnectorOps.createSyncStream(true, jazzProvider, installLoc, password, buildEngineSleepTime, startJBE, ObjSelUtils.getObjSelName((String)lbtypeSelector), streamSelector, attypeSelector, mergeWorkspaceName, snapshot, sourceInitArgs, feedback);
    }

    public static InteropStream createUcmSyncStream(boolean importOnly, JzProvider jazzProvider, String installLoc, String password, String buildEngineSleepTime, boolean startJBE, String streamSelector, String attypeSelector, String mergeWorkspaceName, IBaselineSetHandle snapshotHandle, Map<String, String> sourceInitArgs, Feedback feedback) throws WvcmException {
        return ConnectorOps.createSyncStream(importOnly, jazzProvider, installLoc, password, buildEngineSleepTime, startJBE, ObjSelUtils.getObjSelName((String)streamSelector), streamSelector, attypeSelector, mergeWorkspaceName, snapshotHandle, sourceInitArgs, feedback);
    }

    private static InteropStream createSyncStream(boolean importOnly, JzProvider jazzProvider, String installLoc, String password, String buildEngineSleepTime, boolean startJBE, String streamName, String streamSelector, String attypeSelector, String mergeWorkspaceName, IBaselineSetHandle snapshotHandle, Map<String, String> sourceInitArgs, Feedback feedback) throws WvcmException {
        Feedback fb = DetailedFeedback.fb((Feedback)feedback);
        CTProvider ctProvider = ConnectorOps.getCtProvider(sourceInitArgs);
        if (attypeSelector != null) {
            attypeSelector = ConnectorOps.validateAttype(ctProvider, attypeSelector);
        }
        String syncUserId = jazzProvider.getSyncUserId();
        IProcessArea paHandle = jazzProvider.getProcessArea(jazzProvider.srvcFeedback(fb.nest(10)));
        BuildClientForCc.validateSyncUser((JzProvider)jazzProvider, (String)syncUserId, (boolean)true, (IProcessAreaHandle)paHandle, (String)password, (Feedback)fb.nest(20));
        Stream sourceStream = ctProvider.stream((Location)ctProvider.rootLocation());
        sourceStream.setDisplayName(streamSelector);
        sourceStream = (Stream)sourceStream.doFind(fb.nest(30));
        if (sourceStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERR_SRC_NOT_FOUND, (Object)streamName, (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        InteropStream result = InteropUtilities.createInteropStream((Provider)ctProvider, (Provider)jazzProvider);
        ResourceList<Baseline> initialThisSources = ConnectorOps.getBaselines(jazzProvider, snapshotHandle, fb.nest(35));
        result.initialize(sourceStream, importOnly, initialThisSources, fb.nest(40));
        String syncStreamName = (String)InteropUtilities.doReadProperty((Resource)result.thisSyncStream(), (PropertyNameList.PropertyName)Resource.DISPLAY_NAME, (Feedback)fb.nest(50));
        fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_INFO_CREATED_SYNC_STREAM, (Object)syncStreamName, (Object[])new Object[0]));
        if (attypeSelector != null) {
            result.setBaselineFilter(attypeSelector, fb.nest(60));
        }
        if (mergeWorkspaceName == null) {
            String userId = jazzProvider.getRepo().loggedInContributor().getUserId();
            mergeWorkspaceName = String.format("%s_%s", userId, streamName);
        }
        Workspace mergeWs = result.newThisMergeWs(mergeWorkspaceName, fb.nest(InteropUtilities.PR_DN, 80));
        fb.notifyActive(NLS.bind((String)Messages.ConnectorOps_INFO_CREATED_MERGE_WS, (Object)mergeWs.getDisplayName(), (Object[])new Object[0]));
        BuildClientForCcSync client = new BuildClientForCcSync(result);
        client.setup(installLoc, password, buildEngineSleepTime, startJBE, fb.nest(90));
        return result;
    }

    public static ResourceList<Baseline> getBaselines(JzProvider p, IBaselineSetHandle initialSnapshot, Feedback f) throws WvcmException {
        ResourceList baselines = p.resourceList((Resource[])new Baseline[0]);
        if (initialSnapshot != null) {
            JzRepoBaseline snapshot = JzRepoBaseline.createSnapshot((JzProvider)p, (IBaselineSetHandle)initialSnapshot);
            List jrbs = snapshot.getSubBaselineList(new SrvcFeedback(f));
            for (JzRepoBaseline jzRepoBaseline : jrbs) {
                baselines.add((Object)p.baseline((Location)jzRepoBaseline.location()));
            }
        }
        return baselines;
    }

    static enum QuoteBy {
        Unquoted,
        QuoteSingle,
        QuoteDouble;

    }

    private static class StreamRedirector
    implements Runnable {
        private final BufferedReader fInputStreamReader;
        private final PrintWriter fOutputStreamWriter;

        public StreamRedirector(InputStream inputStream, PrintWriter writer) {
            this.fInputStreamReader = new BufferedReader(new InputStreamReader(inputStream));
            this.fOutputStreamWriter = writer;
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.fInputStreamReader.readLine()) != null) {
                    this.fOutputStreamWriter.println(line);
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this.fOutputStreamWriter.flush();
        }
    }
}

