/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFACreateLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;

public final class ComponentLock
extends AbstractLock {
    final ILocation cfaPath;
    private final IComponentHandle component;
    private final IContextHandle connection;

    public ComponentLock(ILocation cfaPath, IContextHandle connectableHandle, IComponentHandle component) {
        this.cfaPath = cfaPath;
        this.component = component;
        this.connection = connectableHandle;
    }

    @Override
    public boolean contains(AbstractLock rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (rule instanceof ComponentLock) {
            ComponentLock other = (ComponentLock)rule;
            return this.cfaPath.equals(other.cfaPath) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }
        if (rule instanceof CFAReadLock) {
            return this.cfaPath.equals(((CFAReadLock)rule).cfaPath);
        }
        return false;
    }

    @Override
    public boolean isConflicting(AbstractLock rule) {
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] abstractLockArray = multi.getChildren();
            int n = abstractLockArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLock child = abstractLockArray[n2];
                if (this.isConflicting(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (rule == GlobalLock.INSTANCE) {
            return true;
        }
        if (rule instanceof ComponentLock) {
            ComponentLock other = (ComponentLock)rule;
            return this.cfaPath.equals(other.cfaPath) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }
        if (rule instanceof CFARemoveLock) {
            return this.cfaPath.equals(((CFARemoveLock)rule).cfaPath);
        }
        if (rule instanceof GlobalCFALock) {
            return this.cfaPath.equals(((GlobalCFALock)rule).cfaPath);
        }
        return false;
    }

    public int hashCode() {
        return this.cfaPath.hashCode() ^ this.component.getItemId().hashCode() ^ this.connection.getItemId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentLock)) {
            return false;
        }
        ComponentLock other = (ComponentLock)o;
        return this.cfaPath.equals(other.cfaPath) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
    }

    @Override
    public boolean mayPromoteTo(AbstractLock rule) {
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.mayPromoteTo(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.contains(rule)) {
            return true;
        }
        if (rule == CFAListReadLock.INSTANCE) {
            return true;
        }
        if (rule == CFACreateLock.INSTANCE) {
            return true;
        }
        return rule instanceof CFAReadLock;
    }

    public String toString() {
        return "ComponentLock(" + this.cfaPath + ", " + this.connection.getItemId().getUuidValue() + ", " + this.component.getItemId().getUuidValue() + ')';
    }
}

